/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.web.service;

import org.apache.nifi.registry.properties.NiFiRegistryProperties;
import org.apache.nifi.registry.revision.api.RevisionManager;
import org.apache.nifi.registry.revision.entity.RevisableEntityService;
import org.apache.nifi.registry.revision.entity.StandardRevisableEntityService;
import org.apache.nifi.registry.revision.jdbc.JdbcRevisionManager;
import org.apache.nifi.registry.web.service.RevisionFeature;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;

@Configuration
public class RevisionConfiguration {
    @Bean
    public synchronized RevisionManager getRevisionManager(JdbcTemplate jdbcTemplate) {
        return new JdbcRevisionManager(jdbcTemplate);
    }

    @Bean
    public synchronized RevisableEntityService getRevisableEntityService(RevisionManager revisionManager) {
        return new StandardRevisableEntityService(revisionManager);
    }

    @Bean
    public synchronized RevisionFeature getRevisionFeature(NiFiRegistryProperties properties) {
        return () -> properties.areRevisionsEnabled();
    }
}

