/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.web.security.authentication.x509;

import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.apache.nifi.registry.security.authentication.AuthenticationRequest;
import org.apache.nifi.registry.security.authentication.AuthenticationResponse;
import org.apache.nifi.registry.security.authentication.IdentityProvider;
import org.apache.nifi.registry.security.authentication.IdentityProviderConfigurationContext;
import org.apache.nifi.registry.security.authentication.IdentityProviderUsage;
import org.apache.nifi.registry.security.authentication.exception.InvalidCredentialsException;
import org.apache.nifi.registry.security.exception.SecurityProviderCreationException;
import org.apache.nifi.registry.security.exception.SecurityProviderDestructionException;
import org.apache.nifi.registry.web.security.authentication.x509.X509AuthenticationRequestDetails;
import org.apache.nifi.registry.web.security.authentication.x509.X509CertificateExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.web.authentication.preauth.x509.X509PrincipalExtractor;
import org.springframework.stereotype.Component;

@Component
public class X509IdentityProvider
implements IdentityProvider {
    private static final Logger logger = LoggerFactory.getLogger(X509IdentityProvider.class);
    private static final String issuer = X509IdentityProvider.class.getSimpleName();
    private static final long expiration = TimeUnit.MILLISECONDS.convert(12L, TimeUnit.HOURS);
    private static final IdentityProviderUsage usage = new /* Unavailable Anonymous Inner Class!! */;
    private X509PrincipalExtractor principalExtractor;
    private X509CertificateExtractor certificateExtractor;

    @Autowired
    public X509IdentityProvider(X509PrincipalExtractor principalExtractor, X509CertificateExtractor certificateExtractor) {
        this.principalExtractor = principalExtractor;
        this.certificateExtractor = certificateExtractor;
    }

    public IdentityProviderUsage getUsageInstructions() {
        return usage;
    }

    public AuthenticationRequest extractCredentials(HttpServletRequest servletRequest) {
        if (!servletRequest.isSecure()) {
            return null;
        }
        X509Certificate[] certificates = this.certificateExtractor.extractClientCertificate(servletRequest);
        if (certificates == null || certificates.length == 0) {
            return null;
        }
        Object certificatePrincipal = this.principalExtractor.extractPrincipal(certificates[0]);
        String principal = certificatePrincipal.toString();
        String proxiedEntitiesChainHeader = servletRequest.getHeader("X-ProxiedEntitiesChain");
        X509AuthenticationRequestDetails details = new X509AuthenticationRequestDetails(proxiedEntitiesChainHeader, servletRequest.getMethod());
        return new AuthenticationRequest(principal, (Object)certificates[0], (Object)details);
    }

    public AuthenticationResponse authenticate(AuthenticationRequest authenticationRequest) throws InvalidCredentialsException {
        if (authenticationRequest == null || authenticationRequest.getUsername() == null) {
            return null;
        }
        String principal = authenticationRequest.getUsername();
        try {
            X509Certificate clientCertificate = (X509Certificate)authenticationRequest.getCredentials();
            this.validateClientCertificate(clientCertificate);
        }
        catch (CertificateExpiredException cee) {
            String message = String.format("Client certificate for (%s) is expired.", principal);
            logger.warn(message, (Throwable)cee);
            throw new InvalidCredentialsException(message, (Throwable)cee);
        }
        catch (CertificateNotYetValidException cnyve) {
            String message = String.format("Client certificate for (%s) is not yet valid.", principal);
            logger.warn(message, (Throwable)cnyve);
            throw new InvalidCredentialsException(message, (Throwable)cnyve);
        }
        catch (Exception e) {
            logger.warn(e.getMessage(), (Throwable)e);
        }
        return new AuthenticationResponse(principal, principal, expiration, issuer);
    }

    public void onConfigured(IdentityProviderConfigurationContext configurationContext) throws SecurityProviderCreationException {
        throw new SecurityProviderCreationException(X509IdentityProvider.class.getSimpleName() + " does not currently support being loaded via IdentityProviderFactory");
    }

    public void preDestruction() throws SecurityProviderDestructionException {
    }

    private void validateClientCertificate(X509Certificate certificate) throws CertificateExpiredException, CertificateNotYetValidException {
        certificate.checkValidity();
    }
}

