/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.web.security.authentication.kerberos;

import java.io.File;
import org.apache.nifi.registry.properties.NiFiRegistryProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.security.kerberos.authentication.KerberosTicketValidator;
import org.springframework.security.kerberos.authentication.sun.GlobalSunJaasKerberosConfig;
import org.springframework.security.kerberos.authentication.sun.SunJaasKerberosTicketValidator;

@Configuration
public class KerberosTicketValidatorFactory {
    private NiFiRegistryProperties properties;
    private KerberosTicketValidator kerberosTicketValidator;

    @Autowired
    public KerberosTicketValidatorFactory(NiFiRegistryProperties properties) {
        this.properties = properties;
    }

    @Bean
    public KerberosTicketValidator kerberosTicketValidator() throws Exception {
        if (this.kerberosTicketValidator == null && this.properties.isKerberosSpnegoSupportEnabled()) {
            File krb5ConfigFile = this.properties.getKerberosConfigurationFile();
            if (krb5ConfigFile != null) {
                GlobalSunJaasKerberosConfig krb5Config = new GlobalSunJaasKerberosConfig();
                krb5Config.setKrbConfLocation(krb5ConfigFile.getAbsolutePath());
                krb5Config.afterPropertiesSet();
            }
            SunJaasKerberosTicketValidator ticketValidator = new SunJaasKerberosTicketValidator();
            ticketValidator.setServicePrincipal(this.properties.getKerberosSpnegoPrincipal());
            ticketValidator.setKeyTabLocation((Resource)new FileSystemResource(this.properties.getKerberosSpnegoKeytabLocation()));
            ticketValidator.afterPropertiesSet();
            this.kerberosTicketValidator = ticketValidator;
        }
        return this.kerberosTicketValidator;
    }
}

