/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.web.security.authentication;

import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.nifi.registry.security.authentication.AuthenticationRequest;
import org.apache.nifi.registry.security.authentication.AuthenticationResponse;
import org.apache.nifi.registry.security.authentication.IdentityProvider;
import org.apache.nifi.registry.security.authentication.exception.InvalidCredentialsException;
import org.apache.nifi.registry.security.authorization.Authorizer;
import org.apache.nifi.registry.security.authorization.Group;
import org.apache.nifi.registry.security.authorization.ManagedAuthorizer;
import org.apache.nifi.registry.security.authorization.UserAndGroups;
import org.apache.nifi.registry.security.authorization.UserGroupProvider;
import org.apache.nifi.registry.security.authorization.user.NiFiUser;
import org.apache.nifi.registry.security.authorization.user.NiFiUserDetails;
import org.apache.nifi.registry.security.authorization.user.StandardNiFiUser;
import org.apache.nifi.registry.security.identity.IdentityMapper;
import org.apache.nifi.registry.web.security.authentication.AuthenticationRequestToken;
import org.apache.nifi.registry.web.security.authentication.AuthenticationSuccessToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.userdetails.UserDetails;

/*
 * Exception performing whole class analysis ignored.
 */
public class IdentityAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentityAuthenticationProvider.class);
    protected Authorizer authorizer;
    protected final IdentityProvider identityProvider;
    protected final IdentityMapper identityMapper;

    public IdentityAuthenticationProvider(Authorizer authorizer, IdentityProvider identityProvider, IdentityMapper identityMapper) {
        this.authorizer = authorizer;
        this.identityProvider = identityProvider;
        this.identityMapper = identityMapper;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        boolean tokenOriginatedFromThisIdentityProvider = this.checkTokenOriginatedFromThisIdentityProvider(authentication);
        if (!tokenOriginatedFromThisIdentityProvider) {
            return null;
        }
        AuthenticationRequestToken authenticationRequestToken = (AuthenticationRequestToken)authentication;
        AuthenticationRequest authenticationRequest = authenticationRequestToken.getAuthenticationRequest();
        try {
            AuthenticationResponse authenticationResponse = this.identityProvider.authenticate(authenticationRequest);
            if (authenticationResponse == null) {
                return null;
            }
            return this.buildAuthenticatedToken(authenticationRequestToken, authenticationResponse);
        }
        catch (InvalidCredentialsException e) {
            throw new BadCredentialsException("Identity Provider authentication failed.", (Throwable)e);
        }
    }

    public boolean supports(Class<?> authenticationClazz) {
        return AuthenticationRequestToken.class.isAssignableFrom(authenticationClazz);
    }

    protected AuthenticationSuccessToken buildAuthenticatedToken(AuthenticationRequestToken requestToken, AuthenticationResponse response) {
        String mappedIdentity = this.mapIdentity(response.getIdentity());
        return new AuthenticationSuccessToken((UserDetails)new NiFiUserDetails((NiFiUser)new StandardNiFiUser.Builder().identity(mappedIdentity).groups(this.getUserGroups(mappedIdentity)).clientAddress(requestToken.getClientAddress()).build()));
    }

    protected boolean checkTokenOriginatedFromThisIdentityProvider(Authentication authentication) {
        return authentication instanceof AuthenticationRequestToken && this.identityProvider.getClass().equals(((AuthenticationRequestToken)authentication).getAuthenticationRequestOrigin());
    }

    protected String mapIdentity(String identity) {
        return this.identityMapper.mapUser(identity);
    }

    protected Set<String> getUserGroups(String identity) {
        return IdentityAuthenticationProvider.getUserGroups((Authorizer)this.authorizer, (String)identity);
    }

    private static Set<String> getUserGroups(Authorizer authorizer, String userIdentity) {
        if (authorizer instanceof ManagedAuthorizer) {
            ManagedAuthorizer managedAuthorizer = (ManagedAuthorizer)authorizer;
            UserGroupProvider userGroupProvider = managedAuthorizer.getAccessPolicyProvider().getUserGroupProvider();
            UserAndGroups userAndGroups = userGroupProvider.getUserAndGroups(userIdentity);
            Set userGroups = userAndGroups.getGroups();
            if (userGroups == null || userGroups.isEmpty()) {
                return Collections.emptySet();
            }
            return userAndGroups.getGroups().stream().map(Group::getName).collect(Collectors.toSet());
        }
        return null;
    }
}

