/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.web.security;

import org.apache.nifi.registry.authorization.Permissions;
import org.apache.nifi.registry.bucket.Bucket;
import org.apache.nifi.registry.bucket.BucketItem;
import org.apache.nifi.registry.security.authorization.AuthorizableLookup;
import org.apache.nifi.registry.security.authorization.resource.Authorizable;
import org.apache.nifi.registry.service.AuthorizationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PermissionsService {
    private AuthorizationService authorizationService;
    private AuthorizableLookup authorizableLookup;

    @Autowired
    public PermissionsService(AuthorizationService authorizationService, AuthorizableLookup authorizableLookup) {
        this.authorizationService = authorizationService;
        this.authorizableLookup = authorizableLookup;
    }

    public void populateBucketPermissions(Iterable<Bucket> buckets) {
        Permissions topLevelBucketPermissions = this.authorizationService.getPermissionsForResource(this.authorizableLookup.getBucketsAuthorizable());
        buckets.forEach(b -> this.populateBucketPermissions(b, topLevelBucketPermissions));
    }

    public void populateBucketPermissions(Bucket bucket) {
        this.populateBucketPermissions(bucket, null);
    }

    public void populateItemPermissions(Iterable<? extends BucketItem> bucketItems) {
        Permissions topLevelBucketPermissions = this.authorizationService.getPermissionsForResource(this.authorizableLookup.getBucketsAuthorizable());
        bucketItems.forEach(i -> this.populateItemPermissions(i, topLevelBucketPermissions));
    }

    public void populateItemPermissions(BucketItem bucketItem) {
        this.populateItemPermissions(bucketItem, null);
    }

    private void populateBucketPermissions(Bucket bucket, Permissions knownPermissions) {
        if (bucket == null) {
            return;
        }
        Permissions bucketPermissions = this.createPermissionsForBucketId(bucket.getIdentifier(), knownPermissions);
        bucket.setPermissions(bucketPermissions);
    }

    private void populateItemPermissions(BucketItem bucketItem, Permissions knownPermissions) {
        if (bucketItem == null) {
            return;
        }
        Permissions bucketItemPermissions = this.createPermissionsForBucketId(bucketItem.getBucketIdentifier(), knownPermissions);
        bucketItem.setPermissions(bucketItemPermissions);
    }

    private Permissions createPermissionsForBucketId(String bucketId, Permissions knownPermissions) {
        Authorizable bucketResource = this.authorizableLookup.getBucketAuthorizable(bucketId);
        Permissions permissions = knownPermissions == null ? this.authorizationService.getPermissionsForResource(bucketResource) : this.authorizationService.getPermissionsForResource(bucketResource, knownPermissions);
        return permissions;
    }
}

