/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.web.security;

import javax.servlet.Filter;
import org.apache.nifi.registry.security.authentication.IdentityProvider;
import org.apache.nifi.registry.security.authorization.Authorizer;
import org.apache.nifi.registry.security.authorization.resource.ResourceType;
import org.apache.nifi.registry.security.identity.IdentityMapper;
import org.apache.nifi.registry.service.AuthorizationService;
import org.apache.nifi.registry.web.security.authentication.AnonymousIdentityFilter;
import org.apache.nifi.registry.web.security.authentication.IdentityAuthenticationProvider;
import org.apache.nifi.registry.web.security.authentication.IdentityFilter;
import org.apache.nifi.registry.web.security.authentication.jwt.JwtIdentityProvider;
import org.apache.nifi.registry.web.security.authentication.x509.X509IdentityAuthenticationProvider;
import org.apache.nifi.registry.web.security.authentication.x509.X509IdentityProvider;
import org.apache.nifi.registry.web.security.authorization.ResourceAuthorizationFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.method.configuration.EnableGlobalMethodSecurity;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.http.SessionCreationPolicy;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.access.intercept.FilterSecurityInterceptor;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;

@Configuration
@EnableWebSecurity
@EnableGlobalMethodSecurity(prePostEnabled=true)
public class NiFiRegistrySecurityConfig
extends WebSecurityConfigurerAdapter {
    private static final Logger logger = LoggerFactory.getLogger(NiFiRegistrySecurityConfig.class);
    @Autowired
    private IdentityMapper identityMapper;
    @Autowired
    private AuthorizationService authorizationService;
    @Autowired
    private Authorizer authorizer;
    private final AnonymousIdentityFilter anonymousAuthenticationFilter = new AnonymousIdentityFilter();
    @Autowired
    private X509IdentityProvider x509IdentityProvider;
    private IdentityFilter x509AuthenticationFilter;
    private IdentityAuthenticationProvider x509AuthenticationProvider;
    @Autowired
    private JwtIdentityProvider jwtIdentityProvider;
    private IdentityFilter jwtAuthenticationFilter;
    private IdentityAuthenticationProvider jwtAuthenticationProvider;
    private ResourceAuthorizationFilter resourceAuthorizationFilter;

    public NiFiRegistrySecurityConfig() {
        super(true);
    }

    protected void configure(HttpSecurity http) throws Exception {
        ((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.rememberMe().disable()).authorizeRequests().antMatchers(new String[]{"/access/token", "/access/token/identity-provider", "/access/token/kerberos", "/access/oidc/callback", "/access/oidc/exchange", "/access/oidc/request"})).permitAll().anyRequest()).fullyAuthenticated().and()).exceptionHandling().authenticationEntryPoint(this.http401AuthenticationEntryPoint()).and()).sessionManagement().sessionCreationPolicy(SessionCreationPolicy.STATELESS);
        http.headers().xssProtection();
        http.headers().contentSecurityPolicy("frame-ancestors 'self'");
        http.headers().httpStrictTransportSecurity().maxAgeInSeconds(31540000L);
        http.headers().frameOptions().sameOrigin();
        http.addFilterBefore((Filter)this.x509AuthenticationFilter(), AnonymousAuthenticationFilter.class);
        http.addFilterBefore((Filter)this.jwtAuthenticationFilter(), AnonymousAuthenticationFilter.class);
        http.anonymous().authenticationFilter((AnonymousAuthenticationFilter)this.anonymousAuthenticationFilter);
        http.addFilterAfter((Filter)this.resourceAuthorizationFilter(), FilterSecurityInterceptor.class);
    }

    protected void configure(AuthenticationManagerBuilder auth) throws Exception {
        auth.authenticationProvider((AuthenticationProvider)this.x509AuthenticationProvider()).authenticationProvider((AuthenticationProvider)this.jwtAuthenticationProvider());
    }

    @Bean
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }

    private IdentityFilter x509AuthenticationFilter() {
        if (this.x509AuthenticationFilter == null) {
            this.x509AuthenticationFilter = new IdentityFilter((IdentityProvider)this.x509IdentityProvider);
        }
        return this.x509AuthenticationFilter;
    }

    private IdentityAuthenticationProvider x509AuthenticationProvider() {
        if (this.x509AuthenticationProvider == null) {
            this.x509AuthenticationProvider = new X509IdentityAuthenticationProvider(this.authorizer, (IdentityProvider)this.x509IdentityProvider, this.identityMapper);
        }
        return this.x509AuthenticationProvider;
    }

    private IdentityFilter jwtAuthenticationFilter() {
        if (this.jwtAuthenticationFilter == null) {
            this.jwtAuthenticationFilter = new IdentityFilter((IdentityProvider)this.jwtIdentityProvider);
        }
        return this.jwtAuthenticationFilter;
    }

    private IdentityAuthenticationProvider jwtAuthenticationProvider() {
        if (this.jwtAuthenticationProvider == null) {
            this.jwtAuthenticationProvider = new IdentityAuthenticationProvider(this.authorizer, (IdentityProvider)this.jwtIdentityProvider, this.identityMapper);
        }
        return this.jwtAuthenticationProvider;
    }

    private ResourceAuthorizationFilter resourceAuthorizationFilter() {
        if (this.resourceAuthorizationFilter == null) {
            this.resourceAuthorizationFilter = ResourceAuthorizationFilter.builder().setAuthorizationService(this.authorizationService).addResourceType(ResourceType.Actuator).addResourceType(ResourceType.Swagger).build();
        }
        return this.resourceAuthorizationFilter;
    }

    private AuthenticationEntryPoint http401AuthenticationEntryPoint() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    static /* synthetic */ Logger access$000() {
        return logger;
    }
}

