/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.web.mapper;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.nifi.registry.serialization.SerializationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Provider
public class SerializationExceptionMapper
implements ExceptionMapper<SerializationException> {
    private static final Logger logger = LoggerFactory.getLogger(SerializationExceptionMapper.class);

    public Response toResponse(SerializationException exception) {
        logger.info(String.format("%s. Returning %s response.", exception, Response.Status.INTERNAL_SERVER_ERROR));
        if (logger.isDebugEnabled()) {
            logger.debug("", (Throwable)exception);
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)exception.getMessage()).type("text/plain").build();
    }
}

