/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.web.mapper;

import java.util.Iterator;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import javax.validation.Path;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Provider
public class ConstraintViolationExceptionMapper
implements ExceptionMapper<ConstraintViolationException> {
    private static final Logger logger = LoggerFactory.getLogger(ConstraintViolationExceptionMapper.class);

    public Response toResponse(ConstraintViolationException exception) {
        StringBuilder errorMessage = new StringBuilder(exception.getMessage()).append(" - ");
        boolean first = true;
        for (ConstraintViolation violation : exception.getConstraintViolations()) {
            if (!first) {
                errorMessage.append(", ");
            }
            first = false;
            Path.Node lastNode = null;
            Iterator iterator = violation.getPropertyPath().iterator();
            while (iterator.hasNext()) {
                Path.Node node;
                lastNode = node = (Path.Node)iterator.next();
            }
            errorMessage.append(lastNode.getName()).append(" ").append(violation.getMessage());
        }
        logger.info(String.format("%s. Returning %s response.", errorMessage, Response.Status.BAD_REQUEST));
        if (logger.isDebugEnabled()) {
            logger.debug("", (Throwable)exception);
        }
        return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)errorMessage.toString()).type("text/plain").build();
    }
}

