/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.web.mapper;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.nifi.registry.security.authorization.exception.AccessDeniedException;
import org.apache.nifi.registry.security.authorization.user.NiFiUser;
import org.apache.nifi.registry.security.authorization.user.NiFiUserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Provider
public class AccessDeniedExceptionMapper
implements ExceptionMapper<AccessDeniedException> {
    private static final Logger logger = LoggerFactory.getLogger(AccessDeniedExceptionMapper.class);

    public Response toResponse(AccessDeniedException exception) {
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        Response.Status status = user == null || user.isAnonymous() ? Response.Status.UNAUTHORIZED : Response.Status.FORBIDDEN;
        String identity = user == null ? "<no user found>" : user.toString();
        logger.info(String.format("%s does not have permission to access the requested resource. %s Returning %s response.", identity, exception.getMessage(), status));
        if (logger.isDebugEnabled()) {
            logger.debug("", (Throwable)exception);
        }
        return Response.status((Response.Status)status).entity((Object)String.format("%s Contact the system administrator.", exception.getMessage())).type("text/plain").build();
    }
}

