/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.web.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.Authorization;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.nifi.registry.NiFiRegistryApiApplication;
import org.apache.nifi.registry.RegistryAbout;
import org.apache.nifi.registry.event.EventService;
import org.apache.nifi.registry.web.api.ApplicationResource;
import org.apache.nifi.registry.web.service.ServiceFacade;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/about")
@Api(value="about", description="Retrieves the version information for this NiFi Registry.", authorizations={@Authorization(value="Authorization")})
public class RegistryAboutResource
extends ApplicationResource {
    @Autowired
    public RegistryAboutResource(ServiceFacade serviceFacade, EventService eventService) {
        super(serviceFacade, eventService);
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Get version", notes="Gets the NiFi Registry version.", response=RegistryAbout.class)
    public Response getVersion() {
        String implVersion = NiFiRegistryApiApplication.class.getPackage().getImplementationVersion();
        RegistryAbout version = new RegistryAbout(implVersion);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)version).build();
    }
}

