/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.web.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.ExtensionProperty;
import java.util.List;
import java.util.SortedSet;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.nifi.extension.ExtensionMetadata;
import org.apache.nifi.extension.manifest.Extension;
import org.apache.nifi.registry.event.EventFactory;
import org.apache.nifi.registry.event.EventService;
import org.apache.nifi.registry.extension.bundle.Bundle;
import org.apache.nifi.registry.extension.bundle.BundleFilterParams;
import org.apache.nifi.registry.extension.bundle.BundleVersion;
import org.apache.nifi.registry.extension.bundle.BundleVersionFilterParams;
import org.apache.nifi.registry.extension.bundle.BundleVersionMetadata;
import org.apache.nifi.registry.web.api.ApplicationResource;
import org.apache.nifi.registry.web.service.ServiceFacade;
import org.apache.nifi.registry.web.service.StreamingContent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Path(value="/bundles")
@Api(value="bundles", description="Gets metadata about extension bundles and their versions. ", authorizations={@Authorization(value="Authorization")})
public class BundleResource
extends ApplicationResource {
    public static final String CONTENT_DISPOSITION_HEADER = "content-disposition";

    @Autowired
    public BundleResource(ServiceFacade serviceFacade, EventService eventService) {
        super(serviceFacade, eventService);
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all bundles", notes="Gets the metadata for all bundles across all authorized buckets with optional filters applied. The returned results will include only items from buckets for which the user is authorized. If the user is not authorized to any buckets, an empty list will be returned. \n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.", response=Bundle.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=401, message="Client could not be authenticated.")})
    public Response getBundles(@QueryParam(value="bucketName") @ApiParam(value="Optional bucket name to filter results. The value may be an exact match, or a wildcard, such as 'My Bucket%' to select all bundles where the bucket name starts with 'My Bucket'.") String bucketName, @QueryParam(value="groupId") @ApiParam(value="Optional groupId to filter results. The value may be an exact match, or a wildcard, such as 'com.%' to select all bundles where the groupId starts with 'com.'.") String groupId, @QueryParam(value="artifactId") @ApiParam(value="Optional artifactId to filter results. The value may be an exact match, or a wildcard, such as 'nifi-%' to select all bundles where the artifactId starts with 'nifi-'.") String artifactId) {
        BundleFilterParams filterParams = BundleFilterParams.of((String)bucketName, (String)groupId, (String)artifactId);
        List bundles = this.serviceFacade.getBundles(filterParams);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)bundles).build();
    }

    @GET
    @Path(value="{bundleId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get bundle", notes="Gets the metadata about an extension bundle. \n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.", nickname="globalGetExtensionBundle", response=Bundle.class, extensions={@io.swagger.annotations.Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getBundle(@PathParam(value="bundleId") @ApiParam(value="The extension bundle identifier") String bundleId) {
        Bundle bundle = this.serviceFacade.getBundle(bundleId);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)bundle).build();
    }

    @DELETE
    @Path(value="{bundleId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete bundle", notes="Deletes the given extension bundle and all of it's versions. \n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.", nickname="globalDeleteExtensionBundle", response=Bundle.class, extensions={@io.swagger.annotations.Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="write"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response deleteBundle(@PathParam(value="bundleId") @ApiParam(value="The extension bundle identifier") String bundleId) {
        Bundle deletedBundle = this.serviceFacade.deleteBundle(bundleId);
        this.publish(EventFactory.extensionBundleDeleted((Bundle)deletedBundle));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)deletedBundle).build();
    }

    @GET
    @Path(value="versions")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all bundle versions", notes="Gets the metadata about extension bundle versions across all authorized buckets with optional filters applied. If the user is not authorized to any buckets, an empty list will be returned. \n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.", response=BundleVersionMetadata.class, responseContainer="List")
    @ApiResponses(value={@ApiResponse(code=401, message="Client could not be authenticated.")})
    public Response getBundleVersions(@QueryParam(value="groupId") @ApiParam(value="Optional groupId to filter results. The value may be an exact match, or a wildcard, such as 'com.%' to select all bundle versions where the groupId starts with 'com.'.") String groupId, @QueryParam(value="artifactId") @ApiParam(value="Optional artifactId to filter results. The value may be an exact match, or a wildcard, such as 'nifi-%' to select all bundle versions where the artifactId starts with 'nifi-'.") String artifactId, @QueryParam(value="version") @ApiParam(value="Optional version to filter results. The value maye be an exact match, or a wildcard, such as '1.0.%' to select all bundle versions where the version starts with '1.0.'.") String version) {
        BundleVersionFilterParams filterParams = BundleVersionFilterParams.of((String)groupId, (String)artifactId, (String)version);
        SortedSet bundleVersions = this.serviceFacade.getBundleVersions(filterParams);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)bundleVersions).build();
    }

    @GET
    @Path(value="{bundleId}/versions")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get bundle versions", notes="Gets the metadata for the versions of the given extension bundle. \n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.", nickname="globalGetBundleVersions", response=BundleVersionMetadata.class, responseContainer="List", extensions={@io.swagger.annotations.Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getBundleVersions(@PathParam(value="bundleId") @ApiParam(value="The extension bundle identifier") String bundleId) {
        SortedSet bundleVersions = this.serviceFacade.getBundleVersions(bundleId);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)bundleVersions).build();
    }

    @GET
    @Path(value="{bundleId}/versions/{version}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get bundle version", notes="Gets the descriptor for the given version of the given extension bundle. \n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.", nickname="globalGetBundleVersion", response=BundleVersion.class, extensions={@io.swagger.annotations.Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getBundleVersion(@PathParam(value="bundleId") @ApiParam(value="The extension bundle identifier") String bundleId, @PathParam(value="version") @ApiParam(value="The version of the bundle") String version) {
        BundleVersion bundleVersion = this.serviceFacade.getBundleVersion(bundleId, version);
        return Response.ok((Object)bundleVersion).build();
    }

    @GET
    @Path(value="{bundleId}/versions/{version}/content")
    @Consumes(value={"*/*"})
    @Produces(value={"application/octet-stream"})
    @ApiOperation(value="Get bundle version content", notes="Gets the binary content for the given version of the given extension bundle. \n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.", nickname="globalGetBundleVersionContent", response=byte[].class, extensions={@io.swagger.annotations.Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getBundleVersionContent(@PathParam(value="bundleId") @ApiParam(value="The extension bundle identifier") String bundleId, @PathParam(value="version") @ApiParam(value="The version of the bundle") String version) {
        StreamingContent streamingContent = this.serviceFacade.getBundleVersionContent(bundleId, version);
        String filename = streamingContent.getFilename();
        StreamingOutput output = streamingContent.getOutput();
        return Response.ok((Object)output).header(CONTENT_DISPOSITION_HEADER, (Object)("attachment; filename = " + filename)).build();
    }

    @DELETE
    @Path(value="{bundleId}/versions/{version}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete bundle version", notes="Deletes the given extension bundle version and it's associated binary content. \n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.", nickname="globalDeleteBundleVersion", response=BundleVersion.class, extensions={@io.swagger.annotations.Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="write"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response deleteBundleVersion(@PathParam(value="bundleId") @ApiParam(value="The extension bundle identifier") String bundleId, @PathParam(value="version") @ApiParam(value="The version of the bundle") String version) {
        BundleVersion deletedBundleVersion = this.serviceFacade.deleteBundleVersion(bundleId, version);
        this.publish(EventFactory.extensionBundleVersionDeleted((BundleVersion)deletedBundleVersion));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)deletedBundleVersion).build();
    }

    @GET
    @Path(value="{bundleId}/versions/{version}/extensions")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get bundle version extensions", notes="Gets the metadata about the extensions in the given extension bundle version. \n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.", nickname="globalGetBundleVersionExtensions", response=ExtensionMetadata.class, responseContainer="List", extensions={@io.swagger.annotations.Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getBundleVersionExtensions(@PathParam(value="bundleId") @ApiParam(value="The extension bundle identifier") String bundleId, @PathParam(value="version") @ApiParam(value="The version of the bundle") String version) {
        SortedSet extensions = this.serviceFacade.getExtensionMetadata(bundleId, version);
        return Response.ok((Object)extensions).build();
    }

    @GET
    @Path(value="{bundleId}/versions/{version}/extensions/{name}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get bundle version extension", notes="Gets the metadata about the extension with the given name in the given extension bundle version. \n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.", nickname="globalGetBundleVersionExtension", response=Extension.class, responseContainer="List", extensions={@io.swagger.annotations.Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getBundleVersionExtension(@PathParam(value="bundleId") @ApiParam(value="The extension bundle identifier") String bundleId, @PathParam(value="version") @ApiParam(value="The version of the bundle") String version, @PathParam(value="name") @ApiParam(value="The fully qualified name of the extension") String name) {
        Extension extension = this.serviceFacade.getExtension(bundleId, version, name);
        return Response.ok((Object)extension).build();
    }

    @GET
    @Path(value="{bundleId}/versions/{version}/extensions/{name}/docs")
    @Consumes(value={"*/*"})
    @Produces(value={"text/html"})
    @ApiOperation(value="Get bundle version extension docs", notes="Gets the documentation for the given extension in the given extension bundle version. \n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.", response=String.class, extensions={@io.swagger.annotations.Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getBundleVersionExtensionDocs(@PathParam(value="bundleId") @ApiParam(value="The extension bundle identifier") String bundleId, @PathParam(value="version") @ApiParam(value="The version of the bundle") String version, @PathParam(value="name") @ApiParam(value="The fully qualified name of the extension") String name) {
        StreamingOutput streamingOutput = this.serviceFacade.getExtensionDocs(bundleId, version, name);
        return Response.ok((Object)streamingOutput).build();
    }

    @GET
    @Path(value="{bundleId}/versions/{version}/extensions/{name}/docs/additional-details")
    @Consumes(value={"*/*"})
    @Produces(value={"text/html"})
    @ApiOperation(value="Get bundle version extension docs details", notes="Gets the additional details documentation for the given extension in the given extension bundle version. \n\nNOTE: This endpoint is subject to change as NiFi Registry and its REST API evolve.", response=String.class, extensions={@io.swagger.annotations.Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getBundleVersionExtensionAdditionalDetailsDocs(@PathParam(value="bundleId") @ApiParam(value="The extension bundle identifier") String bundleId, @PathParam(value="version") @ApiParam(value="The version of the bundle") String version, @PathParam(value="name") @ApiParam(value="The fully qualified name of the extension") String name) {
        StreamingOutput streamingOutput = this.serviceFacade.getAdditionalDetailsDocs(bundleId, version, name);
        return Response.ok((Object)streamingOutput).build();
    }
}

