/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.web.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import io.swagger.annotations.Extension;
import io.swagger.annotations.ExtensionProperty;
import java.net.URI;
import java.util.List;
import java.util.SortedSet;
import javax.validation.constraints.NotNull;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.registry.bucket.BucketItem;
import org.apache.nifi.registry.diff.VersionedFlowDifference;
import org.apache.nifi.registry.event.EventFactory;
import org.apache.nifi.registry.event.EventService;
import org.apache.nifi.registry.flow.VersionedFlow;
import org.apache.nifi.registry.flow.VersionedFlowSnapshot;
import org.apache.nifi.registry.flow.VersionedFlowSnapshotMetadata;
import org.apache.nifi.registry.revision.entity.RevisionInfo;
import org.apache.nifi.registry.revision.web.ClientIdParameter;
import org.apache.nifi.registry.revision.web.LongParameter;
import org.apache.nifi.registry.security.authorization.user.NiFiUserUtils;
import org.apache.nifi.registry.web.api.ApplicationResource;
import org.apache.nifi.registry.web.service.ExportedVersionedFlowSnapshot;
import org.apache.nifi.registry.web.service.ServiceFacade;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Path(value="/buckets/{bucketId}/flows")
@Api(value="bucket flows", description="Create flows scoped to an existing bucket in the registry.", authorizations={@Authorization(value="Authorization")})
public class BucketFlowResource
extends ApplicationResource {
    @Autowired
    public BucketFlowResource(ServiceFacade serviceFacade, EventService eventService) {
        super(serviceFacade, eventService);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create flow", notes="Creates a flow in the given bucket. The flow id is created by the server and populated in the returned entity.", response=VersionedFlow.class, extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="write"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response createFlow(@PathParam(value="bucketId") @ApiParam(value="The bucket identifier") String bucketId, @ApiParam(value="The details of the flow to create.", required=true) VersionedFlow flow) {
        BucketFlowResource.verifyPathParamsMatchBody((String)bucketId, (BucketItem)flow);
        VersionedFlow createdFlow = this.serviceFacade.createFlow(bucketId, flow);
        this.publish(EventFactory.flowCreated((VersionedFlow)createdFlow));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)createdFlow).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get bucket flows", notes="Retrieves all flows in the given bucket.", response=VersionedFlow.class, responseContainer="List", extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getFlows(@PathParam(value="bucketId") @ApiParam(value="The bucket identifier") String bucketId) {
        List flows = this.serviceFacade.getFlows(bucketId);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)flows).build();
    }

    @GET
    @Path(value="{flowId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get bucket flow", notes="Retrieves the flow with the given id in the given bucket.", response=VersionedFlow.class, extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getFlow(@PathParam(value="bucketId") @ApiParam(value="The bucket identifier") String bucketId, @PathParam(value="flowId") @ApiParam(value="The flow identifier") String flowId) {
        VersionedFlow flow = this.serviceFacade.getFlow(bucketId, flowId);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)flow).build();
    }

    @PUT
    @Path(value="{flowId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update bucket flow", notes="Updates the flow with the given id in the given bucket.", response=VersionedFlow.class, extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="write"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response updateFlow(@PathParam(value="bucketId") @ApiParam(value="The bucket identifier") String bucketId, @PathParam(value="flowId") @ApiParam(value="The flow identifier") String flowId, @ApiParam(value="The updated flow", required=true) VersionedFlow flow) {
        BucketFlowResource.verifyPathParamsMatchBody((String)bucketId, (String)flowId, (BucketItem)flow);
        BucketFlowResource.setBucketItemMetadataIfMissing((String)bucketId, (String)flowId, (BucketItem)flow);
        VersionedFlow updatedFlow = this.serviceFacade.updateFlow(flow);
        this.publish(EventFactory.flowUpdated((VersionedFlow)updatedFlow));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)updatedFlow).build();
    }

    @DELETE
    @Path(value="{flowId}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete bucket flow", notes="Deletes a flow, including all saved versions of that flow.", response=VersionedFlow.class, extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="delete"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response deleteFlow(@ApiParam(value="The version is used to verify the client is working with the latest version of the entity.", required=true) @QueryParam(value="version") LongParameter version, @ApiParam(value="If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.") @QueryParam(value="clientId") @DefaultValue(value="") ClientIdParameter clientId, @PathParam(value="bucketId") @ApiParam(value="The bucket identifier") String bucketId, @PathParam(value="flowId") @ApiParam(value="The flow identifier") String flowId) {
        RevisionInfo revisionInfo = this.getRevisionInfo(version, clientId);
        VersionedFlow deletedFlow = this.serviceFacade.deleteFlow(bucketId, flowId, revisionInfo);
        this.publish(EventFactory.flowDeleted((VersionedFlow)deletedFlow));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)deletedFlow).build();
    }

    @POST
    @Path(value="{flowId}/versions")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create flow version", notes="Creates the next version of a flow. The version number of the object being created must be the next available version integer. Flow versions are immutable after they are created.", response=VersionedFlowSnapshot.class, extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="write"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response createFlowVersion(@PathParam(value="bucketId") @ApiParam(value="The bucket identifier") String bucketId, @PathParam(value="flowId") @ApiParam(value="The flow identifier") String flowId, @ApiParam(value="The new versioned flow snapshot.", required=true) VersionedFlowSnapshot snapshot) {
        BucketFlowResource.verifyPathParamsMatchBody((String)bucketId, (String)flowId, (VersionedFlowSnapshot)snapshot);
        BucketFlowResource.setSnaphotMetadataIfMissing((String)bucketId, (String)flowId, (VersionedFlowSnapshot)snapshot);
        String userIdentity = NiFiUserUtils.getNiFiUserIdentity();
        snapshot.getSnapshotMetadata().setAuthor(userIdentity);
        VersionedFlowSnapshot createdSnapshot = this.serviceFacade.createFlowSnapshot(snapshot);
        this.publish(EventFactory.flowVersionCreated((VersionedFlowSnapshot)createdSnapshot));
        return Response.status((Response.Status)Response.Status.OK).entity((Object)createdSnapshot).build();
    }

    @POST
    @Path(value="{flowId}/versions/import")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Import flow version", notes="Import the next version of a flow. The version number of the object being created will be the next available version integer. Flow versions are immutable after they are created.", response=VersionedFlowSnapshot.class, extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="write"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=201, message="The resource has been successfully created."), @ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response importVersionedFlow(@PathParam(value="bucketId") @ApiParam(value="The bucket identifier") String bucketId, @PathParam(value="flowId") @ApiParam(value="The flow identifier") String flowId, @ApiParam(value="file") VersionedFlowSnapshot versionedFlowSnapshot, @HeaderParam(value="Comments") String comments) {
        VersionedFlowSnapshot createdSnapshot = this.serviceFacade.importVersionedFlowSnapshot(versionedFlowSnapshot, bucketId, flowId, comments);
        this.publish(EventFactory.flowVersionCreated((VersionedFlowSnapshot)createdSnapshot));
        String locationUri = createdSnapshot.getSnapshotMetadata().getLink().getUri().getPath();
        return this.generateCreatedResponse(URI.create(locationUri), (Object)createdSnapshot).build();
    }

    @GET
    @Path(value="{flowId}/versions")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get bucket flow versions", notes="Gets summary information for all versions of a flow. Versions are ordered newest->oldest.", response=VersionedFlowSnapshotMetadata.class, responseContainer="List", extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getFlowVersions(@PathParam(value="bucketId") @ApiParam(value="The bucket identifier") String bucketId, @PathParam(value="flowId") @ApiParam(value="The flow identifier") String flowId) {
        SortedSet snapshots = this.serviceFacade.getFlowSnapshots(bucketId, flowId);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)snapshots).build();
    }

    @GET
    @Path(value="{flowId}/versions/latest")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get latest bucket flow version content", notes="Gets the latest version of a flow, including the metadata and content of the flow.", response=VersionedFlowSnapshot.class, extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getLatestFlowVersion(@PathParam(value="bucketId") @ApiParam(value="The bucket identifier") String bucketId, @PathParam(value="flowId") @ApiParam(value="The flow identifier") String flowId) {
        VersionedFlowSnapshot lastSnapshot = this.serviceFacade.getLatestFlowSnapshot(bucketId, flowId);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)lastSnapshot).build();
    }

    @GET
    @Path(value="{flowId}/versions/latest/metadata")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get latest bucket flow version metadata", notes="Gets the metadata for the latest version of a flow.", response=VersionedFlowSnapshotMetadata.class, extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getLatestFlowVersionMetadata(@PathParam(value="bucketId") @ApiParam(value="The bucket identifier") String bucketId, @PathParam(value="flowId") @ApiParam(value="The flow identifier") String flowId) {
        VersionedFlowSnapshotMetadata latest = this.serviceFacade.getLatestFlowSnapshotMetadata(bucketId, flowId);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)latest).build();
    }

    @GET
    @Path(value="{flowId}/versions/{versionNumber: \\d+}/export")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Exports specified bucket flow version content", notes="Exports the specified version of a flow, including the metadata and content of the flow.", response=VersionedFlowSnapshot.class, extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response exportVersionedFlow(@PathParam(value="bucketId") @ApiParam(value="The bucket identifier") String bucketId, @PathParam(value="flowId") @ApiParam(value="The flow identifier") String flowId, @PathParam(value="versionNumber") @ApiParam(value="The version number") Integer versionNumber) {
        ExportedVersionedFlowSnapshot exportedVersionedFlowSnapshot = this.serviceFacade.exportFlowSnapshot(bucketId, flowId, versionNumber);
        VersionedFlowSnapshot versionedFlowSnapshot = exportedVersionedFlowSnapshot.getVersionedFlowSnapshot();
        String contentDisposition = String.format("attachment; filename=\"%s\"", exportedVersionedFlowSnapshot.getFilename());
        return this.generateOkResponse((Object)versionedFlowSnapshot).header("Content-Disposition", (Object)contentDisposition).header("Filename", (Object)exportedVersionedFlowSnapshot.getFilename()).build();
    }

    @GET
    @Path(value="{flowId}/versions/{versionNumber: \\d+}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get bucket flow version", notes="Gets the given version of a flow, including the metadata and content for the version.", response=VersionedFlowSnapshot.class, extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getFlowVersion(@PathParam(value="bucketId") @ApiParam(value="The bucket identifier") String bucketId, @PathParam(value="flowId") @ApiParam(value="The flow identifier") String flowId, @PathParam(value="versionNumber") @ApiParam(value="The version number") Integer versionNumber) {
        VersionedFlowSnapshot snapshot = this.serviceFacade.getFlowSnapshot(bucketId, flowId, versionNumber);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)snapshot).build();
    }

    @GET
    @Path(value="{flowId}/diff/{versionA: \\d+}/{versionB: \\d+}")
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Get bucket flow diff", notes="Computes the differences between two given versions of a flow.", response=VersionedFlowDifference.class, extensions={@Extension(name="access-policy", properties={@ExtensionProperty(name="action", value="read"), @ExtensionProperty(name="resource", value="/buckets/{bucketId}")})})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi Registry was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="NiFi Registry was unable to complete the request because it assumes a server state that is not valid.")})
    public Response getFlowDiff(@PathParam(value="bucketId") @ApiParam(value="The bucket identifier") String bucketId, @PathParam(value="flowId") @ApiParam(value="The flow identifier") String flowId, @PathParam(value="versionA") @ApiParam(value="The first version number") Integer versionNumberA, @PathParam(value="versionB") @ApiParam(value="The second version number") Integer versionNumberB) {
        VersionedFlowDifference result = this.serviceFacade.getFlowDiff(bucketId, flowId, versionNumberA, versionNumberB);
        return Response.status((Response.Status)Response.Status.OK).entity((Object)result).build();
    }

    private static void verifyPathParamsMatchBody(String bucketIdParam, BucketItem bodyBucketItem) throws BadRequestException {
        if (StringUtils.isBlank((CharSequence)bucketIdParam)) {
            throw new BadRequestException("Bucket id path parameter cannot be blank");
        }
        if (bodyBucketItem == null) {
            throw new BadRequestException("Object in body cannot be null");
        }
        if (bodyBucketItem.getBucketIdentifier() != null && !bucketIdParam.equals(bodyBucketItem.getBucketIdentifier())) {
            throw new BadRequestException("Bucket id in path param must match bucket id in body");
        }
    }

    private static void verifyPathParamsMatchBody(String bucketIdParam, String flowIdParam, BucketItem bodyBucketItem) throws BadRequestException {
        BucketFlowResource.verifyPathParamsMatchBody((String)bucketIdParam, (BucketItem)bodyBucketItem);
        if (StringUtils.isBlank((CharSequence)flowIdParam)) {
            throw new BadRequestException("Flow id path parameter cannot be blank");
        }
        if (bodyBucketItem.getIdentifier() != null && !flowIdParam.equals(bodyBucketItem.getIdentifier())) {
            throw new BadRequestException("Item id in path param must match item id in body");
        }
    }

    private static void verifyPathParamsMatchBody(String bucketIdParam, String flowIdParam, VersionedFlowSnapshot flowSnapshot) throws BadRequestException {
        if (StringUtils.isBlank((CharSequence)bucketIdParam)) {
            throw new BadRequestException("Bucket id path parameter cannot be blank");
        }
        if (StringUtils.isBlank((CharSequence)flowIdParam)) {
            throw new BadRequestException("Flow id path parameter cannot be blank");
        }
        if (flowSnapshot == null) {
            throw new BadRequestException("VersionedFlowSnapshot cannot be null in body");
        }
        VersionedFlowSnapshotMetadata metadata = flowSnapshot.getSnapshotMetadata();
        if (metadata != null && metadata.getBucketIdentifier() != null && !bucketIdParam.equals(metadata.getBucketIdentifier())) {
            throw new BadRequestException("Bucket id in path param must match bucket id in body");
        }
        if (metadata != null && metadata.getFlowIdentifier() != null && !flowIdParam.equals(metadata.getFlowIdentifier())) {
            throw new BadRequestException("Flow id in path param must match flow id in body");
        }
    }

    private static void setBucketItemMetadataIfMissing(@NotNull String bucketIdParam, @NotNull String bucketItemIdParam, @NotNull BucketItem bucketItem) {
        if (bucketItem.getBucketIdentifier() == null) {
            bucketItem.setBucketIdentifier(bucketIdParam);
        }
        if (bucketItem.getIdentifier() == null) {
            bucketItem.setIdentifier(bucketItemIdParam);
        }
    }

    private static void setSnaphotMetadataIfMissing(@NotNull String bucketIdParam, @NotNull String flowIdParam, @NotNull VersionedFlowSnapshot flowSnapshot) {
        VersionedFlowSnapshotMetadata metadata = flowSnapshot.getSnapshotMetadata();
        if (metadata == null) {
            metadata = new VersionedFlowSnapshotMetadata();
        }
        if (metadata.getBucketIdentifier() == null) {
            metadata.setBucketIdentifier(bucketIdParam);
        }
        if (metadata.getFlowIdentifier() == null) {
            metadata.setFlowIdentifier(flowIdParam);
        }
        flowSnapshot.setSnapshotMetadata(metadata);
    }
}

