/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.db;

import org.springframework.test.annotation.ProfileValueSource;

public class DatabaseProfileValueSource
implements ProfileValueSource {
    private static final String MYSQL = "mysql";
    private static final String MARIADB = "mariadb";
    private static final String POSTGRES = "postgres";
    private static final String H2 = "h2";
    private String currentDatabase;

    DatabaseProfileValueSource() {
        String activeProfiles = System.getProperty("spring.profiles.active", H2);
        if (activeProfiles.contains(H2)) {
            this.currentDatabase = H2;
        } else if (activeProfiles.contains(MYSQL)) {
            this.currentDatabase = MYSQL;
        } else if (activeProfiles.contains(MARIADB)) {
            this.currentDatabase = MARIADB;
        } else if (activeProfiles.contains(POSTGRES)) {
            this.currentDatabase = POSTGRES;
        }
    }

    public String get(String key) {
        if (!key.startsWith("current.database.is.")) {
            return null;
        }
        if (key.startsWith("current.database.is.not.")) {
            return Boolean.toString(!key.endsWith(this.currentDatabase)).toLowerCase();
        }
        return Boolean.toString(key.endsWith(this.currentDatabase)).toLowerCase();
    }
}

