/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.websocket.jetty;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.nifi.websocket.WebSocketMessageRouter;
import org.apache.nifi.websocket.WebSocketSession;
import org.apache.nifi.websocket.jetty.JettyWebSocketSession;
import org.eclipse.jetty.websocket.api.Callback;
import org.eclipse.jetty.websocket.api.Session;

public class RoutingWebSocketListener
extends Session.Listener.AbstractAutoDemanding {
    private final WebSocketMessageRouter router;
    private String sessionId;
    private boolean secure;

    public RoutingWebSocketListener(WebSocketMessageRouter router) {
        this.router = router;
    }

    public void onWebSocketOpen(Session session) {
        super.onWebSocketOpen(session);
        if (this.sessionId == null || this.sessionId.isEmpty()) {
            this.sessionId = UUID.randomUUID().toString();
        }
        boolean secureConnection = this.secure || this.isSessionSecure(session);
        JettyWebSocketSession webSocketSession = new JettyWebSocketSession(this.sessionId, session, secureConnection);
        this.router.captureSession((WebSocketSession)webSocketSession);
    }

    public void onWebSocketClose(int statusCode, String reason, Callback callback) {
        super.onWebSocketClose(statusCode, reason, callback);
        this.router.onWebSocketClose(this.sessionId, statusCode, reason);
    }

    public void onWebSocketText(String message) {
        this.router.onWebSocketText(this.sessionId, message);
    }

    public void onWebSocketBinary(ByteBuffer payload, Callback callback) {
        this.router.onWebSocketBinary(this.sessionId, payload.array(), payload.arrayOffset(), payload.limit());
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    private boolean isSessionSecure(Session session) {
        try {
            return session.isSecure();
        }
        catch (Exception e) {
            return false;
        }
    }
}

