/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.websocket.jetty;

import jakarta.servlet.Servlet;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.net.ssl.SSLContext;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.annotation.lifecycle.OnShutdown;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.listen.ListenComponent;
import org.apache.nifi.components.listen.ListenPort;
import org.apache.nifi.components.listen.StandardListenPort;
import org.apache.nifi.components.listen.TransportProtocol;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.jetty.configuration.connector.StandardServerConnectorFactory;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.ssl.SSLContextProvider;
import org.apache.nifi.websocket.WebSocketConfigurationException;
import org.apache.nifi.websocket.WebSocketMessageRouter;
import org.apache.nifi.websocket.WebSocketServerService;
import org.apache.nifi.websocket.jetty.AbstractJettyWebSocketService;
import org.apache.nifi.websocket.jetty.RoutingWebSocketListener;
import org.eclipse.jetty.ee11.servlet.ServletContextHandler;
import org.eclipse.jetty.ee11.servlet.ServletHandler;
import org.eclipse.jetty.ee11.servlet.ServletHolder;
import org.eclipse.jetty.ee11.servlet.security.ConstraintMapping;
import org.eclipse.jetty.ee11.servlet.security.ConstraintSecurityHandler;
import org.eclipse.jetty.ee11.websocket.server.JettyServerUpgradeRequest;
import org.eclipse.jetty.ee11.websocket.server.JettyServerUpgradeResponse;
import org.eclipse.jetty.ee11.websocket.server.JettyWebSocketCreator;
import org.eclipse.jetty.ee11.websocket.server.JettyWebSocketServlet;
import org.eclipse.jetty.ee11.websocket.server.JettyWebSocketServletFactory;
import org.eclipse.jetty.ee11.websocket.server.config.JettyWebSocketServletContainerInitializer;
import org.eclipse.jetty.security.Authenticator;
import org.eclipse.jetty.security.Constraint;
import org.eclipse.jetty.security.DefaultAuthenticatorFactory;
import org.eclipse.jetty.security.HashLoginService;
import org.eclipse.jetty.security.LoginService;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.util.resource.PathResourceFactory;
import org.eclipse.jetty.util.resource.Resource;

@Tags(value={"WebSocket", "Jetty", "server"})
@CapabilityDescription(value="Implementation of WebSocketServerService. This service uses Jetty WebSocket server module to provide WebSocket session management throughout the application.")
public class JettyWebSocketServer
extends AbstractJettyWebSocketService
implements WebSocketServerService,
ListenComponent {
    private static final Map<Integer, JettyWebSocketServer> portToControllerService = new ConcurrentHashMap<Integer, JettyWebSocketServer>();
    public static final AllowableValue CLIENT_NONE = new AllowableValue("no", "No Authentication", "Processor will not authenticate clients. Anyone can communicate with this Processor anonymously");
    public static final AllowableValue CLIENT_WANT = new AllowableValue("want", "Want Authentication", "Processor will try to verify the client but if unable to verify will allow the client to communicate anonymously");
    public static final AllowableValue CLIENT_NEED = new AllowableValue("need", "Need Authentication", "Processor will reject communications from any client unless the client provides a certificate that is trusted by the TrustStore specified in the SSL Context Service");
    public static final AllowableValue LOGIN_SERVICE_HASH = new AllowableValue("hash", "HashLoginService", "See http://www.eclipse.org/jetty/javadoc/current/org/eclipse/jetty/security/HashLoginService.html for detail.");
    public static final PropertyDescriptor CLIENT_AUTH = new PropertyDescriptor.Builder().name("Client Authentication").description("Specifies whether or not the Processor should authenticate client by its certificate. This value is ignored if the <SSL Context Service> Property is not specified or the SSL Context provided uses only a KeyStore and not a TrustStore.").required(true).allowableValues(new DescribedValue[]{CLIENT_NONE, CLIENT_WANT, CLIENT_NEED}).defaultValue(CLIENT_NONE.getValue()).build();
    public static final PropertyDescriptor PORT = new PropertyDescriptor.Builder().name("Port").description("The port number on which this WebSocketServer listens to.").required(true).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).identifiesListenPort(TransportProtocol.TCP, new String[]{"ws"}).addValidator(StandardValidators.PORT_VALIDATOR).build();
    public static final PropertyDescriptor BASIC_AUTH = new PropertyDescriptor.Builder().name("Basic Authentication Enabled").description("If enabled, client connection requests are authenticated with Basic authentication using the specified Login Provider.").required(true).allowableValues(new String[]{"true", "false"}).defaultValue("false").build();
    public static final PropertyDescriptor AUTH_PATH_SPEC = new PropertyDescriptor.Builder().name("Basic Authentication Path Spec").description("Specify a Path Spec to apply Basic Authentication.").required(false).defaultValue("/*").expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor AUTH_ROLES = new PropertyDescriptor.Builder().name("Basic Authentication Roles").description("The authenticated user must have one of specified role. Multiple roles can be set as comma separated string. '*' represents any role and so does '**' any role including no role.").required(false).defaultValue("**").expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor LOGIN_SERVICE = new PropertyDescriptor.Builder().name("Login Service").description("Specify which Login Service to use for Basic Authentication.").required(false).allowableValues(new DescribedValue[]{LOGIN_SERVICE_HASH}).defaultValue(LOGIN_SERVICE_HASH.getValue()).build();
    public static final PropertyDescriptor USERS_PROPERTIES_FILE = new PropertyDescriptor.Builder().name("Users Properties File").description("Specify a property file containing users for Basic Authentication using HashLoginService. See http://www.eclipse.org/jetty/documentation/current/configuring-security.html for detail.").required(false).expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.FILE, new ResourceType[0]).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = Stream.concat(JettyWebSocketServer.getAbstractPropertyDescriptors().stream(), Stream.of(PORT, SSL_CONTEXT_SERVICE, CLIENT_AUTH, BASIC_AUTH, AUTH_PATH_SPEC, AUTH_ROLES, LOGIN_SERVICE, USERS_PROPERTIES_FILE)).toList();
    private Server server;
    private Integer listenPort;

    @Override
    public void migrateProperties(PropertyConfiguration propertyConfiguration) {
        super.migrateProperties(propertyConfiguration);
        propertyConfiguration.renameProperty("listening-port", PORT.getName());
        propertyConfiguration.renameProperty("ssl-context-service", SSL_CONTEXT_SERVICE.getName());
        propertyConfiguration.renameProperty("client-authentication", CLIENT_AUTH.getName());
        propertyConfiguration.renameProperty("basic-auth", BASIC_AUTH.getName());
        propertyConfiguration.renameProperty("auth-path-spec", AUTH_PATH_SPEC.getName());
        propertyConfiguration.renameProperty("auth-roles", AUTH_ROLES.getName());
        propertyConfiguration.renameProperty("login-service", LOGIN_SERVICE.getName());
        propertyConfiguration.renameProperty("users-properties-file", USERS_PROPERTIES_FILE.getName());
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        if (validationContext.getProperty(BASIC_AUTH).asBoolean().booleanValue()) {
            String loginServiceValue = validationContext.getProperty(LOGIN_SERVICE).getValue();
            if (LOGIN_SERVICE_HASH.getValue().equals(loginServiceValue) && !validationContext.getProperty(USERS_PROPERTIES_FILE).isSet()) {
                results.add(new ValidationResult.Builder().subject(USERS_PROPERTIES_FILE.getDisplayName()).explanation("it is required by HashLoginService").valid(false).build());
            }
        }
        return results;
    }

    private static int getPort(JettyServerUpgradeRequest servletUpgradeRequest) {
        SocketAddress localSocketAddress = servletUpgradeRequest.getLocalSocketAddress();
        if (localSocketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)localSocketAddress;
            return inetSocketAddress.getPort();
        }
        throw new IllegalStateException("Expected InetSocketAddress but got: %s".formatted(localSocketAddress == null ? "null" : localSocketAddress.getClass().getName()));
    }

    @OnEnabled
    public void startServer(ConfigurationContext context) throws Exception {
        if (this.server != null && this.server.isRunning()) {
            this.getLogger().info("Jetty WebSocket Server running {}", new Object[]{this.server});
            return;
        }
        this.server = new Server();
        ContextHandlerCollection handlerCollection = new ContextHandlerCollection(new ContextHandler[0]);
        ServletContextHandler contextHandler = new ServletContextHandler();
        contextHandler.setClassLoader(((Object)((Object)this)).getClass().getClassLoader());
        if (context.getProperty(BASIC_AUTH).asBoolean().booleanValue()) {
            ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
            contextHandler.insertHandler((Handler.Singleton)securityHandler);
            String roles = context.getProperty(AUTH_ROLES).evaluateAttributeExpressions().getValue();
            Constraint constraint = Constraint.from((String[])roles.split(","));
            ConstraintMapping constraintMapping = new ConstraintMapping();
            constraintMapping.setPathSpec(context.getProperty(AUTH_PATH_SPEC).evaluateAttributeExpressions().getValue());
            constraintMapping.setConstraint(constraint);
            DefaultAuthenticatorFactory authenticatorFactory = new DefaultAuthenticatorFactory();
            securityHandler.setAuthenticatorFactory((Authenticator.Factory)authenticatorFactory);
            securityHandler.setAuthenticationType("BASIC");
            securityHandler.setRealmName(((Object)((Object)this)).getClass().getSimpleName());
            securityHandler.setConstraintMappings(Collections.singletonList(constraintMapping));
            String loginServiceValue = context.getProperty(LOGIN_SERVICE).getValue();
            if (!LOGIN_SERVICE_HASH.getValue().equals(loginServiceValue)) {
                throw new IllegalArgumentException("Unsupported Login Service: " + loginServiceValue);
            }
            String usersFilePath = context.getProperty(USERS_PROPERTIES_FILE).evaluateAttributeExpressions().getValue();
            Path resourcePath = Paths.get(usersFilePath, new String[0]);
            PathResourceFactory pathResourceFactory = new PathResourceFactory();
            Resource pathResource = pathResourceFactory.newResource(resourcePath);
            HashLoginService loginService = new HashLoginService("HashLoginService", pathResource);
            this.server.addBean((Object)loginService);
            securityHandler.setLoginService((LoginService)loginService);
        }
        ServletHandler servletHandler = new ServletHandler();
        JettyWebSocketServletContainerInitializer.configure((ServletContextHandler)contextHandler, null);
        contextHandler.insertHandler((Handler.Singleton)servletHandler);
        handlerCollection.setHandlers(new Handler[]{contextHandler});
        this.server.setHandler((Handler)handlerCollection);
        this.listenPort = context.getProperty(PORT).evaluateAttributeExpressions().asInteger();
        ServerConnector serverConnector = this.getServerConnector(context);
        this.server.setConnectors(new Connector[]{serverConnector});
        StandardJettyWebSocketServlet webSocketServlet = new StandardJettyWebSocketServlet(context);
        servletHandler.addServletWithMapping(new ServletHolder((Servlet)webSocketServlet), "/*");
        this.getLogger().info("Starting Jetty WebSocket Server on Port {}", new Object[]{this.listenPort});
        this.server.start();
        this.listenPort = serverConnector.getLocalPort();
        portToControllerService.put(this.listenPort, this);
    }

    public List<ListenPort> getListenPorts(ConfigurationContext context) {
        List<ListenPort> ports;
        Integer portNumber = context.getProperty(PORT).evaluateAttributeExpressions().asInteger();
        if (portNumber == null) {
            ports = List.of();
        } else {
            StandardListenPort port = StandardListenPort.builder().portNumber(portNumber.intValue()).portName(PORT.getDisplayName()).transportProtocol(TransportProtocol.TCP).applicationProtocols(List.of("ws")).build();
            ports = List.of(port);
        }
        return ports;
    }

    public int getListeningPort() {
        return this.listenPort;
    }

    private ServerConnector getServerConnector(ConfigurationContext context) {
        ServerConnector serverConnector;
        StandardServerConnectorFactory serverConnectorFactory = new StandardServerConnectorFactory(this.server, this.listenPort.intValue());
        SSLContextProvider sslContextProvider = (SSLContextProvider)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextProvider.class);
        if (sslContextProvider == null) {
            serverConnector = serverConnectorFactory.getServerConnector();
        } else {
            SSLContext sslContext = sslContextProvider.createContext();
            serverConnectorFactory.setSslContext(sslContext);
            String clientAuthValue = context.getProperty(CLIENT_AUTH).getValue();
            if (CLIENT_NEED.getValue().equals(clientAuthValue)) {
                serverConnectorFactory.setNeedClientAuth(true);
            } else if (CLIENT_WANT.getValue().equals(clientAuthValue)) {
                serverConnectorFactory.setWantClientAuth(true);
            }
            serverConnector = serverConnectorFactory.getServerConnector();
        }
        return serverConnector;
    }

    @OnDisabled
    @OnShutdown
    public void stopServer() throws Exception {
        if (this.server == null) {
            return;
        }
        this.getLogger().info("Stopping Jetty WebSocket Server");
        this.server.stop();
        if (portToControllerService.containsKey(this.listenPort) && this.getIdentifier().equals(portToControllerService.get(this.listenPort).getIdentifier())) {
            portToControllerService.remove(this.listenPort);
        }
    }

    public static class StandardJettyWebSocketServlet
    extends JettyWebSocketServlet
    implements JettyWebSocketCreator {
        private final ConfigurationContext context;

        public StandardJettyWebSocketServlet(ConfigurationContext context) {
            this.context = context;
        }

        public void configure(JettyWebSocketServletFactory webSocketServletFactory) {
            int inputBufferSize = this.context.getProperty(AbstractJettyWebSocketService.INPUT_BUFFER_SIZE).asDataSize(DataUnit.B).intValue();
            int maxTextMessageSize = this.context.getProperty(AbstractJettyWebSocketService.MAX_TEXT_MESSAGE_SIZE).asDataSize(DataUnit.B).intValue();
            int maxBinaryMessageSize = this.context.getProperty(AbstractJettyWebSocketService.MAX_BINARY_MESSAGE_SIZE).asDataSize(DataUnit.B).intValue();
            long idleTimeoutMillis = this.context.getProperty(AbstractJettyWebSocketService.IDLE_TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS);
            webSocketServletFactory.setInputBufferSize(inputBufferSize);
            webSocketServletFactory.setMaxTextMessageSize((long)maxTextMessageSize);
            webSocketServletFactory.setMaxBinaryMessageSize((long)maxBinaryMessageSize);
            webSocketServletFactory.setIdleTimeout(Duration.ofMillis(idleTimeoutMillis));
            webSocketServletFactory.setCreator((JettyWebSocketCreator)this);
        }

        public Object createWebSocket(JettyServerUpgradeRequest servletUpgradeRequest, JettyServerUpgradeResponse servletUpgradeResponse) {
            WebSocketMessageRouter router;
            URI requestURI = servletUpgradeRequest.getRequestURI();
            int port = JettyWebSocketServer.getPort(servletUpgradeRequest);
            JettyWebSocketServer service = portToControllerService.get(port);
            if (service == null) {
                throw new RuntimeException("No controller service is bound with port: " + port);
            }
            String path = requestURI.getPath();
            try {
                router = service.routers.getRouterOrFail(path);
            }
            catch (WebSocketConfigurationException e) {
                throw new IllegalStateException("Failed to get router due to: " + String.valueOf((Object)e), e);
            }
            return new RoutingWebSocketListener(router);
        }
    }
}

