/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.websocket.jetty;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.apache.nifi.websocket.AbstractWebSocketSession;
import org.eclipse.jetty.websocket.api.Callback;
import org.eclipse.jetty.websocket.api.Session;

public class JettyWebSocketSession
extends AbstractWebSocketSession {
    private final String sessionId;
    private final Session session;

    public JettyWebSocketSession(String sessionId, Session session) {
        this.sessionId = sessionId;
        this.session = session;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void sendString(String message) {
        this.session.sendText(message, (Callback)new Callback.Completable());
    }

    public void sendBinary(ByteBuffer data) {
        this.session.sendBinary(data, (Callback)new Callback.Completable());
    }

    public void close(String reason) {
        this.session.close(1000, reason, (Callback)new Callback.Completable());
    }

    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.session.getRemoteSocketAddress();
    }

    public InetSocketAddress getLocalAddress() {
        return (InetSocketAddress)this.session.getLocalSocketAddress();
    }

    public boolean isSecure() {
        return this.session.isSecure();
    }
}

