/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.spring;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authentication.AuthenticationResponse;
import org.apache.nifi.authentication.LoginCredentials;
import org.apache.nifi.authentication.LoginIdentityProvider;
import org.apache.nifi.authentication.LoginIdentityProviderConfigurationContext;
import org.apache.nifi.authentication.LoginIdentityProviderInitializationContext;
import org.apache.nifi.authentication.LoginIdentityProviderLookup;
import org.apache.nifi.authentication.annotation.LoginIdentityProviderContext;
import org.apache.nifi.authentication.exception.ProviderCreationException;
import org.apache.nifi.authentication.exception.ProviderDestructionException;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.spring.StandardLoginIdentityProviderConfigurationContext;
import org.apache.nifi.web.security.spring.StandardLoginIdentityProviderInitializationContext;
import org.apache.nifi.xml.processing.ProcessingException;
import org.apache.nifi.xml.processing.parsers.StandardDocumentProvider;
import org.apache.nifi.xml.processing.validation.StandardSchemaValidator;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LoginIdentityProviderFactoryBean
implements FactoryBean<Object>,
DisposableBean,
LoginIdentityProviderLookup {
    private static final String LOGIN_IDENTITY_PROVIDERS_XSD = "/login-identity-providers.xsd";
    private NiFiProperties properties;
    private ExtensionManager extensionManager;
    private LoginIdentityProvider loginIdentityProvider;
    private final Map<String, LoginIdentityProvider> loginIdentityProviders = new HashMap<String, LoginIdentityProvider>();

    public void setProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    public LoginIdentityProvider getLoginIdentityProvider(String identifier) {
        return this.loginIdentityProviders.get(identifier);
    }

    public Object getObject() throws Exception {
        String loginIdentityProviderIdentifier;
        if (this.loginIdentityProvider == null && StringUtils.isNotBlank((CharSequence)(loginIdentityProviderIdentifier = this.properties.getProperty("nifi.security.user.login.identity.provider")))) {
            Map<String, LoginIdentityProvider> loadedLoginIdentityProviders = this.loadLoginIdentityProviders();
            this.loginIdentityProviders.putAll(loadedLoginIdentityProviders);
            this.loginIdentityProvider = this.loginIdentityProviders.get(loginIdentityProviderIdentifier);
            if (this.loginIdentityProvider == null) {
                throw new IllegalStateException("Login Identity Provider [%s] not found".formatted(loginIdentityProviderIdentifier));
            }
        }
        return this.loginIdentityProvider;
    }

    private Map<String, LoginIdentityProvider> loadLoginIdentityProviders() throws Exception {
        File loginIdentityProvidersConfigurationFile = this.properties.getLoginIdentityProviderConfigurationFile();
        if (loginIdentityProvidersConfigurationFile.exists()) {
            Map<String, LoginIdentityProvider> map;
            FileInputStream inputStream = new FileInputStream(loginIdentityProvidersConfigurationFile);
            try {
                SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                Schema schema = schemaFactory.newSchema(this.getClass().getResource(LOGIN_IDENTITY_PROVIDERS_XSD));
                StandardSchemaValidator schemaValidator = new StandardSchemaValidator();
                StandardDocumentProvider documentProvider = new StandardDocumentProvider();
                Document document = documentProvider.parse((InputStream)inputStream);
                DOMSource source = new DOMSource(document);
                schemaValidator.validate(schema, (Source)source);
                map = this.loadLoginIdentityProviders(document);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((InputStream)inputStream).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (ProcessingException e) {
                    throw new Exception("Unable to load the login identity provider configuration file at: " + loginIdentityProvidersConfigurationFile.getAbsolutePath());
                }
            }
            ((InputStream)inputStream).close();
            return map;
        }
        throw new Exception("Unable to find the login identity provider configuration file at " + loginIdentityProvidersConfigurationFile.getAbsolutePath());
    }

    private Map<String, LoginIdentityProvider> loadLoginIdentityProviders(Document document) throws Exception {
        Element loginIdentityProviders = (Element)document.getElementsByTagName("loginIdentityProviders").item(0);
        NodeList providers = loginIdentityProviders.getElementsByTagName("provider");
        HashMap<String, LoginIdentityProvider> loadedProviders = new HashMap<String, LoginIdentityProvider>();
        for (int i = 0; i < providers.getLength(); ++i) {
            Element provider = (Element)providers.item(i);
            NodeList identifiers = provider.getElementsByTagName("identifier");
            Node firstIdentifier = identifiers.item(0);
            String providerIdentifier = firstIdentifier.getFirstChild().getTextContent();
            Node providerClass = provider.getElementsByTagName("class").item(0);
            String providerClassName = providerClass.getFirstChild().getTextContent();
            LoginIdentityProvider identityProvider = this.createLoginIdentityProvider(providerIdentifier, providerClassName);
            LoginIdentityProviderConfigurationContext configurationContext = this.getConfigurationContext(providerIdentifier, provider);
            identityProvider.onConfigured(configurationContext);
            loadedProviders.put(providerIdentifier, identityProvider);
        }
        return loadedProviders;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoginIdentityProvider createLoginIdentityProvider(String identifier, String loginIdentityProviderClassName) throws Exception {
        LoginIdentityProvider instance;
        List loginIdentityProviderBundles = this.extensionManager.getBundles(loginIdentityProviderClassName);
        if (loginIdentityProviderBundles.isEmpty()) {
            throw new Exception("Login Identity Provider class [%s] not registered in loaded Extension Bundles".formatted(loginIdentityProviderClassName));
        }
        if (loginIdentityProviderBundles.size() > 1) {
            throw new Exception(String.format("Multiple bundles found for the specified login identity provider class '%s', only one is allowed.", loginIdentityProviderClassName));
        }
        Bundle loginIdentityProviderBundle = (Bundle)loginIdentityProviderBundles.getFirst();
        ClassLoader loginIdentityProviderClassLoader = loginIdentityProviderBundle.getClassLoader();
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(loginIdentityProviderClassLoader);
            Class<?> rawLoginIdentityProviderClass = Class.forName(loginIdentityProviderClassName, true, loginIdentityProviderClassLoader);
            Class<LoginIdentityProvider> loginIdentityProviderClass = rawLoginIdentityProviderClass.asSubclass(LoginIdentityProvider.class);
            Constructor<LoginIdentityProvider> constructor = loginIdentityProviderClass.getConstructor(new Class[0]);
            instance = constructor.newInstance(new Object[0]);
            this.performMethodInjection(instance, loginIdentityProviderClass);
            this.performFieldInjection(instance, loginIdentityProviderClass);
            instance.initialize((LoginIdentityProviderInitializationContext)new StandardLoginIdentityProviderInitializationContext(identifier, this));
        }
        finally {
            if (currentClassLoader != null) {
                Thread.currentThread().setContextClassLoader(currentClassLoader);
            }
        }
        return this.withNarLoader(instance);
    }

    private LoginIdentityProviderConfigurationContext getConfigurationContext(String identifier, Element provider) {
        HashMap<String, String> providerProperties = new HashMap<String, String>();
        NodeList properties = provider.getElementsByTagName("property");
        for (int i = 0; i < properties.getLength(); ++i) {
            String propertyValue;
            Element property = (Element)properties.item(i);
            String propertyName = property.getAttribute("name");
            if (!property.hasChildNodes() || !StringUtils.isNotBlank((CharSequence)(propertyValue = property.getFirstChild().getNodeValue()))) continue;
            providerProperties.put(propertyName, propertyValue);
        }
        return new StandardLoginIdentityProviderConfigurationContext(identifier, providerProperties);
    }

    private void performMethodInjection(LoginIdentityProvider instance, Class<?> loginIdentityProviderClass) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        for (Method method : loginIdentityProviderClass.getMethods()) {
            Class<?> argumentType;
            if (!method.isAnnotationPresent(LoginIdentityProviderContext.class)) continue;
            method.setAccessible(true);
            Class<?>[] argumentTypes = method.getParameterTypes();
            if (argumentTypes.length != 1 || !NiFiProperties.class.isAssignableFrom(argumentType = argumentTypes[0])) continue;
            method.invoke((Object)instance, this.properties);
        }
        Class<?> parentClass = loginIdentityProviderClass.getSuperclass();
        if (parentClass != null && LoginIdentityProvider.class.isAssignableFrom(parentClass)) {
            this.performMethodInjection(instance, parentClass);
        }
    }

    private void performFieldInjection(LoginIdentityProvider instance, Class<?> loginIdentityProviderClass) throws IllegalArgumentException, IllegalAccessException {
        for (Field field : loginIdentityProviderClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(LoginIdentityProviderContext.class)) continue;
            field.setAccessible(true);
            Class<?> fieldType = field.getType();
            if (field.get(instance) != null || !NiFiProperties.class.isAssignableFrom(fieldType)) continue;
            field.set(instance, this.properties);
        }
        Class<?> parentClass = loginIdentityProviderClass.getSuperclass();
        if (parentClass != null && LoginIdentityProvider.class.isAssignableFrom(parentClass)) {
            this.performFieldInjection(instance, parentClass);
        }
    }

    private LoginIdentityProvider withNarLoader(final LoginIdentityProvider baseProvider) {
        return new LoginIdentityProvider(){

            public AuthenticationResponse authenticate(LoginCredentials credentials) {
                try (NarCloseable ignored = NarCloseable.withNarLoader();){
                    AuthenticationResponse authenticationResponse = baseProvider.authenticate(credentials);
                    return authenticationResponse;
                }
            }

            public void initialize(LoginIdentityProviderInitializationContext initializationContext) throws ProviderCreationException {
                try (NarCloseable ignored = NarCloseable.withNarLoader();){
                    baseProvider.initialize(initializationContext);
                }
            }

            public void onConfigured(LoginIdentityProviderConfigurationContext configurationContext) throws ProviderCreationException {
                try (NarCloseable ignored = NarCloseable.withNarLoader();){
                    baseProvider.onConfigured(configurationContext);
                }
            }

            public void preDestruction() throws ProviderDestructionException {
                try (NarCloseable ignored = NarCloseable.withNarLoader();){
                    baseProvider.preDestruction();
                }
            }
        };
    }

    public Class<?> getObjectType() {
        return LoginIdentityProvider.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() {
        if (this.loginIdentityProvider != null) {
            this.loginIdentityProvider.preDestruction();
        }
    }

    public void setExtensionManager(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }
}

