/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.jwt.provider;

import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.web.security.jwt.provider.IssuerProvider;

public class StandardIssuerProvider
implements IssuerProvider {
    private static final String HTTPS_SCHEME = "https";
    private static final Pattern HOST_CHARACTERS_PATTERN = Pattern.compile("[^a-zA-Z0-9-.]");
    private static final String REPLACEMENT_CHARACTER = "-";
    private final URI issuer;

    public StandardIssuerProvider(String host, int port) {
        String resolvedHost = this.getResolvedHost(host);
        try {
            this.issuer = new URI(HTTPS_SCHEME, null, resolvedHost, port, null, null, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("URI construction failed with Host [%s]".formatted(resolvedHost), e);
        }
    }

    @Override
    public URI getIssuer() {
        return this.issuer;
    }

    private String getResolvedHost(String host) {
        String resolvedHost = host == null || host.isEmpty() ? this.getLocalHost() : host;
        Matcher resolvedHostMatcher = HOST_CHARACTERS_PATTERN.matcher(resolvedHost);
        return resolvedHostMatcher.replaceAll(REPLACEMENT_CHARACTER);
    }

    private String getLocalHost() {
        try {
            InetAddress localHostAddress = InetAddress.getLocalHost();
            return localHostAddress.getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException("Failed to resolve local host address", e);
        }
    }
}

