/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.csrf;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.net.URI;
import java.time.Duration;
import java.util.UUID;
import org.apache.nifi.web.security.cookie.ApplicationCookieName;
import org.apache.nifi.web.security.cookie.ApplicationCookieService;
import org.apache.nifi.web.security.cookie.StandardApplicationCookieService;
import org.apache.nifi.web.security.http.SecurityCookieName;
import org.apache.nifi.web.security.http.SecurityHeader;
import org.apache.nifi.web.servlet.shared.RequestUriBuilder;
import org.springframework.http.ResponseCookie;
import org.springframework.security.web.csrf.CsrfToken;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.csrf.DefaultCsrfToken;
import org.springframework.util.StringUtils;
import org.springframework.web.util.WebUtils;

public class StandardCookieCsrfTokenRepository
implements CsrfTokenRepository {
    private static final String REQUEST_PARAMETER = "requestToken";
    private static final ApplicationCookieService applicationCookieService = new CsrfApplicationCookieService();

    public CsrfToken generateToken(HttpServletRequest httpServletRequest) {
        CsrfToken csrfToken = this.loadToken(httpServletRequest);
        if (csrfToken == null) {
            csrfToken = this.getCsrfToken(this.generateRandomToken());
        }
        return csrfToken;
    }

    public void saveToken(CsrfToken csrfToken, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        URI uri = RequestUriBuilder.fromHttpServletRequest((HttpServletRequest)httpServletRequest).build();
        if (csrfToken == null) {
            applicationCookieService.removeCookie(uri, httpServletResponse, ApplicationCookieName.REQUEST_TOKEN);
        } else {
            String token = csrfToken.getToken();
            applicationCookieService.addSessionCookie(uri, httpServletResponse, ApplicationCookieName.REQUEST_TOKEN, token);
        }
    }

    public CsrfToken loadToken(HttpServletRequest httpServletRequest) {
        Cookie cookie = WebUtils.getCookie((HttpServletRequest)httpServletRequest, (String)SecurityCookieName.REQUEST_TOKEN.getName());
        String token = cookie == null ? null : cookie.getValue();
        return StringUtils.hasLength((String)token) ? this.getCsrfToken(token) : null;
    }

    private CsrfToken getCsrfToken(String token) {
        return new DefaultCsrfToken(SecurityHeader.REQUEST_TOKEN.getHeader(), REQUEST_PARAMETER, token);
    }

    private String generateRandomToken() {
        return UUID.randomUUID().toString();
    }

    private static class CsrfApplicationCookieService
    extends StandardApplicationCookieService {
        private static final boolean HTTP_ONLY_DISABLED = false;

        private CsrfApplicationCookieService() {
        }

        @Override
        protected ResponseCookie.ResponseCookieBuilder getCookieBuilder(URI resourceUri, ApplicationCookieName applicationCookieName, String value, Duration maxAge) {
            ResponseCookie.ResponseCookieBuilder builder = super.getCookieBuilder(resourceUri, applicationCookieName, value, maxAge);
            builder.httpOnly(false);
            return builder;
        }
    }
}

