/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.configuration;

import java.net.http.HttpClient;
import java.time.Duration;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.security.oidc.registration.DisabledClientRegistrationRepository;
import org.apache.nifi.web.security.oidc.registration.StandardClientRegistrationProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.JdkClientHttpRequestFactory;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.security.oauth2.client.http.OAuth2ErrorResponseErrorHandler;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.registration.InMemoryClientRegistrationRepository;
import org.springframework.security.oauth2.core.http.converter.OAuth2AccessTokenResponseHttpMessageConverter;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestTemplate;

@Configuration
public class ClientRegistrationConfiguration {
    private static final Duration DEFAULT_SOCKET_TIMEOUT = Duration.ofSeconds(5L);
    private static final String NIFI_TRUSTSTORE_STRATEGY = "NIFI";
    private final NiFiProperties properties;
    private final SSLContext sslContext;

    public ClientRegistrationConfiguration(@Autowired NiFiProperties properties, @Autowired(required=false) SSLContext sslContext) {
        this.properties = Objects.requireNonNull(properties, "Application properties required");
        this.sslContext = sslContext;
    }

    @Bean
    public ClientRegistrationRepository clientRegistrationRepository() {
        DisabledClientRegistrationRepository clientRegistrationRepository;
        if (this.properties.isOidcEnabled()) {
            StandardClientRegistrationProvider clientRegistrationProvider = new StandardClientRegistrationProvider(this.properties, this.oidcRestClient());
            ClientRegistration clientRegistration = clientRegistrationProvider.getClientRegistration();
            clientRegistrationRepository = new InMemoryClientRegistrationRepository(new ClientRegistration[]{clientRegistration});
        } else {
            clientRegistrationRepository = new DisabledClientRegistrationRepository();
        }
        return clientRegistrationRepository;
    }

    @Bean
    public RestClient oidcRestClient() {
        return RestClient.create((RestTemplate)this.oidcRestOperations());
    }

    @Bean
    public RestTemplate oidcRestOperations() {
        RestTemplate restTemplate = new RestTemplate(this.oidcClientHttpRequestFactory());
        restTemplate.setErrorHandler((ResponseErrorHandler)new OAuth2ErrorResponseErrorHandler());
        restTemplate.setMessageConverters(Arrays.asList(new FormHttpMessageConverter(), new OAuth2AccessTokenResponseHttpMessageConverter(), new StringHttpMessageConverter(), new MappingJackson2HttpMessageConverter()));
        return restTemplate;
    }

    @Bean
    public ClientHttpRequestFactory oidcClientHttpRequestFactory() {
        HttpClient httpClient = this.getHttpClient();
        JdkClientHttpRequestFactory clientHttpRequestFactory = new JdkClientHttpRequestFactory(httpClient);
        Duration readTimeout = this.getTimeout(this.properties.getOidcReadTimeout());
        clientHttpRequestFactory.setReadTimeout(readTimeout);
        return clientHttpRequestFactory;
    }

    private HttpClient getHttpClient() {
        Duration connectTimeout = this.getTimeout(this.properties.getOidcConnectTimeout());
        HttpClient.Builder builder = HttpClient.newBuilder().connectTimeout(connectTimeout);
        if (NIFI_TRUSTSTORE_STRATEGY.equals(this.properties.getOidcClientTruststoreStrategy())) {
            builder.sslContext(this.sslContext);
        }
        return builder.build();
    }

    private Duration getTimeout(String timeoutExpression) {
        try {
            double duration = FormatUtils.getPreciseTimeDuration((String)timeoutExpression, (TimeUnit)TimeUnit.MILLISECONDS);
            long rounded = Math.round(duration);
            return Duration.ofMillis(rounded);
        }
        catch (RuntimeException e) {
            return DEFAULT_SOCKET_TIMEOUT;
        }
    }
}

