/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Objects;
import org.springframework.security.web.authentication.WebAuthenticationDetails;

public class NiFiWebAuthenticationDetails
extends WebAuthenticationDetails {
    private static final String FORWARD_FOR_HEADER = "X-Forwarded-For";
    private final String userAgent;
    private final String forwardedFor;

    public NiFiWebAuthenticationDetails(HttpServletRequest request) {
        super(request);
        this.userAgent = request.getHeader("User-Agent");
        this.forwardedFor = request.getHeader(FORWARD_FOR_HEADER);
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getForwardedFor() {
        return this.forwardedFor;
    }

    public boolean equals(Object o) {
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NiFiWebAuthenticationDetails details = (NiFiWebAuthenticationDetails)((Object)o);
        return Objects.equals(this.userAgent, details.userAgent) && Objects.equals(this.forwardedFor, details.forwardedFor);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.userAgent, this.forwardedFor);
    }

    public String toString() {
        return "remoteAddress=[%s] userAgent=[%s] forwardedFor=[%s]".formatted(this.getRemoteAddress(), this.userAgent, this.forwardedFor);
    }
}

