/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.configuration;

import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class KeyPairGeneratorConfiguration {
    private static final String STANDARD_KEY_PAIR_ALGORITHM = "Ed25519";
    private static final String STANDARD_KEY_PAIR_ALGORITHM_FILTER = "KeyPairGenerator.Ed25519";
    private static final String FALLBACK_KEY_PAIR_ALGORITHM = "RSA";
    private static final Logger logger = LoggerFactory.getLogger(KeyPairGeneratorConfiguration.class);

    @Bean
    public KeyPairGenerator jwtKeyPairGenerator() throws NoSuchAlgorithmException {
        Provider[] providers = Security.getProviders(STANDARD_KEY_PAIR_ALGORITHM_FILTER);
        String keyPairAlgorithm = providers == null ? FALLBACK_KEY_PAIR_ALGORITHM : STANDARD_KEY_PAIR_ALGORITHM;
        logger.info("Configured Key Pair Algorithm [{}] for JSON Web Signatures", (Object)keyPairAlgorithm);
        return KeyPairGenerator.getInstance(keyPairAlgorithm);
    }
}

