/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.security.jwt.key;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.JWSHeader;
import com.nimbusds.jose.JWSVerifier;
import com.nimbusds.jose.crypto.impl.EdDSAProvider;
import com.nimbusds.jose.util.Base64URL;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Objects;

public class Ed25519Verifier
extends EdDSAProvider
implements JWSVerifier {
    private static final String SIGNING_ALGORITHM = "Ed25519";
    private final PublicKey publicKey;

    public Ed25519Verifier(PublicKey publicKey) {
        this.publicKey = Objects.requireNonNull(publicKey, "Public Key required");
    }

    public boolean verify(JWSHeader jwsHeader, byte[] bytes, Base64URL jwsSignature) throws JOSEException {
        JWSAlgorithm algorithm = jwsHeader.getAlgorithm();
        if (JWSAlgorithm.EdDSA.equals((Object)algorithm)) {
            byte[] signatureDecoded = jwsSignature.decode();
            try {
                Signature signature = this.getInitializedSignature();
                signature.update(bytes);
                return signature.verify(signatureDecoded);
            }
            catch (GeneralSecurityException e) {
                return false;
            }
        }
        throw new JOSEException("JWS Algorithm EdDSA not found [%s]".formatted(algorithm));
    }

    private Signature getInitializedSignature() throws JOSEException {
        try {
            Signature signature = Signature.getInstance(SIGNING_ALGORITHM);
            signature.initVerify(this.publicKey);
            return signature;
        }
        catch (GeneralSecurityException e) {
            throw new JOSEException("Ed25519 signature initialization failed", (Throwable)e);
        }
    }
}

