/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.revision;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.nifi.web.FlowModification;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.revision.RevisionUpdate;

public class StandardRevisionUpdate<T>
implements RevisionUpdate<T> {
    private final T component;
    private final FlowModification lastModification;
    private final Set<Revision> updatedRevisions;

    public StandardRevisionUpdate(T component, FlowModification lastModification) {
        this(component, lastModification, null);
    }

    public StandardRevisionUpdate(T component, FlowModification lastModification, Set<Revision> updatedRevisions) {
        this.component = component;
        this.lastModification = lastModification;
        Set<Revision> set = this.updatedRevisions = updatedRevisions == null ? new HashSet<Revision>() : new HashSet<Revision>(updatedRevisions);
        if (lastModification != null) {
            this.updatedRevisions.add(lastModification.getRevision());
        }
    }

    public T getComponent() {
        return this.component;
    }

    public FlowModification getLastModification() {
        return this.lastModification;
    }

    public Set<Revision> getUpdatedRevisions() {
        return Collections.unmodifiableSet(this.updatedRevisions);
    }

    public String toString() {
        return "[Component=" + String.valueOf(this.component) + ", Last Modification=" + String.valueOf(this.lastModification) + "]";
    }
}

