/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.UriBuilderException;
import org.apache.nifi.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatchAllFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(CatchAllFilter.class);
    private static String whitelistedContextPaths = "";

    public void init(FilterConfig filterConfig) throws ServletException {
        String providedWhitelist = filterConfig.getServletContext().getInitParameter("whitelistedContextPaths");
        logger.debug("CatchAllFilter received provided whitelisted context paths from NiFi properties: " + providedWhitelist);
        if (providedWhitelist != null) {
            whitelistedContextPaths = providedWhitelist;
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain filterChain) throws IOException, ServletException {
        String contextPath = this.getSanitizedContextPath(request);
        request.setAttribute("contextPath", (Object)contextPath);
        request.getRequestDispatcher("/index.jsp").forward(request, response);
    }

    public void destroy() {
    }

    private String getSanitizedContextPath(ServletRequest request) {
        String contextPath = WebUtils.normalizeContextPath((String)WebUtils.determineContextPath((HttpServletRequest)((HttpServletRequest)request)));
        try {
            WebUtils.verifyContextPath((String)whitelistedContextPaths, (String)contextPath);
            return contextPath;
        }
        catch (UriBuilderException e) {
            logger.error("Error determining context path on index.jsp: " + e.getMessage());
            return "";
        }
    }
}

