/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.client;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.nifi.web.client.api.HttpEntityHeaders;

class StandardHttpEntityHeaders
implements HttpEntityHeaders {
    private final Map<String, List<String>> headers;

    StandardHttpEntityHeaders(Map<String, List<String>> headers) {
        this.headers = Collections.unmodifiableMap(headers);
    }

    public Optional<String> getFirstHeader(String headerName) {
        List<String> values = this.getHeader(headerName);
        return values.stream().findFirst();
    }

    public List<String> getHeader(String headerName) {
        Objects.requireNonNull(headerName, "Header Name required");
        List<String> values = this.headers.get(headerName);
        return values == null ? Collections.emptyList() : Collections.unmodifiableList(values);
    }

    public Collection<String> getHeaderNames() {
        return Collections.unmodifiableSet(this.headers.keySet());
    }
}

