/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.client;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.nifi.web.client.api.HttpUriBuilder;

public class StandardHttpUriBuilder
implements HttpUriBuilder {
    private static final String HTTP_SCHEME = "http";
    private static final String HTTPS_SCHEME = "https";
    private static final int UNKNOWN_PORT = -1;
    private static final int MAXIMUM_PORT = 65535;
    private static final char PATH_SEGMENT_SEPARATOR_CHARACTER = '/';
    private static final String PATH_SEGMENT_SEPARATOR = "/";
    private static final String QUERY_PARAMETER_SEPARATOR = "&";
    private static final String QUERY_PARAMETER_VALUE_SEPARATOR = "=";
    private String scheme = "http";
    private String host;
    private int port = -1;
    private String encodedPath;
    private final List<String> pathSegments = new ArrayList<String>();
    private final Map<String, List<String>> queryParameters = new LinkedHashMap<String, List<String>>();

    public URI build() {
        if (this.host == null) {
            throw new IllegalStateException("Host not specified");
        }
        String resolvedPath = this.getResolvedPath();
        String resolvedQuery = this.getResolvedQuery();
        try {
            return new URI(this.scheme, null, this.host, this.port, resolvedPath, resolvedQuery, null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("URI construction failed", e);
        }
    }

    public HttpUriBuilder scheme(String scheme) {
        Objects.requireNonNull(scheme, "Scheme required");
        if (!HTTP_SCHEME.equals(scheme) && !HTTPS_SCHEME.equals(scheme)) {
            throw new IllegalArgumentException("Scheme [%s] not supported".formatted(scheme));
        }
        this.scheme = scheme;
        return this;
    }

    public HttpUriBuilder host(String host) {
        Objects.requireNonNull(host, "Host required");
        this.host = host;
        return this;
    }

    public HttpUriBuilder port(int port) {
        if (port < -1 || port > 65535) {
            throw new IllegalArgumentException("Port [%d] not valid".formatted(port));
        }
        this.port = port;
        return this;
    }

    public HttpUriBuilder encodedPath(String encodedPath) {
        this.encodedPath = encodedPath;
        return this;
    }

    public HttpUriBuilder addPathSegment(String pathSegment) {
        Objects.requireNonNull(pathSegment, "Path segment required");
        this.pathSegments.add(pathSegment);
        return this;
    }

    public HttpUriBuilder addQueryParameter(String name, String value) {
        Objects.requireNonNull(name, "Parameter name required");
        List parameters = this.queryParameters.computeIfAbsent(name, parameterName -> new ArrayList());
        parameters.add(value);
        return this;
    }

    private String getResolvedPath() {
        String path;
        StringBuilder pathBuilder = new StringBuilder();
        if (this.encodedPath != null) {
            String decodedPath = URLDecoder.decode(this.encodedPath, StandardCharsets.UTF_8);
            pathBuilder.append(decodedPath);
        }
        if (!this.pathSegments.isEmpty()) {
            int lastIndex;
            char lastCharacter;
            int pathBuilderLength = pathBuilder.length();
            if (pathBuilderLength > 0 && '/' != (lastCharacter = pathBuilder.charAt(lastIndex = pathBuilderLength - 1))) {
                pathBuilder.append('/');
            }
            String separatedPath = String.join((CharSequence)PATH_SEGMENT_SEPARATOR, this.pathSegments);
            pathBuilder.append(separatedPath);
        }
        Object resolvedPath = (path = pathBuilder.toString()).startsWith(PATH_SEGMENT_SEPARATOR) ? path : PATH_SEGMENT_SEPARATOR + path;
        return resolvedPath;
    }

    private String getResolvedQuery() {
        StringBuilder queryBuilder = new StringBuilder();
        Iterator<Map.Entry<String, List<String>>> parameters = this.queryParameters.entrySet().iterator();
        while (parameters.hasNext()) {
            Map.Entry<String, List<String>> parameter = parameters.next();
            String name = parameter.getKey();
            queryBuilder.append(name);
            Iterator<String> values = parameter.getValue().iterator();
            while (values.hasNext()) {
                String value = values.next();
                if (value != null) {
                    queryBuilder.append(QUERY_PARAMETER_VALUE_SEPARATOR);
                    queryBuilder.append(value);
                }
                if (!values.hasNext()) continue;
                queryBuilder.append(QUERY_PARAMETER_SEPARATOR);
                queryBuilder.append(name);
            }
            if (!parameters.hasNext()) continue;
            queryBuilder.append(QUERY_PARAMETER_SEPARATOR);
        }
        String query = queryBuilder.isEmpty() ? null : queryBuilder.toString();
        return query;
    }
}

