/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.nifi.flow.VersionedParameterContext;
import org.apache.nifi.flow.VersionedProcessGroup;
import org.apache.nifi.registry.flow.RegisteredFlowSnapshot;
import org.apache.nifi.web.api.entity.ParameterContextEntity;
import org.apache.nifi.web.util.ParameterContextNameCollisionResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterContextReplacer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ParameterContextReplacer.class);
    private final ParameterContextNameCollisionResolver nameCollisionResolver;

    public ParameterContextReplacer(ParameterContextNameCollisionResolver nameCollisionResolver) {
        this.nameCollisionResolver = nameCollisionResolver;
    }

    public void replaceParameterContexts(RegisteredFlowSnapshot flowSnapshot, Collection<ParameterContextEntity> existingContexts) {
        Map parameterContexts = flowSnapshot.getParameterContexts();
        Map replacements = this.replaceParameterContexts(flowSnapshot.getFlowContents(), parameterContexts, new HashMap(), existingContexts);
        for (Map.Entry replacement : replacements.entrySet()) {
            for (VersionedParameterContext parameterContext : parameterContexts.values()) {
                List inheritedContexts = parameterContext.getInheritedParameterContexts();
                if (!inheritedContexts.contains(replacement.getKey())) continue;
                inheritedContexts.remove(replacement.getKey());
                inheritedContexts.add(((VersionedParameterContext)replacement.getValue()).getName());
            }
        }
    }

    private Map<String, VersionedParameterContext> replaceParameterContexts(VersionedProcessGroup group, Map<String, VersionedParameterContext> flowParameterContexts, Map<String, VersionedParameterContext> replacements, Collection<ParameterContextEntity> existingContexts) {
        if (group.getParameterContextName() != null) {
            String oldParameterContextName = group.getParameterContextName();
            VersionedParameterContext oldParameterContext = flowParameterContexts.get(oldParameterContextName);
            if (replacements.containsKey(oldParameterContextName)) {
                String replacementContextName = replacements.get(oldParameterContextName).getName();
                group.setParameterContextName(replacementContextName);
                LOGGER.debug("Replacing Parameter Context in Group {} from {} into {}", new Object[]{group.getIdentifier(), oldParameterContext, replacementContextName});
            } else {
                VersionedParameterContext replacementContext = this.createReplacementContext(oldParameterContext, existingContexts);
                group.setParameterContextName(replacementContext.getName());
                flowParameterContexts.remove(oldParameterContextName);
                flowParameterContexts.put(replacementContext.getName(), replacementContext);
                replacements.put(oldParameterContextName, replacementContext);
                LOGGER.debug("Replacing Parameter Context in Group {} from {} into the newly created {}", new Object[]{group.getIdentifier(), oldParameterContext, replacementContext.getName()});
            }
        }
        for (VersionedProcessGroup childGroup : group.getProcessGroups()) {
            this.replaceParameterContexts(childGroup, flowParameterContexts, replacements, existingContexts);
        }
        return replacements;
    }

    private VersionedParameterContext createReplacementContext(VersionedParameterContext original, Collection<ParameterContextEntity> existingContexts) {
        VersionedParameterContext replacement = new VersionedParameterContext();
        replacement.setName(this.nameCollisionResolver.resolveNameCollision(original.getName(), existingContexts));
        replacement.setParameters(new HashSet(original.getParameters()));
        replacement.setInheritedParameterContexts((List)Optional.ofNullable(original.getInheritedParameterContexts()).orElse(new ArrayList()));
        replacement.setDescription(original.getDescription());
        replacement.setSynchronized(original.isSynchronized());
        replacement.setParameterProvider(original.getParameterProvider());
        replacement.setParameterGroupName(original.getParameterGroupName());
        return replacement;
    }
}

