/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.search.attributematchers;

import java.util.List;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.NarCloseable;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.search.SearchContext;
import org.apache.nifi.search.Searchable;
import org.apache.nifi.web.controller.StandardSearchContext;
import org.apache.nifi.web.search.attributematchers.AttributeMatcher;
import org.apache.nifi.web.search.query.SearchQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchableMatcher
implements AttributeMatcher<ProcessorNode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchableMatcher.class);
    private FlowController flowController;

    public void match(ProcessorNode component, SearchQuery query, List<String> matches) {
        Processor processor = component.getProcessor();
        if (processor instanceof Searchable) {
            Searchable searchable = (Searchable)processor;
            String searchTerm = query.getTerm();
            StandardSearchContext context = new StandardSearchContext(searchTerm, component, (ControllerServiceLookup)this.flowController.getControllerServiceProvider());
            try (NarCloseable narCloseable = NarCloseable.withComponentNarLoader((ExtensionManager)this.flowController.getExtensionManager(), component.getClass(), (String)component.getIdentifier());){
                searchable.search((SearchContext)context).stream().forEach(searchResult -> matches.add(searchResult.getLabel() + ": " + searchResult.getMatch()));
            }
            catch (Throwable t) {
                LOGGER.error("Error happened during searchable matching: {}", (Object)t.getMessage());
                t.printStackTrace();
            }
        }
    }

    public void setFlowController(FlowController flowController) {
        this.flowController = flowController;
    }
}

