/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.net.URI;
import java.util.Collections;
import org.apache.nifi.authorization.AccessDeniedException;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.cluster.coordination.ClusterCoordinator;
import org.apache.nifi.cluster.coordination.http.replication.RequestReplicationHeader;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.controller.repository.claim.ContentDirection;
import org.apache.nifi.web.DownloadableContent;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.dto.provenance.ProvenanceEventDTO;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.LatestProvenanceEventsEntity;
import org.apache.nifi.web.api.entity.ProvenanceEventEntity;
import org.apache.nifi.web.api.entity.ReplayLastEventRequestEntity;
import org.apache.nifi.web.api.entity.ReplayLastEventResponseEntity;
import org.apache.nifi.web.api.entity.ReplayLastEventSnapshotDTO;
import org.apache.nifi.web.api.entity.SubmitReplayRequestEntity;
import org.apache.nifi.web.api.request.LongParameter;
import org.apache.nifi.web.api.streaming.StreamingOutputResponseBuilder;
import org.apache.nifi.web.util.ResponseBuilderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
@Path(value="/provenance-events")
@Tag(name="ProvenanceEvents")
public class ProvenanceEventResource
extends ApplicationResource {
    private static final Logger logger = LoggerFactory.getLogger(ProvenanceEventResource.class);
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"*/*"})
    @Path(value="{id}/content/input")
    @Operation(summary="Gets the input content for a provenance event", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=StreamingOutput.class))})}, security={@SecurityRequirement(name="Read Component Provenance Data - /provenance-data/{component-type}/{uuid}"), @SecurityRequirement(name="Read Component Data - /data/{component-type}/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="206", description="Partial Content with range of bytes requested"), @ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it."), @ApiResponse(responseCode="416", description="Requested Range Not Satisfiable based on bytes requested")})
    public Response getInputContent(@Parameter(description="Range of bytes requested") @HeaderParam(value="Range") String rangeHeader, @Parameter(description="The id of the node where the content exists if clustered.") @QueryParam(value="clusterNodeId") String clusterNodeId, @Parameter(description="The provenance event id.", required=true) @PathParam(value="id") LongParameter id) {
        if (id == null) {
            throw new IllegalArgumentException("The event id must be specified.");
        }
        if (this.isReplicateRequest()) {
            if (clusterNodeId == null) {
                throw new IllegalArgumentException("The id of the node in the cluster is required.");
            }
            return this.replicate("GET", clusterNodeId);
        }
        String uri = this.generateResourceUri(new String[]{"provenance", "events", String.valueOf(id.getLong()), "content", "input"});
        DownloadableContent content = this.serviceFacade.getContent(id.getLong(), uri, ContentDirection.INPUT);
        Response.ResponseBuilder responseBuilder = this.noCache(new StreamingOutputResponseBuilder(content.getContent()).range(rangeHeader).build());
        String contentType = content.getType();
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        responseBuilder.type(contentType);
        return ResponseBuilderUtils.setContentDisposition((Response.ResponseBuilder)responseBuilder, (String)content.getFilename()).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"*/*"})
    @Path(value="{id}/content/output")
    @Operation(summary="Gets the output content for a provenance event", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=StreamingOutput.class))})}, security={@SecurityRequirement(name="Read Component Provenance Data - /provenance-data/{component-type}/{uuid}"), @SecurityRequirement(name="Read Component Data - /data/{component-type}/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="206", description="Partial Content with range of bytes requested"), @ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it."), @ApiResponse(responseCode="416", description="Requested Range Not Satisfiable based on bytes requested")})
    public Response getOutputContent(@Parameter(description="Range of bytes requested") @HeaderParam(value="Range") String rangeHeader, @Parameter(description="The id of the node where the content exists if clustered.") @QueryParam(value="clusterNodeId") String clusterNodeId, @Parameter(description="The provenance event id.", required=true) @PathParam(value="id") LongParameter id) {
        if (id == null) {
            throw new IllegalArgumentException("The event id must be specified.");
        }
        if (this.isReplicateRequest()) {
            if (clusterNodeId == null) {
                throw new IllegalArgumentException("The id of the node in the cluster is required.");
            }
            return this.replicate("GET", clusterNodeId);
        }
        String uri = this.generateResourceUri(new String[]{"provenance", "events", String.valueOf(id.getLong()), "content", "output"});
        DownloadableContent content = this.serviceFacade.getContent(id.getLong(), uri, ContentDirection.OUTPUT);
        Response.ResponseBuilder responseBuilder = this.noCache(new StreamingOutputResponseBuilder(content.getContent()).range(rangeHeader).build());
        String contentType = content.getType();
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        responseBuilder.type(contentType);
        return ResponseBuilderUtils.setContentDisposition((Response.ResponseBuilder)responseBuilder, (String)content.getFilename()).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @Operation(summary="Gets a provenance event", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ProvenanceEventEntity.class))})}, security={@SecurityRequirement(name="Read Component Provenance Data - /provenance-data/{component-type}/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getProvenanceEvent(@Parameter(description="The id of the node where this event exists if clustered.") @QueryParam(value="clusterNodeId") String clusterNodeId, @Parameter(description="The provenance event id.", required=true) @PathParam(value="id") LongParameter id) {
        NodeIdentifier nodeId;
        if (id == null) {
            throw new IllegalArgumentException("Provenance event id must be specified.");
        }
        if (this.isReplicateRequest()) {
            if (clusterNodeId == null) {
                throw new IllegalArgumentException("The cluster node identifier must be specified.");
            }
            return this.replicate("GET", clusterNodeId);
        }
        ProvenanceEventDTO event = this.serviceFacade.getProvenanceEvent(id.getLong());
        event.setClusterNodeId(clusterNodeId);
        ClusterCoordinator coordinator = this.getClusterCoordinator();
        if (coordinator != null && clusterNodeId != null && (nodeId = coordinator.getNodeIdentifier(clusterNodeId)) != null) {
            event.setClusterNodeAddress(nodeId.getApiAddress() + ":" + nodeId.getApiPort());
        }
        ProvenanceEventEntity entity = new ProvenanceEventEntity();
        entity.setProvenanceEvent(event);
        return this.generateOkResponse((Object)entity).build();
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="latest/replays")
    @Operation(summary="Replays content from a provenance event", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ReplayLastEventResponseEntity.class))})}, security={@SecurityRequirement(name="Read Component Provenance Data - /provenance-data/{component-type}/{uuid}"), @SecurityRequirement(name="Read Component Data - /data/{component-type}/{uuid}"), @SecurityRequirement(name="Write Component Data - /data/{component-type}/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response submitReplayLatestEvent(@Parameter(description="The replay request.", required=true) ReplayLastEventRequestEntity requestEntity) {
        if (requestEntity == null || requestEntity.getComponentId() == null) {
            throw new IllegalArgumentException("The id of the component must be specified.");
        }
        String requestedNodes = requestEntity.getNodes();
        if (requestedNodes == null) {
            throw new IllegalArgumentException("The nodes must be specified.");
        }
        if (!"ALL".equalsIgnoreCase(requestedNodes) && !"PRIMARY".equalsIgnoreCase(requestedNodes)) {
            throw new IllegalArgumentException("The nodes must be either ALL or PRIMARY");
        }
        if (this.isReplicateRequest()) {
            if (requestedNodes.equalsIgnoreCase("PRIMARY")) {
                NodeIdentifier primaryNodeId = (NodeIdentifier)this.getPrimaryNodeId().orElseThrow(() -> new IllegalStateException("There is currently no Primary Node elected"));
                return this.replicate("POST", (Object)requestEntity, primaryNodeId.getId());
            }
            return this.replicate("POST", (Object)requestEntity);
        }
        return this.withWriteLock(this.serviceFacade, (Entity)requestEntity, lookup -> {
            Authorizable provenance = lookup.getProvenance();
            provenance.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        }, () -> {}, entity -> {
            ReplayLastEventSnapshotDTO aggregateSnapshot = new ReplayLastEventSnapshotDTO();
            try {
                ProvenanceEventDTO provenanceEventDto = this.serviceFacade.submitReplayLastEvent(entity.getComponentId());
                if (provenanceEventDto == null) {
                    aggregateSnapshot.setEventAvailable(Boolean.valueOf(false));
                } else {
                    aggregateSnapshot.setEventAvailable(Boolean.valueOf(true));
                    aggregateSnapshot.setEventsReplayed(Collections.singleton(provenanceEventDto.getEventId()));
                }
            }
            catch (AccessDeniedException ade) {
                logger.error("Failed to replay latest Provenance Event", (Throwable)ade);
                aggregateSnapshot.setFailureExplanation("Access Denied");
            }
            catch (Exception e) {
                logger.error("Failed to replay latest Provenance Event", (Throwable)e);
                aggregateSnapshot.setFailureExplanation(e.getMessage());
            }
            ReplayLastEventResponseEntity responseEntity = new ReplayLastEventResponseEntity();
            responseEntity.setComponentId(entity.getComponentId());
            responseEntity.setNodes(entity.getNodes());
            responseEntity.setAggregateSnapshot(aggregateSnapshot);
            return this.generateOkResponse((Object)responseEntity).build();
        });
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="replays")
    @Operation(summary="Replays content from a provenance event", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ProvenanceEventEntity.class))})}, security={@SecurityRequirement(name="Read Component Provenance Data - /provenance-data/{component-type}/{uuid}"), @SecurityRequirement(name="Read Component Data - /data/{component-type}/{uuid}"), @SecurityRequirement(name="Write Component Data - /data/{component-type}/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response submitReplay(@Context HttpServletRequest httpServletRequest, @Parameter(description="The replay request.", required=true) SubmitReplayRequestEntity replayRequestEntity) {
        if (replayRequestEntity == null || replayRequestEntity.getEventId() == null) {
            throw new IllegalArgumentException("The id of the event must be specified.");
        }
        if (this.isReplicateRequest()) {
            if (replayRequestEntity.getClusterNodeId() == null) {
                throw new IllegalArgumentException("The id of the node in the cluster is required.");
            }
            return this.replicate("POST", (Object)replayRequestEntity, replayRequestEntity.getClusterNodeId());
        }
        String expects = httpServletRequest.getHeader(RequestReplicationHeader.VALIDATION_EXPECTS.getHeader());
        if (expects != null) {
            return this.generateContinueResponse().build();
        }
        ProvenanceEventDTO event = this.serviceFacade.submitReplay(replayRequestEntity.getEventId());
        event.setClusterNodeId(replayRequestEntity.getClusterNodeId());
        ClusterCoordinator coordinator = this.getClusterCoordinator();
        if (coordinator != null) {
            NodeIdentifier nodeId = coordinator.getNodeIdentifier(replayRequestEntity.getClusterNodeId());
            event.setClusterNodeAddress(nodeId.getApiAddress() + ":" + nodeId.getApiPort());
        }
        ProvenanceEventEntity entity = new ProvenanceEventEntity();
        entity.setProvenanceEvent(event);
        URI uri = URI.create(this.generateResourceUri(new String[]{"provenance-events", event.getId()}));
        return this.generateCreatedResponse(uri, (Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="latest/{componentId}")
    @Operation(summary="Retrieves the latest cached Provenance Events for the specified component", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=LatestProvenanceEventsEntity.class))})}, security={@SecurityRequirement(name="Read Component Provenance Data - /provenance-data/{component-type}/{uuid}"), @SecurityRequirement(name="Read Component Data - /data/{component-type}/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getLatestProvenanceEvents(@Parameter(description="The ID of the component to retrieve the latest Provenance Events for.", required=true) @PathParam(value="componentId") String componentId, @Parameter(description="The number of events to limit the response to. Defaults to 10.") @DefaultValue(value="10") @QueryParam(value="limit") int limit) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        LatestProvenanceEventsEntity entity = this.serviceFacade.getLatestProvenanceEvents(componentId, limit);
        return this.generateOkResponse((Object)entity).build();
    }

    @Autowired
    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    @Autowired
    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }
}

