/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.AccessDeniedException;
import org.apache.nifi.authorization.AccessPolicy;
import org.apache.nifi.authorization.AuthorizableLookup;
import org.apache.nifi.authorization.ComponentAuthorizable;
import org.apache.nifi.authorization.ConnectionAuthorizable;
import org.apache.nifi.authorization.ProcessGroupAuthorizable;
import org.apache.nifi.authorization.PublicPortAuthorizable;
import org.apache.nifi.authorization.SnippetAuthorizable;
import org.apache.nifi.authorization.StandardAuthorizableLookup;
import org.apache.nifi.authorization.resource.AccessPolicyAuthorizable;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.DataAuthorizable;
import org.apache.nifi.authorization.resource.DataTransferAuthorizable;
import org.apache.nifi.authorization.resource.OperationAuthorizable;
import org.apache.nifi.authorization.resource.ProvenanceDataAuthorizable;
import org.apache.nifi.authorization.resource.ResourceType;
import org.apache.nifi.authorization.resource.RestrictedComponentsAuthorizableFactory;
import org.apache.nifi.authorization.resource.TenantAuthorizable;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.RequiredPermission;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.controller.ComponentNode;
import org.apache.nifi.controller.FlowAnalysisRuleNode;
import org.apache.nifi.controller.ParameterProviderNode;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.Snippet;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceReference;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.registry.flow.FlowRegistryClientNode;
import org.apache.nifi.remote.PublicPort;
import org.apache.nifi.util.BundleUtils;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.apache.nifi.web.api.dto.FlowSnippetDTO;
import org.apache.nifi.web.controller.ControllerFacade;
import org.apache.nifi.web.dao.AccessPolicyDAO;
import org.apache.nifi.web.dao.ConnectionDAO;
import org.apache.nifi.web.dao.ControllerServiceDAO;
import org.apache.nifi.web.dao.FlowAnalysisRuleDAO;
import org.apache.nifi.web.dao.FlowRegistryDAO;
import org.apache.nifi.web.dao.FunnelDAO;
import org.apache.nifi.web.dao.LabelDAO;
import org.apache.nifi.web.dao.ParameterContextDAO;
import org.apache.nifi.web.dao.ParameterProviderDAO;
import org.apache.nifi.web.dao.PortDAO;
import org.apache.nifi.web.dao.ProcessGroupDAO;
import org.apache.nifi.web.dao.ProcessorDAO;
import org.apache.nifi.web.dao.RemoteProcessGroupDAO;
import org.apache.nifi.web.dao.ReportingTaskDAO;
import org.apache.nifi.web.dao.SnippetDAO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class StandardAuthorizableLookup
implements AuthorizableLookup {
    private static final TenantAuthorizable TENANT_AUTHORIZABLE = new TenantAuthorizable();
    private static final Authorizable POLICIES_AUTHORIZABLE = new /* Unavailable Anonymous Inner Class!! */;
    private static final Authorizable PROVENANCE_AUTHORIZABLE = new /* Unavailable Anonymous Inner Class!! */;
    private static final Authorizable COUNTERS_AUTHORIZABLE = new /* Unavailable Anonymous Inner Class!! */;
    private static final Authorizable RESOURCE_AUTHORIZABLE = new /* Unavailable Anonymous Inner Class!! */;
    private static final Authorizable SITE_TO_SITE_AUTHORIZABLE = new /* Unavailable Anonymous Inner Class!! */;
    private static final Authorizable FLOW_AUTHORIZABLE = new /* Unavailable Anonymous Inner Class!! */;
    private static final Authorizable SYSTEM_AUTHORIZABLE = new /* Unavailable Anonymous Inner Class!! */;
    private ControllerFacade controllerFacade;
    private ProcessorDAO processorDAO;
    private ProcessGroupDAO processGroupDAO;
    private RemoteProcessGroupDAO remoteProcessGroupDAO;
    private LabelDAO labelDAO;
    private FunnelDAO funnelDAO;
    private SnippetDAO snippetDAO;
    private PortDAO inputPortDAO;
    private PortDAO outputPortDAO;
    private ConnectionDAO connectionDAO;
    private ControllerServiceDAO controllerServiceDAO;
    private ReportingTaskDAO reportingTaskDAO;
    private FlowAnalysisRuleDAO flowAnalysisRuleDAO;
    private ParameterProviderDAO parameterProviderDAO;
    private FlowRegistryDAO flowRegistryDAO;
    private AccessPolicyDAO accessPolicyDAO;
    private ParameterContextDAO parameterContextDAO;

    public Authorizable getController() {
        return this.controllerFacade;
    }

    public ComponentAuthorizable getConfigurableComponent(String type, BundleDTO bundle) {
        ConfigurableComponent configurableComponent = this.controllerFacade.getTemporaryComponent(type, bundle);
        return this.getConfigurableComponent(configurableComponent);
    }

    public ComponentAuthorizable getConfigurableComponent(ConfigurableComponent configurableComponent) {
        try {
            return new ConfigurableComponentAuthorizable(configurableComponent, this.controllerFacade.getExtensionManager());
        }
        catch (Exception e) {
            throw new AccessDeniedException("Unable to create component to verify if it references any Controller Services.");
        }
    }

    public ComponentAuthorizable getProcessor(String id) {
        ProcessorNode processorNode = this.processorDAO.getProcessor(id);
        return new ProcessorComponentAuthorizable(processorNode, this.controllerFacade.getExtensionManager());
    }

    public PublicPortAuthorizable getPublicInputPort(String id) {
        Port inputPort = this.inputPortDAO.getPort(id);
        if (!(inputPort instanceof PublicPort)) {
            throw new IllegalArgumentException(String.format("The specified id '%s' does not represent an input port which can be accessed remotely.", id));
        }
        DataTransferAuthorizable baseAuthorizable = new DataTransferAuthorizable((Authorizable)inputPort);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public PublicPortAuthorizable getPublicOutputPort(String id) {
        Port outputPort = this.outputPortDAO.getPort(id);
        if (!(outputPort instanceof PublicPort)) {
            throw new IllegalArgumentException(String.format("The specified id '%s' does not represent an output port which can be accessed remotely.", id));
        }
        DataTransferAuthorizable baseAuthorizable = new DataTransferAuthorizable((Authorizable)outputPort);
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Authorizable getInputPort(String id) {
        return this.inputPortDAO.getPort(id);
    }

    public Authorizable getOutputPort(String id) {
        return this.outputPortDAO.getPort(id);
    }

    public ParameterContext getParameterContext(String id) {
        return this.parameterContextDAO.getParameterContext(id);
    }

    public ConnectionAuthorizable getConnection(String id) {
        Connection connection = this.connectionDAO.getConnection(id);
        return new StandardConnectionAuthorizable(connection);
    }

    public ProcessGroupAuthorizable getProcessGroup(String id) {
        ProcessGroup processGroup = this.processGroupDAO.getProcessGroup(id);
        return new StandardProcessGroupAuthorizable(processGroup, this.controllerFacade.getExtensionManager());
    }

    public Authorizable getRemoteProcessGroup(String id) {
        return this.remoteProcessGroupDAO.getRemoteProcessGroup(id);
    }

    public Authorizable getLabel(String id) {
        return this.labelDAO.getLabel(id);
    }

    public Authorizable getFunnel(String id) {
        return this.funnelDAO.getFunnel(id);
    }

    public ComponentAuthorizable getControllerService(String id) {
        ControllerServiceNode controllerService = this.controllerServiceDAO.getControllerService(id);
        return new ControllerServiceComponentAuthorizable(controllerService, this.controllerFacade.getExtensionManager());
    }

    public Authorizable getProvenance() {
        return PROVENANCE_AUTHORIZABLE;
    }

    public Authorizable getCounters() {
        return COUNTERS_AUTHORIZABLE;
    }

    public Authorizable getResource() {
        return RESOURCE_AUTHORIZABLE;
    }

    public Authorizable getSiteToSite() {
        return SITE_TO_SITE_AUTHORIZABLE;
    }

    public Authorizable getFlow() {
        return FLOW_AUTHORIZABLE;
    }

    private ComponentNode findControllerServiceReferencingComponent(ControllerServiceReference referencingComponents, String id) {
        ComponentNode reference = null;
        for (ComponentNode component : referencingComponents.getReferencingComponents()) {
            ControllerServiceNode refControllerService;
            if (component.getIdentifier().equals(id)) {
                reference = component;
                break;
            }
            if (!(component instanceof ControllerServiceNode) || (reference = this.findControllerServiceReferencingComponent((refControllerService = (ControllerServiceNode)component).getReferences(), id)) == null) continue;
            break;
        }
        return reference;
    }

    public Authorizable getControllerServiceReferencingComponent(String controllerServiceId, String id) {
        ControllerServiceNode controllerService = this.controllerServiceDAO.getControllerService(controllerServiceId);
        ControllerServiceReference referencingComponents = controllerService.getReferences();
        ComponentNode reference = this.findControllerServiceReferencingComponent(referencingComponents, id);
        if (reference == null) {
            throw new ResourceNotFoundException("Unable to find referencing component with id " + id);
        }
        return reference;
    }

    public ComponentAuthorizable getReportingTask(String id) {
        ReportingTaskNode reportingTaskNode = this.reportingTaskDAO.getReportingTask(id);
        return new ReportingTaskComponentAuthorizable(reportingTaskNode, this.controllerFacade.getExtensionManager());
    }

    public ComponentAuthorizable getFlowAnalysisRule(String id) {
        FlowAnalysisRuleNode flowAnalysisRuleNode = this.flowAnalysisRuleDAO.getFlowAnalysisRule(id);
        return new FlowAnalysisRuleComponentAuthorizable(flowAnalysisRuleNode, this.controllerFacade.getExtensionManager());
    }

    public ComponentAuthorizable getParameterProvider(String id) {
        ParameterProviderNode parameterProviderNode = this.parameterProviderDAO.getParameterProvider(id);
        return new ParameterProviderComponentAuthorizable(parameterProviderNode, this.controllerFacade.getExtensionManager());
    }

    public ComponentAuthorizable getFlowRegistryClient(String id) {
        FlowRegistryClientNode flowRegistryClientNode = this.flowRegistryDAO.getFlowRegistryClient(id);
        return new FlowRegistryClientComponentAuthorizable(flowRegistryClientNode, this.controllerFacade.getExtensionManager());
    }

    public SnippetAuthorizable getSnippet(String id) {
        Snippet snippet = this.snippetDAO.getSnippet(id);
        ProcessGroup processGroup = this.processGroupDAO.getProcessGroup(snippet.getParentGroupId());
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    public Authorizable getTenant() {
        return TENANT_AUTHORIZABLE;
    }

    public Authorizable getPolicies() {
        return POLICIES_AUTHORIZABLE;
    }

    public Authorizable getAccessPolicyById(String id) {
        AccessPolicy policy = this.accessPolicyDAO.getAccessPolicy(id);
        return this.getAccessPolicyByResource(policy.getResource());
    }

    public Authorizable getAccessPolicyByResource(String resource) {
        try {
            return new AccessPolicyAuthorizable(this.getAuthorizableFromResource(resource));
        }
        catch (ResourceNotFoundException e) {
            return POLICIES_AUTHORIZABLE;
        }
    }

    public Authorizable getAuthorizableFromResource(String resource) {
        ResourceType resourceType = ResourceType.fromRawValue((String)resource);
        if (resourceType == null) {
            throw new ResourceNotFoundException("Unrecognized resource: " + resource);
        }
        switch (16.$SwitchMap$org$apache$nifi$authorization$resource$ResourceType[resourceType.ordinal()]) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                String baseResource = StringUtils.substringAfter((String)resource, (String)resourceType.getValue());
                ResourceType baseResourceType = ResourceType.fromRawValue((String)baseResource);
                if (baseResourceType == null) {
                    throw new ResourceNotFoundException("Unrecognized base resource: " + resource);
                }
                switch (16.$SwitchMap$org$apache$nifi$authorization$resource$ResourceType[resourceType.ordinal()]) {
                    case 1: {
                        return new AccessPolicyAuthorizable(this.getAccessPolicy(baseResourceType, resource));
                    }
                    case 2: {
                        return new DataAuthorizable(this.getAccessPolicy(baseResourceType, resource));
                    }
                    case 3: {
                        return new DataTransferAuthorizable(this.getAccessPolicy(baseResourceType, resource));
                    }
                    case 4: {
                        return new ProvenanceDataAuthorizable(this.getAccessPolicy(baseResourceType, resource));
                    }
                    case 5: {
                        return new OperationAuthorizable(this.getAccessPolicy(baseResourceType, resource));
                    }
                }
            }
            case 6: {
                String slashRequiredPermission = StringUtils.substringAfter((String)resource, (String)resourceType.getValue());
                if (slashRequiredPermission.startsWith("/")) {
                    RequiredPermission requiredPermission = RequiredPermission.valueOfPermissionIdentifier((String)slashRequiredPermission.substring(1));
                    if (requiredPermission == null) {
                        throw new ResourceNotFoundException("Unrecognized resource: " + resource);
                    }
                    return this.getRestrictedComponents(requiredPermission);
                }
                return this.getRestrictedComponents();
            }
        }
        return this.getAccessPolicy(resourceType, resource);
    }

    private Authorizable getAccessPolicy(ResourceType resourceType, String resource) {
        String slashComponentId = StringUtils.substringAfter((String)resource, (String)resourceType.getValue());
        if (slashComponentId.startsWith("/")) {
            return this.getAccessPolicyByResource(resourceType, slashComponentId.substring(1));
        }
        return this.getAccessPolicyByResource(resourceType);
    }

    private Authorizable getAccessPolicyByResource(ResourceType resourceType, String componentId) {
        Authorizable authorizable = null;
        switch (16.$SwitchMap$org$apache$nifi$authorization$resource$ResourceType[resourceType.ordinal()]) {
            case 7: {
                authorizable = this.getControllerService(componentId).getAuthorizable();
                break;
            }
            case 8: {
                authorizable = this.getFunnel(componentId);
                break;
            }
            case 9: {
                authorizable = this.getInputPort(componentId);
                break;
            }
            case 10: {
                authorizable = this.getLabel(componentId);
                break;
            }
            case 11: {
                authorizable = this.getOutputPort(componentId);
                break;
            }
            case 12: {
                authorizable = this.getProcessor(componentId).getAuthorizable();
                break;
            }
            case 13: {
                authorizable = this.getProcessGroup(componentId).getAuthorizable();
                break;
            }
            case 14: {
                authorizable = this.getRemoteProcessGroup(componentId);
                break;
            }
            case 15: {
                authorizable = this.getReportingTask(componentId).getAuthorizable();
                break;
            }
            case 16: {
                authorizable = this.getFlowAnalysisRule(componentId).getAuthorizable();
                break;
            }
            case 17: {
                authorizable = this.getParameterContext(componentId);
                break;
            }
            case 18: {
                authorizable = this.getParameterProvider(componentId).getAuthorizable();
            }
        }
        if (authorizable == null) {
            throw new IllegalArgumentException("An unexpected type of resource in this policy " + resourceType.getValue());
        }
        return authorizable;
    }

    private Authorizable getAccessPolicyByResource(ResourceType resourceType) {
        Authorizable authorizable = null;
        switch (16.$SwitchMap$org$apache$nifi$authorization$resource$ResourceType[resourceType.ordinal()]) {
            case 19: {
                authorizable = this.getController();
                break;
            }
            case 20: {
                authorizable = this.getCounters();
                break;
            }
            case 21: {
                authorizable = new /* Unavailable Anonymous Inner Class!! */;
                break;
            }
            case 22: {
                authorizable = this.getProvenance();
                break;
            }
            case 23: {
                authorizable = new /* Unavailable Anonymous Inner Class!! */;
                break;
            }
            case 1: {
                authorizable = this.getPolicies();
                break;
            }
            case 24: {
                authorizable = new /* Unavailable Anonymous Inner Class!! */;
                break;
            }
            case 25: {
                authorizable = new /* Unavailable Anonymous Inner Class!! */;
                break;
            }
            case 26: {
                authorizable = this.getSystem();
                break;
            }
            case 27: {
                authorizable = this.getTenant();
                break;
            }
            case 17: {
                authorizable = this.getParameterContexts();
            }
        }
        if (authorizable == null) {
            throw new IllegalArgumentException("An unexpected type of resource in this policy " + resourceType.getValue());
        }
        return authorizable;
    }

    private void createTemporaryProcessorsAndControllerServices(FlowSnippetDTO snippet, Set<ComponentAuthorizable> processors, Set<ComponentAuthorizable> controllerServices, ExtensionManager extensionManager) {
        if (snippet == null) {
            return;
        }
        if (snippet.getProcessors() != null) {
            snippet.getProcessors().forEach(processor -> {
                try {
                    BundleCoordinate bundle = BundleUtils.getCompatibleBundle((ExtensionManager)extensionManager, (String)processor.getType(), (BundleDTO)processor.getBundle());
                    processors.add(this.getConfigurableComponent(processor.getType(), new BundleDTO(bundle.getGroup(), bundle.getId(), bundle.getVersion())));
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            });
        }
        if (snippet.getControllerServices() != null) {
            snippet.getControllerServices().forEach(controllerService -> {
                try {
                    BundleCoordinate bundle = BundleUtils.getCompatibleBundle((ExtensionManager)extensionManager, (String)controllerService.getType(), (BundleDTO)controllerService.getBundle());
                    controllerServices.add(this.getConfigurableComponent(controllerService.getType(), new BundleDTO(bundle.getGroup(), bundle.getId(), bundle.getVersion())));
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            });
        }
        if (snippet.getProcessGroups() != null) {
            snippet.getProcessGroups().forEach(group -> this.createTemporaryProcessorsAndControllerServices(group.getContents(), processors, controllerServices, extensionManager));
        }
    }

    public Authorizable getLocalConnectable(String id) {
        Connectable connectable = this.controllerFacade.findLocalConnectable(id);
        if (connectable == null) {
            throw new ResourceNotFoundException("Unable to find component with id " + id);
        }
        return connectable;
    }

    public Authorizable getRestrictedComponents() {
        return RestrictedComponentsAuthorizableFactory.getRestrictedComponentsAuthorizable();
    }

    public Authorizable getRestrictedComponents(RequiredPermission requiredPermission) {
        return RestrictedComponentsAuthorizableFactory.getRestrictedComponentsAuthorizable((RequiredPermission)requiredPermission);
    }

    public Authorizable getSystem() {
        return SYSTEM_AUTHORIZABLE;
    }

    public Authorizable getParameterContexts() {
        return new /* Unavailable Anonymous Inner Class!! */;
    }

    @Autowired
    public void setProcessorDAO(ProcessorDAO processorDAO) {
        this.processorDAO = processorDAO;
    }

    @Autowired
    public void setProcessGroupDAO(ProcessGroupDAO processGroupDAO) {
        this.processGroupDAO = processGroupDAO;
    }

    @Autowired
    public void setRemoteProcessGroupDAO(RemoteProcessGroupDAO remoteProcessGroupDAO) {
        this.remoteProcessGroupDAO = remoteProcessGroupDAO;
    }

    @Autowired
    public void setLabelDAO(LabelDAO labelDAO) {
        this.labelDAO = labelDAO;
    }

    @Autowired
    public void setFunnelDAO(FunnelDAO funnelDAO) {
        this.funnelDAO = funnelDAO;
    }

    @Autowired
    public void setSnippetDAO(SnippetDAO snippetDAO) {
        this.snippetDAO = snippetDAO;
    }

    @Qualifier(value="standardInputPortDAO")
    @Autowired
    public void setInputPortDAO(PortDAO inputPortDAO) {
        this.inputPortDAO = inputPortDAO;
    }

    @Qualifier(value="standardOutputPortDAO")
    @Autowired
    public void setOutputPortDAO(PortDAO outputPortDAO) {
        this.outputPortDAO = outputPortDAO;
    }

    @Autowired
    public void setConnectionDAO(ConnectionDAO connectionDAO) {
        this.connectionDAO = connectionDAO;
    }

    @Autowired
    public void setControllerServiceDAO(ControllerServiceDAO controllerServiceDAO) {
        this.controllerServiceDAO = controllerServiceDAO;
    }

    @Autowired
    public void setReportingTaskDAO(ReportingTaskDAO reportingTaskDAO) {
        this.reportingTaskDAO = reportingTaskDAO;
    }

    @Autowired
    public void setFlowAnalysisRuleDAO(FlowAnalysisRuleDAO flowAnalysisRuleDAO) {
        this.flowAnalysisRuleDAO = flowAnalysisRuleDAO;
    }

    @Autowired
    public void setParameterProviderDAO(ParameterProviderDAO parameterProviderDAO) {
        this.parameterProviderDAO = parameterProviderDAO;
    }

    @Autowired
    public void setFlowRegistryDAO(FlowRegistryDAO flowRegistryDAO) {
        this.flowRegistryDAO = flowRegistryDAO;
    }

    @Autowired
    public void setAccessPolicyDAO(AccessPolicyDAO accessPolicyDAO) {
        this.accessPolicyDAO = accessPolicyDAO;
    }

    @Autowired
    public void setParameterContextDAO(ParameterContextDAO parameterContextDAO) {
        this.parameterContextDAO = parameterContextDAO;
    }

    @Autowired
    public void setControllerFacade(ControllerFacade controllerFacade) {
        this.controllerFacade = controllerFacade;
    }
}

