/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.dao.impl;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.registry.flow.BucketLocation;
import org.apache.nifi.registry.flow.FlowLocation;
import org.apache.nifi.registry.flow.FlowRegistryBranch;
import org.apache.nifi.registry.flow.FlowRegistryBucket;
import org.apache.nifi.registry.flow.FlowRegistryClientNode;
import org.apache.nifi.registry.flow.FlowRegistryClientUserContext;
import org.apache.nifi.registry.flow.FlowRegistryException;
import org.apache.nifi.registry.flow.RegisteredFlow;
import org.apache.nifi.registry.flow.RegisteredFlowSnapshotMetadata;
import org.apache.nifi.util.BundleUtils;
import org.apache.nifi.web.NiFiCoreException;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.apache.nifi.web.api.dto.FlowRegistryClientDTO;
import org.apache.nifi.web.dao.FlowRegistryDAO;
import org.apache.nifi.web.dao.impl.ComponentDAO;

public class StandardFlowRegistryDAO
extends ComponentDAO
implements FlowRegistryDAO {
    private FlowController flowController;

    public FlowRegistryClientNode createFlowRegistryClient(FlowRegistryClientDTO flowRegistryClientDto) {
        if (flowRegistryClientDto.getType() == null) {
            throw new IllegalArgumentException("The flow registry client type must be specified.");
        }
        this.verifyCreate(this.flowController.getExtensionManager(), flowRegistryClientDto.getType(), flowRegistryClientDto.getBundle());
        BundleCoordinate bundleCoordinate = BundleUtils.getBundle((ExtensionManager)this.flowController.getExtensionManager(), (String)flowRegistryClientDto.getType(), (BundleDTO)flowRegistryClientDto.getBundle());
        FlowRegistryClientNode flowRegistryClient = this.flowController.getFlowManager().createFlowRegistryClient(flowRegistryClientDto.getType(), flowRegistryClientDto.getId(), bundleCoordinate, Collections.emptySet(), true, true, null);
        this.configureFlowRegistry(flowRegistryClient, flowRegistryClientDto);
        return flowRegistryClient;
    }

    public FlowRegistryClientNode updateFlowRegistryClient(FlowRegistryClientDTO flowRegistryClientDto) {
        FlowRegistryClientNode client = this.getFlowRegistryClient(flowRegistryClientDto.getId());
        this.verifyUpdate(client, flowRegistryClientDto);
        this.configureFlowRegistry(client, flowRegistryClientDto);
        return client;
    }

    private void verifyUpdate(FlowRegistryClientNode client, FlowRegistryClientDTO flowRegistryClientDto) {
        boolean duplicateName = this.getFlowRegistryClients().stream().anyMatch(reg -> reg.getName().equals(flowRegistryClientDto.getName()) && !reg.getIdentifier().equals(flowRegistryClientDto.getId()));
        if (duplicateName) {
            throw new IllegalStateException("Cannot update Flow Registry because a Flow Registry already exists with the name " + flowRegistryClientDto.getName());
        }
    }

    public FlowRegistryClientNode getFlowRegistryClient(String registryId) {
        FlowRegistryClientNode registry = this.flowController.getFlowManager().getFlowRegistryClient(registryId);
        if (registry == null) {
            throw new ResourceNotFoundException("Unable to find Flow Registry with id '" + registryId + "'");
        }
        return registry;
    }

    public Set<FlowRegistryClientNode> getFlowRegistryClients() {
        return this.flowController.getFlowManager().getAllFlowRegistryClients();
    }

    public Set<FlowRegistryClientNode> getFlowRegistryClientsForUser(FlowRegistryClientUserContext context) {
        return this.getFlowRegistryClients();
    }

    public Set<FlowRegistryBranch> getBranchesForUser(FlowRegistryClientUserContext context, String registryId) {
        try {
            FlowRegistryClientNode flowRegistry = this.flowController.getFlowManager().getFlowRegistryClient(registryId);
            if (flowRegistry == null) {
                throw new IllegalArgumentException("The specified registry id is unknown to this NiFi.");
            }
            Set branches = flowRegistry.getBranches(context);
            TreeSet<FlowRegistryBranch> sortedBranches = new TreeSet<FlowRegistryBranch>(Comparator.comparing(FlowRegistryBranch::getName));
            sortedBranches.addAll(branches);
            return sortedBranches;
        }
        catch (IOException | FlowRegistryException ioe) {
            throw new NiFiCoreException("Unable to get branches for registry with ID " + registryId + ": " + String.valueOf(ioe), ioe);
        }
    }

    public FlowRegistryBranch getDefaultBranchForUser(FlowRegistryClientUserContext context, String registryId) {
        try {
            FlowRegistryClientNode flowRegistry = this.flowController.getFlowManager().getFlowRegistryClient(registryId);
            if (flowRegistry == null) {
                throw new IllegalArgumentException("The specified registry id is unknown to this NiFi.");
            }
            return flowRegistry.getDefaultBranch(context);
        }
        catch (IOException | FlowRegistryException ioe) {
            throw new NiFiCoreException("Unable to get default branch for registry with ID " + registryId + ": " + String.valueOf(ioe), ioe);
        }
    }

    public Set<FlowRegistryBucket> getBucketsForUser(FlowRegistryClientUserContext context, String registryId, String branch) {
        try {
            FlowRegistryClientNode flowRegistry = this.flowController.getFlowManager().getFlowRegistryClient(registryId);
            if (flowRegistry == null) {
                throw new IllegalArgumentException("The specified registry id is unknown to this NiFi.");
            }
            Set buckets = flowRegistry.getBuckets(context, branch);
            TreeSet<FlowRegistryBucket> sortedBuckets = new TreeSet<FlowRegistryBucket>(Comparator.comparing(FlowRegistryBucket::getName));
            sortedBuckets.addAll(buckets);
            return sortedBuckets;
        }
        catch (FlowRegistryException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        catch (IOException ioe) {
            throw new NiFiCoreException("Unable to obtain listing of buckets: " + String.valueOf(ioe), (Throwable)ioe);
        }
    }

    public Set<RegisteredFlow> getFlowsForUser(FlowRegistryClientUserContext context, String registryId, String branch, String bucketId) {
        try {
            FlowRegistryClientNode flowRegistry = this.flowController.getFlowManager().getFlowRegistryClient(registryId);
            if (flowRegistry == null) {
                throw new IllegalArgumentException("The specified registry id is unknown to this NiFi.");
            }
            BucketLocation bucketLocation = new BucketLocation(branch, bucketId);
            Set flows = flowRegistry.getFlows(context, bucketLocation);
            TreeSet<RegisteredFlow> sortedFlows = new TreeSet<RegisteredFlow>(Comparator.comparing(RegisteredFlow::getName));
            sortedFlows.addAll(flows);
            return sortedFlows;
        }
        catch (IOException | FlowRegistryException ioe) {
            throw new NiFiCoreException("Unable to obtain listing of flows for bucket with ID " + bucketId + ": " + String.valueOf(ioe), ioe);
        }
    }

    public RegisteredFlow getFlowForUser(FlowRegistryClientUserContext context, String registryId, String branch, String bucketId, String flowId) {
        try {
            FlowRegistryClientNode flowRegistry = this.flowController.getFlowManager().getFlowRegistryClient(registryId);
            if (flowRegistry == null) {
                throw new IllegalArgumentException("The specified registry id is unknown to this NiFi.");
            }
            FlowLocation flowLocation = new FlowLocation(branch, bucketId, flowId);
            return flowRegistry.getFlow(context, flowLocation);
        }
        catch (IOException | FlowRegistryException ioe) {
            throw new NiFiCoreException("Unable to obtain listing of flows for bucket with ID " + bucketId + ": " + String.valueOf(ioe), ioe);
        }
    }

    public Set<RegisteredFlowSnapshotMetadata> getFlowVersionsForUser(FlowRegistryClientUserContext context, String registryId, String branch, String bucketId, String flowId) {
        try {
            FlowRegistryClientNode flowRegistry = this.flowController.getFlowManager().getFlowRegistryClient(registryId);
            if (flowRegistry == null) {
                throw new IllegalArgumentException("The specified registry id is unknown to this NiFi.");
            }
            FlowLocation flowLocation = new FlowLocation(branch, bucketId, flowId);
            Set flowVersions = flowRegistry.getFlowVersions(context, flowLocation);
            TreeSet<RegisteredFlowSnapshotMetadata> sortedFlowVersions = new TreeSet<RegisteredFlowSnapshotMetadata>(Comparator.comparingLong(RegisteredFlowSnapshotMetadata::getTimestamp).thenComparing(RegisteredFlowSnapshotMetadata::getVersion));
            sortedFlowVersions.addAll(flowVersions);
            return sortedFlowVersions;
        }
        catch (IOException | FlowRegistryException ioe) {
            throw new NiFiCoreException("Unable to obtain listing of versions for bucket with ID " + bucketId + " and flow with ID " + flowId + ": " + String.valueOf(ioe), ioe);
        }
    }

    public FlowRegistryClientNode removeFlowRegistry(String registryId) {
        FlowRegistryClientNode flowRegistry = this.flowController.getFlowManager().getFlowRegistryClient(registryId);
        if (flowRegistry == null) {
            throw new IllegalArgumentException("The specified registry id is unknown to this NiFi.");
        }
        this.flowController.getFlowManager().removeFlowRegistryClient(flowRegistry);
        return flowRegistry;
    }

    public void setFlowController(FlowController flowController) {
        this.flowController = flowController;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureFlowRegistry(FlowRegistryClientNode node, FlowRegistryClientDTO dto) {
        String name = dto.getName();
        String description = dto.getDescription();
        Map properties = dto.getProperties();
        node.pauseValidationTrigger();
        try {
            if (this.isNotNull((Object)name)) {
                node.setName(name);
            }
            if (this.isNotNull((Object)description)) {
                node.setDescription(description);
            }
            if (this.isNotNull((Object)properties)) {
                Set sensitiveDynamicPropertyNames = Optional.ofNullable(dto.getSensitiveDynamicPropertyNames()).orElse(Collections.emptySet());
                node.setProperties(properties, false, sensitiveDynamicPropertyNames);
            }
        }
        finally {
            node.resumeValidationTrigger();
        }
    }
}

