/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.dto;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.nifi.web.api.dto.AccessPolicyDTO;
import org.apache.nifi.web.api.dto.AccessPolicySummaryDTO;
import org.apache.nifi.web.api.dto.AffectedComponentDTO;
import org.apache.nifi.web.api.dto.AllowableValueDTO;
import org.apache.nifi.web.api.dto.BulletinDTO;
import org.apache.nifi.web.api.dto.ComponentReferenceDTO;
import org.apache.nifi.web.api.dto.ComponentValidationResultDTO;
import org.apache.nifi.web.api.dto.ConnectionDTO;
import org.apache.nifi.web.api.dto.ControllerConfigurationDTO;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.api.dto.ControllerServiceReferencingComponentDTO;
import org.apache.nifi.web.api.dto.DimensionsDTO;
import org.apache.nifi.web.api.dto.FlowAnalysisRuleDTO;
import org.apache.nifi.web.api.dto.FlowRegistryBranchDTO;
import org.apache.nifi.web.api.dto.FlowRegistryBucketDTO;
import org.apache.nifi.web.api.dto.FlowRegistryClientDTO;
import org.apache.nifi.web.api.dto.FunnelDTO;
import org.apache.nifi.web.api.dto.LabelDTO;
import org.apache.nifi.web.api.dto.ParameterContextDTO;
import org.apache.nifi.web.api.dto.ParameterContextReferenceDTO;
import org.apache.nifi.web.api.dto.ParameterProviderDTO;
import org.apache.nifi.web.api.dto.ParameterProviderReferencingComponentDTO;
import org.apache.nifi.web.api.dto.PermissionsDTO;
import org.apache.nifi.web.api.dto.PortDTO;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.api.dto.ProcessGroupNameDTO;
import org.apache.nifi.web.api.dto.ProcessorDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupDTO;
import org.apache.nifi.web.api.dto.RemoteProcessGroupPortDTO;
import org.apache.nifi.web.api.dto.ReportingTaskDTO;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.dto.SnippetDTO;
import org.apache.nifi.web.api.dto.TenantDTO;
import org.apache.nifi.web.api.dto.UserDTO;
import org.apache.nifi.web.api.dto.UserGroupDTO;
import org.apache.nifi.web.api.dto.VersionControlInformationDTO;
import org.apache.nifi.web.api.dto.action.ActionDTO;
import org.apache.nifi.web.api.dto.diagnostics.ProcessorDiagnosticsDTO;
import org.apache.nifi.web.api.dto.flow.FlowBreadcrumbDTO;
import org.apache.nifi.web.api.dto.flow.ProcessGroupFlowDTO;
import org.apache.nifi.web.api.dto.status.ConnectionStatisticsDTO;
import org.apache.nifi.web.api.dto.status.ConnectionStatisticsSnapshotDTO;
import org.apache.nifi.web.api.dto.status.ConnectionStatusDTO;
import org.apache.nifi.web.api.dto.status.ConnectionStatusSnapshotDTO;
import org.apache.nifi.web.api.dto.status.ControllerServiceStatusDTO;
import org.apache.nifi.web.api.dto.status.FlowAnalysisRuleStatusDTO;
import org.apache.nifi.web.api.dto.status.PortStatusDTO;
import org.apache.nifi.web.api.dto.status.PortStatusSnapshotDTO;
import org.apache.nifi.web.api.dto.status.ProcessGroupStatusDTO;
import org.apache.nifi.web.api.dto.status.ProcessGroupStatusSnapshotDTO;
import org.apache.nifi.web.api.dto.status.ProcessorStatusDTO;
import org.apache.nifi.web.api.dto.status.ProcessorStatusSnapshotDTO;
import org.apache.nifi.web.api.dto.status.RemoteProcessGroupStatusDTO;
import org.apache.nifi.web.api.dto.status.RemoteProcessGroupStatusSnapshotDTO;
import org.apache.nifi.web.api.dto.status.ReportingTaskStatusDTO;
import org.apache.nifi.web.api.dto.status.StatusHistoryDTO;
import org.apache.nifi.web.api.entity.AccessPolicyEntity;
import org.apache.nifi.web.api.entity.AccessPolicySummaryEntity;
import org.apache.nifi.web.api.entity.ActionEntity;
import org.apache.nifi.web.api.entity.AffectedComponentEntity;
import org.apache.nifi.web.api.entity.AllowableValueEntity;
import org.apache.nifi.web.api.entity.BulletinEntity;
import org.apache.nifi.web.api.entity.ComponentReferenceEntity;
import org.apache.nifi.web.api.entity.ComponentValidationResultEntity;
import org.apache.nifi.web.api.entity.ConnectionEntity;
import org.apache.nifi.web.api.entity.ConnectionStatisticsEntity;
import org.apache.nifi.web.api.entity.ConnectionStatisticsSnapshotEntity;
import org.apache.nifi.web.api.entity.ConnectionStatusEntity;
import org.apache.nifi.web.api.entity.ConnectionStatusSnapshotEntity;
import org.apache.nifi.web.api.entity.ControllerConfigurationEntity;
import org.apache.nifi.web.api.entity.ControllerServiceEntity;
import org.apache.nifi.web.api.entity.ControllerServiceReferencingComponentEntity;
import org.apache.nifi.web.api.entity.FlowAnalysisRuleEntity;
import org.apache.nifi.web.api.entity.FlowBreadcrumbEntity;
import org.apache.nifi.web.api.entity.FlowRegistryBranchEntity;
import org.apache.nifi.web.api.entity.FlowRegistryBucketEntity;
import org.apache.nifi.web.api.entity.FlowRegistryClientEntity;
import org.apache.nifi.web.api.entity.FunnelEntity;
import org.apache.nifi.web.api.entity.LabelEntity;
import org.apache.nifi.web.api.entity.ParameterContextEntity;
import org.apache.nifi.web.api.entity.ParameterContextReferenceEntity;
import org.apache.nifi.web.api.entity.ParameterProviderEntity;
import org.apache.nifi.web.api.entity.ParameterProviderReferencingComponentEntity;
import org.apache.nifi.web.api.entity.PortEntity;
import org.apache.nifi.web.api.entity.PortStatusEntity;
import org.apache.nifi.web.api.entity.PortStatusSnapshotEntity;
import org.apache.nifi.web.api.entity.ProcessGroupEntity;
import org.apache.nifi.web.api.entity.ProcessGroupFlowEntity;
import org.apache.nifi.web.api.entity.ProcessGroupStatusEntity;
import org.apache.nifi.web.api.entity.ProcessGroupStatusSnapshotEntity;
import org.apache.nifi.web.api.entity.ProcessorDiagnosticsEntity;
import org.apache.nifi.web.api.entity.ProcessorEntity;
import org.apache.nifi.web.api.entity.ProcessorStatusEntity;
import org.apache.nifi.web.api.entity.ProcessorStatusSnapshotEntity;
import org.apache.nifi.web.api.entity.RemoteProcessGroupEntity;
import org.apache.nifi.web.api.entity.RemoteProcessGroupPortEntity;
import org.apache.nifi.web.api.entity.RemoteProcessGroupStatusEntity;
import org.apache.nifi.web.api.entity.RemoteProcessGroupStatusSnapshotEntity;
import org.apache.nifi.web.api.entity.ReportingTaskEntity;
import org.apache.nifi.web.api.entity.SnippetEntity;
import org.apache.nifi.web.api.entity.StatusHistoryEntity;
import org.apache.nifi.web.api.entity.TenantEntity;
import org.apache.nifi.web.api.entity.UserEntity;
import org.apache.nifi.web.api.entity.UserGroupEntity;
import org.apache.nifi.web.api.entity.VersionControlInformationEntity;

public final class EntityFactory {
    public ProcessorDiagnosticsEntity createProcessorDiagnosticsEntity(ProcessorDiagnosticsDTO dto, RevisionDTO revision, PermissionsDTO processorPermissions, ProcessorStatusDTO status, List<BulletinEntity> bulletins) {
        ProcessorDiagnosticsEntity entity = new ProcessorDiagnosticsEntity();
        entity.setRevision(revision);
        if (dto != null) {
            entity.setPermissions(processorPermissions);
            entity.setId(dto.getProcessor().getId());
            if (processorPermissions != null && processorPermissions.getCanRead().booleanValue()) {
                entity.setComponent(dto);
                entity.setBulletins(bulletins);
            }
        }
        entity.setBulletins(bulletins);
        return entity;
    }

    public StatusHistoryEntity createStatusHistoryEntity(StatusHistoryDTO statusHistory, PermissionsDTO permissions) {
        StatusHistoryEntity entity = new StatusHistoryEntity();
        entity.setCanRead(permissions.getCanRead());
        entity.setStatusHistory(statusHistory);
        return entity;
    }

    public ProcessorStatusEntity createProcessorStatusEntity(ProcessorStatusDTO status, PermissionsDTO permissions) {
        ProcessorStatusEntity entity = new ProcessorStatusEntity();
        entity.setCanRead(permissions.getCanRead());
        entity.setProcessorStatus(status);
        return entity;
    }

    public ProcessorStatusSnapshotEntity createProcessorStatusSnapshotEntity(ProcessorStatusSnapshotDTO status, PermissionsDTO permissions) {
        ProcessorStatusSnapshotEntity entity = new ProcessorStatusSnapshotEntity();
        entity.setId(status.getId());
        entity.setCanRead(permissions.getCanRead());
        entity.setProcessorStatusSnapshot(status);
        return entity;
    }

    public ConnectionStatusEntity createConnectionStatusEntity(ConnectionStatusDTO status, PermissionsDTO permissions) {
        ConnectionStatusEntity entity = new ConnectionStatusEntity();
        entity.setCanRead(permissions.getCanRead());
        entity.setConnectionStatus(status);
        return entity;
    }

    public ConnectionStatusSnapshotEntity createConnectionStatusSnapshotEntity(ConnectionStatusSnapshotDTO status, PermissionsDTO permissions) {
        ConnectionStatusSnapshotEntity entity = new ConnectionStatusSnapshotEntity();
        entity.setId(status.getId());
        entity.setCanRead(permissions.getCanRead());
        entity.setConnectionStatusSnapshot(status);
        return entity;
    }

    public ConnectionStatisticsEntity createConnectionStatisticsEntity(ConnectionStatisticsDTO statistics, PermissionsDTO permissions) {
        ConnectionStatisticsEntity entity = new ConnectionStatisticsEntity();
        entity.setCanRead(permissions.getCanRead());
        entity.setConnectionStatistics(statistics);
        return entity;
    }

    public ConnectionStatisticsSnapshotEntity createConnectionStatisticsSnapshotEntity(ConnectionStatisticsSnapshotDTO statistics, PermissionsDTO permissions) {
        ConnectionStatisticsSnapshotEntity entity = new ConnectionStatisticsSnapshotEntity();
        entity.setId(statistics.getId());
        entity.setCanRead(permissions.getCanRead());
        entity.setConnectionStatisticsSnapshot(statistics);
        return entity;
    }

    public ProcessGroupStatusEntity createProcessGroupStatusEntity(ProcessGroupStatusDTO status, PermissionsDTO permissions) {
        ProcessGroupStatusEntity entity = new ProcessGroupStatusEntity();
        entity.setCanRead(permissions.getCanRead());
        entity.setProcessGroupStatus(status);
        return entity;
    }

    public ProcessGroupStatusSnapshotEntity createProcessGroupStatusSnapshotEntity(ProcessGroupStatusSnapshotDTO status, PermissionsDTO permissions) {
        ProcessGroupStatusSnapshotEntity entity = new ProcessGroupStatusSnapshotEntity();
        entity.setId(status.getId());
        entity.setCanRead(permissions.getCanRead());
        entity.setProcessGroupStatusSnapshot(status);
        return entity;
    }

    public RemoteProcessGroupStatusEntity createRemoteProcessGroupStatusEntity(RemoteProcessGroupStatusDTO status, PermissionsDTO permissions) {
        RemoteProcessGroupStatusEntity entity = new RemoteProcessGroupStatusEntity();
        entity.setCanRead(permissions.getCanRead());
        entity.setRemoteProcessGroupStatus(status);
        return entity;
    }

    public RemoteProcessGroupStatusSnapshotEntity createRemoteProcessGroupStatusSnapshotEntity(RemoteProcessGroupStatusSnapshotDTO status, PermissionsDTO permissions) {
        RemoteProcessGroupStatusSnapshotEntity entity = new RemoteProcessGroupStatusSnapshotEntity();
        entity.setId(status.getId());
        entity.setCanRead(permissions.getCanRead());
        entity.setRemoteProcessGroupStatusSnapshot(status);
        return entity;
    }

    public PortStatusEntity createPortStatusEntity(PortStatusDTO status, PermissionsDTO permissions) {
        PortStatusEntity entity = new PortStatusEntity();
        entity.setCanRead(permissions.getCanRead());
        entity.setPortStatus(status);
        return entity;
    }

    public PortStatusSnapshotEntity createPortStatusSnapshotEntity(PortStatusSnapshotDTO status, PermissionsDTO permissions) {
        PortStatusSnapshotEntity entity = new PortStatusSnapshotEntity();
        entity.setId(status.getId());
        entity.setCanRead(permissions.getCanRead());
        entity.setPortStatusSnapshot(status);
        return entity;
    }

    public ControllerConfigurationEntity createControllerConfigurationEntity(ControllerConfigurationDTO dto, RevisionDTO revision, PermissionsDTO permissions) {
        ControllerConfigurationEntity entity = new ControllerConfigurationEntity();
        entity.setRevision(revision);
        if (dto != null) {
            entity.setPermissions(permissions);
            if (permissions != null && permissions.getCanRead().booleanValue()) {
                entity.setComponent(dto);
            }
        }
        return entity;
    }

    public ProcessGroupFlowEntity createProcessGroupFlowEntity(ProcessGroupFlowDTO dto, PermissionsDTO permissions) {
        ProcessGroupFlowEntity entity = new ProcessGroupFlowEntity();
        entity.setProcessGroupFlow(dto);
        entity.setPermissions(permissions);
        return entity;
    }

    public ProcessorEntity createProcessorEntity(ProcessorDTO dto, RevisionDTO revision, PermissionsDTO permissions, PermissionsDTO operatePermissions, ProcessorStatusDTO status, List<BulletinEntity> bulletins) {
        ProcessorEntity entity = new ProcessorEntity();
        entity.setRevision(revision);
        if (dto != null) {
            entity.setPermissions(permissions);
            entity.setOperatePermissions(operatePermissions);
            entity.setStatus(status);
            entity.setId(dto.getId());
            entity.setInputRequirement(dto.getInputRequirement());
            entity.setPosition(dto.getPosition());
            if (permissions != null && permissions.getCanRead().booleanValue()) {
                entity.setComponent(dto);
                entity.setBulletins(bulletins);
            }
        }
        return entity;
    }

    public PortEntity createPortEntity(PortDTO dto, RevisionDTO revision, PermissionsDTO permissions, PermissionsDTO operatePermissions, PortStatusDTO status, List<BulletinEntity> bulletins) {
        PortEntity entity = new PortEntity();
        entity.setRevision(revision);
        if (dto != null) {
            entity.setPermissions(permissions);
            entity.setOperatePermissions(operatePermissions);
            entity.setStatus(status);
            entity.setId(dto.getId());
            entity.setPosition(dto.getPosition());
            entity.setPortType(dto.getType());
            entity.setAllowRemoteAccess(dto.getAllowRemoteAccess());
            if (permissions != null && permissions.getCanRead().booleanValue()) {
                entity.setComponent(dto);
                entity.setBulletins(bulletins);
            }
        }
        return entity;
    }

    public ProcessGroupEntity createProcessGroupEntity(ProcessGroupDTO dto, RevisionDTO revision, PermissionsDTO permissions, ProcessGroupStatusDTO status, List<BulletinEntity> bulletins) {
        ProcessGroupEntity entity = new ProcessGroupEntity();
        entity.setRevision(revision);
        if (dto != null) {
            entity.setPermissions(permissions);
            entity.setStatus(status);
            entity.setId(dto.getId());
            entity.setPosition(dto.getPosition());
            entity.setLocalInputPortCount(dto.getLocalInputPortCount());
            entity.setLocalOutputPortCount(dto.getLocalOutputPortCount());
            entity.setPublicInputPortCount(dto.getPublicInputPortCount());
            entity.setPublicOutputPortCount(dto.getPublicOutputPortCount());
            entity.setRunningCount(dto.getRunningCount());
            entity.setStoppedCount(dto.getStoppedCount());
            entity.setInvalidCount(dto.getInvalidCount());
            entity.setDisabledCount(dto.getDisabledCount());
            entity.setActiveRemotePortCount(dto.getActiveRemotePortCount());
            entity.setInactiveRemotePortCount(dto.getInactiveRemotePortCount());
            entity.setUpToDateCount(dto.getUpToDateCount());
            entity.setLocallyModifiedCount(dto.getLocallyModifiedCount());
            entity.setStaleCount(dto.getStaleCount());
            entity.setLocallyModifiedAndStaleCount(dto.getLocallyModifiedAndStaleCount());
            entity.setSyncFailureCount(dto.getSyncFailureCount());
            ParameterContextReferenceEntity parameterContextReference = dto.getParameterContext();
            if (parameterContextReference != null) {
                entity.setParameterContext(parameterContextReference);
            }
            if (dto.getVersionControlInformation() != null) {
                entity.setVersionedFlowState(dto.getVersionControlInformation().getState());
            }
            entity.setBulletins(bulletins);
            if (permissions != null && permissions.getCanRead().booleanValue()) {
                entity.setComponent(dto);
            }
        }
        return entity;
    }

    public LabelEntity createLabelEntity(LabelDTO dto, RevisionDTO revision, PermissionsDTO permissions) {
        LabelEntity entity = new LabelEntity();
        entity.setRevision(revision);
        if (dto != null) {
            entity.setPermissions(permissions);
            entity.setId(dto.getId());
            entity.setPosition(dto.getPosition());
            DimensionsDTO dimensions = new DimensionsDTO();
            dimensions.setHeight(dto.getHeight());
            dimensions.setWidth(dto.getWidth());
            entity.setDimensions(dimensions);
            entity.setzIndex(dto.getzIndex());
            if (permissions != null && permissions.getCanRead().booleanValue()) {
                entity.setComponent(dto);
            }
        }
        return entity;
    }

    public UserEntity createUserEntity(UserDTO dto, RevisionDTO revision, PermissionsDTO permissions) {
        UserEntity entity = new UserEntity();
        entity.setRevision(revision);
        if (dto != null) {
            entity.setPermissions(permissions);
            entity.setId(dto.getId());
            if (permissions != null && permissions.getCanRead().booleanValue()) {
                entity.setComponent(dto);
            }
        }
        return entity;
    }

    public TenantEntity createTenantEntity(TenantDTO dto, RevisionDTO revision, PermissionsDTO permissions) {
        TenantEntity entity = new TenantEntity();
        entity.setRevision(revision);
        if (dto != null) {
            entity.setPermissions(permissions);
            entity.setId(dto.getId());
            if (permissions != null && permissions.getCanRead().booleanValue()) {
                entity.setComponent(dto);
            }
        }
        return entity;
    }

    public AccessPolicySummaryEntity createAccessPolicySummaryEntity(AccessPolicySummaryDTO dto, RevisionDTO revision, PermissionsDTO permissions) {
        AccessPolicySummaryEntity entity = new AccessPolicySummaryEntity();
        entity.setRevision(revision);
        if (dto != null) {
            entity.setPermissions(permissions);
            entity.setId(dto.getId());
            if (permissions != null && permissions.getCanRead().booleanValue()) {
                entity.setComponent(dto);
            }
        }
        return entity;
    }

    public ComponentReferenceEntity createComponentReferenceEntity(ComponentReferenceDTO dto, RevisionDTO revision, PermissionsDTO permissions) {
        ComponentReferenceEntity entity = new ComponentReferenceEntity();
        entity.setRevision(revision);
        if (dto != null) {
            entity.setPermissions(permissions);
            entity.setId(dto.getId());
            entity.setParentGroupId(dto.getParentGroupId());
            if (permissions != null && permissions.getCanRead().booleanValue()) {
                entity.setComponent(dto);
            }
        }
        return entity;
    }

    public AffectedComponentEntity createAffectedComponentEntity(AffectedComponentDTO dto, RevisionDTO revision, PermissionsDTO permissions, ProcessGroupNameDTO processGroupNameDto, List<BulletinDTO> bulletins) {
        AffectedComponentEntity entity = new AffectedComponentEntity();
        entity.setRevision(revision);
        if (dto != null) {
            entity.setPermissions(permissions);
            entity.setId(dto.getId());
            entity.setReferenceType(dto.getReferenceType());
            if (permissions != null && permissions.getCanRead().booleanValue()) {
                entity.setComponent(dto);
            }
        }
        if (Boolean.TRUE == permissions.getCanRead()) {
            List bulletinEntities = bulletins.stream().map(bulletin -> this.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
            entity.setBulletins(bulletinEntities);
        } else {
            entity.setBulletins(null);
        }
        entity.setProcessGroup(processGroupNameDto);
        return entity;
    }

    public ComponentValidationResultEntity createComponentValidationResultEntity(ComponentValidationResultDTO dto, RevisionDTO revision, PermissionsDTO permissions) {
        ComponentValidationResultEntity entity = new ComponentValidationResultEntity();
        entity.setRevision(revision);
        if (dto != null) {
            entity.setPermissions(permissions);
            entity.setId(dto.getId());
            if (permissions != null && permissions.getCanRead().booleanValue()) {
                entity.setComponent(dto);
            }
        }
        return entity;
    }

    public UserGroupEntity createUserGroupEntity(UserGroupDTO dto, RevisionDTO revision, PermissionsDTO permissions) {
        UserGroupEntity entity = new UserGroupEntity();
        entity.setRevision(revision);
        if (dto != null) {
            entity.setPermissions(permissions);
            entity.setId(dto.getId());
            if (permissions != null && permissions.getCanRead().booleanValue()) {
                entity.setComponent(dto);
            }
        }
        return entity;
    }

    public AccessPolicyEntity createAccessPolicyEntity(AccessPolicyDTO dto, RevisionDTO revision, PermissionsDTO permissions) {
        AccessPolicyEntity entity = new AccessPolicyEntity();
        entity.setRevision(revision);
        entity.setGenerated(new Date());
        if (dto != null) {
            entity.setPermissions(permissions);
            entity.setId(dto.getId());
            if (permissions != null && permissions.getCanRead().booleanValue()) {
                entity.setComponent(dto);
            }
        }
        return entity;
    }

    public ParameterContextReferenceEntity createParameterReferenceEntity(ParameterContextReferenceDTO dto, PermissionsDTO permissions) {
        ParameterContextReferenceEntity entity = new ParameterContextReferenceEntity();
        if (dto != null) {
            entity.setPermissions(permissions);
            entity.setId(dto.getId());
            if (permissions != null && permissions.getCanRead().booleanValue()) {
                entity.setComponent(dto);
            }
        }
        return entity;
    }

    public FunnelEntity createFunnelEntity(FunnelDTO dto, RevisionDTO revision, PermissionsDTO permissions) {
        FunnelEntity entity = new FunnelEntity();
        entity.setRevision(revision);
        if (dto != null) {
            entity.setPermissions(permissions);
            entity.setId(dto.getId());
            entity.setPosition(dto.getPosition());
            if (permissions != null && permissions.getCanRead().booleanValue()) {
                entity.setComponent(dto);
            }
        }
        return entity;
    }

    public ConnectionEntity createConnectionEntity(ConnectionDTO dto, RevisionDTO revision, PermissionsDTO permissions, ConnectionStatusDTO status) {
        ConnectionEntity entity = new ConnectionEntity();
        entity.setRevision(revision);
        if (dto != null) {
            entity.setPermissions(permissions);
            entity.setStatus(status);
            entity.setId(dto.getId());
            entity.setPosition(dto.getPosition());
            entity.setBends(dto.getBends());
            entity.setLabelIndex(dto.getLabelIndex());
            entity.setzIndex(dto.getzIndex());
            entity.setSourceId(dto.getSource().getId());
            entity.setSourceGroupId(dto.getSource().getGroupId());
            entity.setSourceType(dto.getSource().getType());
            entity.setDestinationId(dto.getDestination().getId());
            entity.setDestinationGroupId(dto.getDestination().getGroupId());
            entity.setDestinationType(dto.getDestination().getType());
            if (permissions != null && permissions.getCanRead().booleanValue()) {
                entity.setComponent(dto);
            }
        }
        return entity;
    }

    public RemoteProcessGroupEntity createRemoteProcessGroupEntity(RemoteProcessGroupDTO dto, RevisionDTO revision, PermissionsDTO permissions, PermissionsDTO operatePermissions, RemoteProcessGroupStatusDTO status, List<BulletinEntity> bulletins) {
        RemoteProcessGroupEntity entity = new RemoteProcessGroupEntity();
        entity.setRevision(revision);
        if (dto != null) {
            entity.setPermissions(permissions);
            entity.setOperatePermissions(operatePermissions);
            entity.setStatus(status);
            entity.setId(dto.getId());
            entity.setPosition(dto.getPosition());
            entity.setInputPortCount(dto.getInputPortCount());
            entity.setOutputPortCount(dto.getOutputPortCount());
            if (permissions != null && permissions.getCanRead().booleanValue()) {
                entity.setComponent(dto);
                entity.setBulletins(bulletins);
            }
        }
        return entity;
    }

    public RemoteProcessGroupPortEntity createRemoteProcessGroupPortEntity(RemoteProcessGroupPortDTO dto, RevisionDTO revision, PermissionsDTO permissions, PermissionsDTO operatePermissions) {
        RemoteProcessGroupPortEntity entity = new RemoteProcessGroupPortEntity();
        entity.setRevision(revision);
        if (dto != null) {
            entity.setPermissions(permissions);
            entity.setOperatePermissions(operatePermissions);
            entity.setId(dto.getId());
            if (permissions != null && permissions.getCanRead().booleanValue()) {
                entity.setRemoteProcessGroupPort(dto);
            }
        }
        return entity;
    }

    public SnippetEntity createSnippetEntity(SnippetDTO dto) {
        SnippetEntity entity = new SnippetEntity();
        entity.setSnippet(dto);
        return entity;
    }

    public ReportingTaskEntity createReportingTaskEntity(ReportingTaskDTO dto, RevisionDTO revision, PermissionsDTO permissions, PermissionsDTO operatePermissions, List<BulletinEntity> bulletins) {
        ReportingTaskEntity entity = new ReportingTaskEntity();
        entity.setRevision(revision);
        if (dto != null) {
            entity.setPermissions(permissions);
            entity.setOperatePermissions(operatePermissions);
            entity.setId(dto.getId());
            ReportingTaskStatusDTO status = new ReportingTaskStatusDTO();
            status.setRunStatus(dto.getState());
            status.setValidationStatus(dto.getValidationStatus());
            status.setActiveThreadCount(dto.getActiveThreadCount());
            entity.setStatus(status);
            if (permissions != null && permissions.getCanRead().booleanValue()) {
                entity.setComponent(dto);
                entity.setBulletins(bulletins);
            }
        }
        return entity;
    }

    public FlowAnalysisRuleEntity createFlowAnalysisRuleEntity(FlowAnalysisRuleDTO flowAnalysisRuleDTO, RevisionDTO revision, PermissionsDTO permissions, PermissionsDTO operatePermissions, List<BulletinEntity> bulletins) {
        FlowAnalysisRuleEntity entity = new FlowAnalysisRuleEntity();
        entity.setRevision(revision);
        if (flowAnalysisRuleDTO != null) {
            entity.setPermissions(permissions);
            entity.setOperatePermissions(operatePermissions);
            entity.setId(flowAnalysisRuleDTO.getId());
            FlowAnalysisRuleStatusDTO status = new FlowAnalysisRuleStatusDTO();
            status.setRunStatus(flowAnalysisRuleDTO.getState());
            status.setValidationStatus(flowAnalysisRuleDTO.getValidationStatus());
            entity.setStatus(status);
            if (permissions != null && permissions.getCanRead().booleanValue()) {
                entity.setBulletins(bulletins);
                entity.setComponent(flowAnalysisRuleDTO);
            }
        }
        return entity;
    }

    public ParameterProviderReferencingComponentEntity createParameterProviderReferencingComponentEntity(String id, ParameterProviderReferencingComponentDTO dto, RevisionDTO revision, PermissionsDTO permissions, List<BulletinDTO> bulletins) {
        ParameterProviderReferencingComponentEntity entity = new ParameterProviderReferencingComponentEntity();
        entity.setId(id);
        entity.setRevision(revision);
        if (dto != null) {
            entity.setPermissions(permissions);
            entity.setId(dto.getId());
            if (permissions != null && permissions.getCanRead().booleanValue()) {
                entity.setComponent(dto);
            }
        }
        if (permissions.getCanRead() == Boolean.TRUE) {
            List bulletinEntities = bulletins.stream().map(bulletin -> this.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
            entity.setBulletins(bulletinEntities);
        } else {
            entity.setBulletins(null);
        }
        return entity;
    }

    public ParameterProviderEntity createParameterProviderEntity(ParameterProviderDTO dto, RevisionDTO revision, PermissionsDTO permissions, List<BulletinEntity> bulletins) {
        ParameterProviderEntity entity = new ParameterProviderEntity();
        entity.setRevision(revision);
        if (dto != null) {
            entity.setPermissions(permissions);
            entity.setId(dto.getId());
            if (permissions != null && permissions.getCanRead().booleanValue()) {
                entity.setComponent(dto);
                entity.setBulletins(bulletins);
            }
        }
        return entity;
    }

    public FlowRegistryClientEntity createFlowRegistryClientEntity(FlowRegistryClientDTO dto, RevisionDTO revision, PermissionsDTO permissions, PermissionsDTO operatePermissions, List<BulletinEntity> bulletins) {
        FlowRegistryClientEntity entity = this.createFlowRegistryClientEntity(dto, revision, permissions);
        if (dto != null) {
            entity.setOperatePermissions(operatePermissions);
            if (permissions != null && permissions.getCanRead().booleanValue()) {
                entity.setBulletins(bulletins);
            }
        }
        return entity;
    }

    public FlowRegistryClientEntity createFlowRegistryClientEntity(FlowRegistryClientDTO dto, RevisionDTO revision, PermissionsDTO permissions) {
        FlowRegistryClientEntity entity = new FlowRegistryClientEntity();
        entity.setRevision(revision);
        entity.setPermissions(permissions);
        if (dto != null) {
            entity.setId(dto.getId());
            if (permissions != null && permissions.getCanRead().booleanValue()) {
                entity.setComponent(dto);
            }
        }
        return entity;
    }

    public ParameterContextEntity createParameterContextEntity(ParameterContextDTO dto, RevisionDTO revision, PermissionsDTO permissions) {
        ParameterContextEntity entity = new ParameterContextEntity();
        entity.setRevision(revision);
        if (dto != null) {
            entity.setPermissions(permissions);
            entity.setId(dto.getId());
            if (permissions != null && permissions.getCanRead().booleanValue()) {
                entity.setComponent(dto);
            }
        }
        return entity;
    }

    public ControllerServiceEntity createControllerServiceEntity(ControllerServiceDTO dto, RevisionDTO revision, PermissionsDTO permissions, PermissionsDTO operatePermissions, List<BulletinEntity> bulletins) {
        ControllerServiceEntity entity = new ControllerServiceEntity();
        entity.setRevision(revision);
        if (dto != null) {
            entity.setPermissions(permissions);
            entity.setOperatePermissions(operatePermissions);
            entity.setId(dto.getId());
            entity.setParentGroupId(dto.getParentGroupId());
            entity.setPosition(dto.getPosition());
            ControllerServiceStatusDTO status = new ControllerServiceStatusDTO();
            status.setRunStatus(dto.getState());
            status.setValidationStatus(dto.getValidationStatus());
            entity.setStatus(status);
            if (permissions != null && permissions.getCanRead().booleanValue()) {
                entity.setComponent(dto);
                entity.setBulletins(bulletins);
            }
        }
        return entity;
    }

    public ControllerServiceReferencingComponentEntity createControllerServiceReferencingComponentEntity(String id, ControllerServiceReferencingComponentDTO dto, RevisionDTO revision, PermissionsDTO permissions, PermissionsDTO operatePermissions, List<BulletinDTO> bulletins) {
        ControllerServiceReferencingComponentEntity entity = new ControllerServiceReferencingComponentEntity();
        entity.setId(id);
        entity.setRevision(revision);
        if (dto != null) {
            entity.setPermissions(permissions);
            entity.setOperatePermissions(operatePermissions);
            entity.setId(dto.getId());
            if (permissions != null && permissions.getCanRead().booleanValue()) {
                entity.setComponent(dto);
            }
        }
        if (permissions.getCanRead() == Boolean.TRUE) {
            List bulletinEntities = bulletins.stream().map(bulletin -> this.createBulletinEntity(bulletin, permissions.getCanRead().booleanValue())).collect(Collectors.toList());
            entity.setBulletins(bulletinEntities);
        } else {
            entity.setBulletins(null);
        }
        return entity;
    }

    public FlowBreadcrumbEntity createFlowBreadcrumbEntity(FlowBreadcrumbDTO dto, PermissionsDTO permissions) {
        FlowBreadcrumbEntity entity = new FlowBreadcrumbEntity();
        if (dto != null) {
            entity.setPermissions(permissions);
            entity.setId(dto.getId());
            if (dto.getVersionControlInformation() != null) {
                entity.setVersionedFlowState(dto.getVersionControlInformation().getState());
            }
            if (permissions != null && permissions.getCanRead().booleanValue()) {
                entity.setBreadcrumb(dto);
            }
        }
        return entity;
    }

    public AllowableValueEntity createAllowableValueEntity(AllowableValueDTO dto, boolean canRead) {
        AllowableValueEntity entity = new AllowableValueEntity();
        entity.setCanRead(Boolean.valueOf(canRead));
        entity.setAllowableValue(dto);
        return entity;
    }

    public ActionEntity createActionEntity(ActionDTO dto, boolean canRead) {
        ActionEntity entity = new ActionEntity();
        if (dto != null) {
            entity.setId(dto.getId());
            entity.setSourceId(dto.getSourceId());
            entity.setTimestamp(dto.getTimestamp());
            entity.setCanRead(Boolean.valueOf(canRead));
            if (canRead) {
                entity.setAction(dto);
            }
        }
        return entity;
    }

    public BulletinEntity createBulletinEntity(BulletinDTO dto, boolean canRead) {
        BulletinEntity entity = new BulletinEntity();
        if (dto != null) {
            entity.setId(dto.getId());
            entity.setSourceId(dto.getSourceId());
            entity.setGroupId(dto.getGroupId());
            entity.setTimestamp(dto.getTimestamp());
            entity.setNodeAddress(dto.getNodeAddress());
            entity.setCanRead(Boolean.valueOf(canRead));
            if (canRead) {
                entity.setBulletin(dto);
            }
        }
        return entity;
    }

    public VersionControlInformationEntity createVersionControlInformationEntity(VersionControlInformationDTO dto, RevisionDTO processGroupRevision) {
        VersionControlInformationEntity entity = new VersionControlInformationEntity();
        entity.setVersionControlInformation(dto);
        entity.setProcessGroupRevision(processGroupRevision);
        return entity;
    }

    public FlowRegistryClientEntity createRegistryEntity(FlowRegistryClientDTO dto) {
        FlowRegistryClientEntity entity = new FlowRegistryClientEntity();
        if (dto != null) {
            entity.setComponent(dto);
        }
        return entity;
    }

    public FlowRegistryBucketEntity createBucketEntity(FlowRegistryBucketDTO dto, PermissionsDTO permissions) {
        FlowRegistryBucketEntity entity = new FlowRegistryBucketEntity();
        entity.setId(dto.getId());
        entity.setPermissions(permissions);
        if (permissions != null && permissions.getCanRead().booleanValue()) {
            entity.setBucket(dto);
        }
        return entity;
    }

    public FlowRegistryBranchEntity createBranchEntity(FlowRegistryBranchDTO dto) {
        FlowRegistryBranchEntity entity = new FlowRegistryBranchEntity();
        entity.setBranch(dto);
        return entity;
    }
}

