/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.config;

import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.ext.ExceptionMapper;
import jakarta.ws.rs.ext.Provider;
import org.apache.nifi.cluster.manager.exception.NoConnectedNodesException;
import org.apache.nifi.cluster.manager.exception.NoResponseFromNodesException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class NoResponseFromNodesExceptionMapper
implements ExceptionMapper<NoResponseFromNodesException> {
    private static final Logger logger = LoggerFactory.getLogger(NoConnectedNodesException.class);

    public Response toResponse(NoResponseFromNodesException exception) {
        logger.info(String.format("%s. Returning %s response.", exception, Response.Status.CONFLICT));
        if (logger.isDebugEnabled()) {
            logger.debug("", (Throwable)exception);
        }
        return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)exception.getMessage()).type("text/plain").build();
    }
}

