/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.StreamingOutput;
import java.net.URI;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.ConnectionAuthorizable;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.cluster.manager.exception.UnknownNodeException;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.DownloadableContent;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.FlowFileQueueResource;
import org.apache.nifi.web.api.dto.DropRequestDTO;
import org.apache.nifi.web.api.dto.FlowFileDTO;
import org.apache.nifi.web.api.dto.FlowFileSummaryDTO;
import org.apache.nifi.web.api.dto.ListingRequestDTO;
import org.apache.nifi.web.api.entity.ConnectionEntity;
import org.apache.nifi.web.api.entity.DropRequestEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.FlowFileEntity;
import org.apache.nifi.web.api.entity.ListingRequestEntity;
import org.apache.nifi.web.api.request.ClientIdParameter;

@Path(value="/flowfile-queues")
@Tag(name="FlowFileQueues")
public class FlowFileQueueResource
extends ApplicationResource {
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;

    public ListingRequestDTO populateRemainingFlowFileListingContent(String connectionId, ListingRequestDTO flowFileListing) {
        flowFileListing.setUri(this.generateResourceUri(new String[]{"flowfile-queues", connectionId, "listing-requests", flowFileListing.getId()}));
        if (flowFileListing.getFlowFileSummaries() != null) {
            for (FlowFileSummaryDTO flowFile : flowFileListing.getFlowFileSummaries()) {
                this.populateRemainingFlowFileContent(connectionId, flowFile);
            }
        }
        return flowFileListing;
    }

    public FlowFileSummaryDTO populateRemainingFlowFileContent(String connectionId, FlowFileSummaryDTO flowFile) {
        flowFile.setUri(this.generateResourceUri(new String[]{"flowfile-queues", connectionId, "flowfiles", flowFile.getUuid()}));
        return flowFile;
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/flowfiles/{flowfile-uuid}")
    @Operation(summary="Gets a FlowFile from a Connection.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=FlowFileEntity.class))})}, security={@SecurityRequirement(name="Read Source Data - /data/{component-type}/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getFlowFile(@Parameter(description="The connection id.", required=true) @PathParam(value="id") String connectionId, @Parameter(description="The flowfile uuid.", required=true) @PathParam(value="flowfile-uuid") String flowFileUuid, @Parameter(description="The id of the node where the content exists if clustered.") @QueryParam(value="clusterNodeId") String clusterNodeId) throws InterruptedException {
        if (this.isReplicateRequest()) {
            if (clusterNodeId == null) {
                throw new IllegalArgumentException("The id of the node in the cluster is required.");
            }
            NodeIdentifier targetNode = this.getClusterCoordinator().getNodeIdentifier(clusterNodeId);
            if (targetNode == null) {
                throw new UnknownNodeException("The specified cluster node does not exist.");
            }
            return this.replicate("GET", targetNode);
        }
        FlowFileDTO flowfileDto = this.serviceFacade.getFlowFile(connectionId, flowFileUuid);
        this.populateRemainingFlowFileContent(connectionId, (FlowFileSummaryDTO)flowfileDto);
        FlowFileEntity entity = new FlowFileEntity();
        entity.setFlowFile(flowfileDto);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"*/*"})
    @Path(value="{id}/flowfiles/{flowfile-uuid}/content")
    @Operation(summary="Gets the content for a FlowFile in a Connection.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=StreamingOutput.class))})}, security={@SecurityRequirement(name="Read Source Data - /data/{component-type}/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response downloadFlowFileContent(@Parameter(description="If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.") @QueryParam(value="clientId") @DefaultValue(value="") ClientIdParameter clientId, @Parameter(description="The connection id.", required=true) @PathParam(value="id") String connectionId, @Parameter(description="The flowfile uuid.", required=true) @PathParam(value="flowfile-uuid") String flowFileUuid, @Parameter(description="The id of the node where the content exists if clustered.") @QueryParam(value="clusterNodeId") String clusterNodeId) {
        if (this.isReplicateRequest()) {
            if (clusterNodeId == null) {
                throw new IllegalArgumentException("The id of the node in the cluster is required.");
            }
            NodeIdentifier targetNode = this.getClusterCoordinator().getNodeIdentifier(clusterNodeId);
            if (targetNode == null) {
                throw new UnknownNodeException("The specified cluster node does not exist.");
            }
            return this.replicate("GET", targetNode);
        }
        String uri = this.generateResourceUri(new String[]{"flowfile-queues", connectionId, "flowfiles", flowFileUuid, "content"});
        DownloadableContent content = this.serviceFacade.getContent(connectionId, flowFileUuid, uri);
        1 response = new /* Unavailable Anonymous Inner Class!! */;
        String contentType = content.getType();
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        return this.generateOkResponse((Object)response).type(contentType).header("Content-Disposition", (Object)String.format("attachment; filename=\"%s\"", content.getFilename())).build();
    }

    @POST
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/listing-requests")
    @Operation(summary="Lists the contents of the queue in this connection.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ListingRequestEntity.class))})}, security={@SecurityRequirement(name="Read Source Data - /data/{component-type}/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="202", description="The request has been accepted. A HTTP response header will contain the URI where the response can be polled."), @ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response createFlowFileListing(@Parameter(description="The connection id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("POST");
        }
        ConnectionEntity requestConnectionEntity = new ConnectionEntity();
        requestConnectionEntity.setId(id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestConnectionEntity, lookup -> {
            ConnectionAuthorizable connAuth = lookup.getConnection(id);
            Authorizable dataAuthorizable = connAuth.getSourceData();
            dataAuthorizable.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyListQueue(id), connectionEntity -> {
            String listingRequestId = this.generateUuid();
            ListingRequestDTO listingRequest = this.serviceFacade.createFlowFileListingRequest(connectionEntity.getId(), listingRequestId);
            this.populateRemainingFlowFileListingContent(connectionEntity.getId(), listingRequest);
            ListingRequestEntity entity = new ListingRequestEntity();
            entity.setListingRequest(listingRequest);
            URI location = URI.create(listingRequest.getUri());
            return Response.status((Response.Status)Response.Status.ACCEPTED).location(location).entity((Object)entity).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/listing-requests/{listing-request-id}")
    @Operation(summary="Gets the current status of a listing request for the specified connection.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ListingRequestEntity.class))})}, security={@SecurityRequirement(name="Read Source Data - /data/{component-type}/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getListingRequest(@Parameter(description="The connection id.", required=true) @PathParam(value="id") String connectionId, @Parameter(description="The listing request id.", required=true) @PathParam(value="listing-request-id") String listingRequestId) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            ConnectionAuthorizable connAuth = lookup.getConnection(connectionId);
            Authorizable dataAuthorizable = connAuth.getSourceData();
            dataAuthorizable.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        ListingRequestDTO listingRequest = this.serviceFacade.getFlowFileListingRequest(connectionId, listingRequestId);
        this.populateRemainingFlowFileListingContent(connectionId, listingRequest);
        ListingRequestEntity entity = new ListingRequestEntity();
        entity.setListingRequest(listingRequest);
        return this.generateOkResponse((Object)entity).build();
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/listing-requests/{listing-request-id}")
    @Operation(summary="Cancels and/or removes a request to list the contents of this connection.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=ListingRequestEntity.class))})}, security={@SecurityRequirement(name="Read Source Data - /data/{component-type}/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response deleteListingRequest(@Parameter(description="The connection id.", required=true) @PathParam(value="id") String connectionId, @Parameter(description="The listing request id.", required=true) @PathParam(value="listing-request-id") String listingRequestId) {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        return this.withWriteLock(this.serviceFacade, (Entity)new ListingEntity(connectionId, listingRequestId), lookup -> {
            ConnectionAuthorizable connAuth = lookup.getConnection(connectionId);
            Authorizable dataAuthorizable = connAuth.getSourceData();
            dataAuthorizable.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        }, null, listingEntity -> {
            ListingRequestDTO listingRequest = this.serviceFacade.deleteFlowFileListingRequest(listingEntity.getConnectionId(), listingEntity.getListingRequestId());
            listingRequest.setFlowFileSummaries(null);
            this.populateRemainingFlowFileListingContent(listingEntity.getConnectionId(), listingRequest);
            ListingRequestEntity entity = new ListingRequestEntity();
            entity.setListingRequest(listingRequest);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @POST
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/drop-requests")
    @Operation(summary="Creates a request to drop the contents of the queue in this connection.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=DropRequestEntity.class))})}, security={@SecurityRequirement(name="Write Source Data - /data/{component-type}/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="202", description="The request has been accepted. A HTTP response header will contain the URI where the response can be polled."), @ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response createDropRequest(@Parameter(description="The connection id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("POST");
        }
        ConnectionEntity requestConnectionEntity = new ConnectionEntity();
        requestConnectionEntity.setId(id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestConnectionEntity, lookup -> {
            ConnectionAuthorizable connAuth = lookup.getConnection(id);
            Authorizable dataAuthorizable = connAuth.getSourceData();
            dataAuthorizable.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, null, connectionEntity -> {
            String dropRequestId = this.generateUuid();
            DropRequestDTO dropRequest = this.serviceFacade.createFlowFileDropRequest(connectionEntity.getId(), dropRequestId);
            dropRequest.setUri(this.generateResourceUri(new String[]{"flowfile-queues", connectionEntity.getId(), "drop-requests", dropRequest.getId()}));
            DropRequestEntity entity = new DropRequestEntity();
            entity.setDropRequest(dropRequest);
            URI location = URI.create(dropRequest.getUri());
            return Response.status((Response.Status)Response.Status.ACCEPTED).location(location).entity((Object)entity).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/drop-requests/{drop-request-id}")
    @Operation(summary="Gets the current status of a drop request for the specified connection.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=DropRequestEntity.class))})}, security={@SecurityRequirement(name="Write Source Data - /data/{component-type}/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response getDropRequest(@Parameter(description="The connection id.", required=true) @PathParam(value="id") String connectionId, @Parameter(description="The drop request id.", required=true) @PathParam(value="drop-request-id") String dropRequestId) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            ConnectionAuthorizable connAuth = lookup.getConnection(connectionId);
            Authorizable dataAuthorizable = connAuth.getSourceData();
            dataAuthorizable.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        });
        DropRequestDTO dropRequest = this.serviceFacade.getFlowFileDropRequest(connectionId, dropRequestId);
        dropRequest.setUri(this.generateResourceUri(new String[]{"flowfile-queues", connectionId, "drop-requests", dropRequestId}));
        DropRequestEntity entity = new DropRequestEntity();
        entity.setDropRequest(dropRequest);
        return this.generateOkResponse((Object)entity).build();
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/drop-requests/{drop-request-id}")
    @Operation(summary="Cancels and/or removes a request to drop the contents of this connection.", responses={@ApiResponse(content={@Content(schema=@Schema(implementation=DropRequestEntity.class))})}, security={@SecurityRequirement(name="Write Source Data - /data/{component-type}/{uuid}")})
    @ApiResponses(value={@ApiResponse(responseCode="400", description="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(responseCode="401", description="Client could not be authenticated."), @ApiResponse(responseCode="403", description="Client is not authorized to make this request."), @ApiResponse(responseCode="404", description="The specified resource could not be found."), @ApiResponse(responseCode="409", description="The request was valid but NiFi was not in the appropriate state to process it.")})
    public Response removeDropRequest(@Parameter(description="The connection id.", required=true) @PathParam(value="id") String connectionId, @Parameter(description="The drop request id.", required=true) @PathParam(value="drop-request-id") String dropRequestId) {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        return this.withWriteLock(this.serviceFacade, (Entity)new DropEntity(connectionId, dropRequestId), lookup -> {
            ConnectionAuthorizable connAuth = lookup.getConnection(connectionId);
            Authorizable dataAuthorizable = connAuth.getSourceData();
            dataAuthorizable.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, null, dropEntity -> {
            DropRequestDTO dropRequest = this.serviceFacade.deleteFlowFileDropRequest(dropEntity.getConnectionId(), dropEntity.getDropRequestId());
            dropRequest.setUri(this.generateResourceUri(new String[]{"flowfile-queues", dropEntity.getConnectionId(), "drop-requests", dropEntity.getDropRequestId()}));
            DropRequestEntity entity = new DropRequestEntity();
            entity.setDropRequest(dropRequest);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }
}

