/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.controller;

import java.util.Map;
import org.apache.nifi.attribute.expression.language.StandardPropertyValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.search.SearchContext;

public class StandardSearchContext
implements SearchContext {
    private final String searchTerm;
    private final ProcessorNode processorNode;
    private final ControllerServiceLookup controllerServiceLookup;
    private final VariableRegistry variableRegistry;

    public StandardSearchContext(String searchTerm, ProcessorNode processorNode, ControllerServiceLookup controllerServiceLookup, VariableRegistry variableRegistry) {
        this.searchTerm = searchTerm;
        this.processorNode = processorNode;
        this.controllerServiceLookup = controllerServiceLookup;
        this.variableRegistry = variableRegistry;
    }

    public String getSearchTerm() {
        return this.searchTerm;
    }

    public String getAnnotationData() {
        return this.processorNode.getAnnotationData();
    }

    public PropertyValue getProperty(PropertyDescriptor property) {
        String configuredValue = this.processorNode.getProperty(property);
        return new StandardPropertyValue(configuredValue == null ? property.getDefaultValue() : configuredValue, this.controllerServiceLookup, this.variableRegistry);
    }

    public Map<PropertyDescriptor, String> getProperties() {
        return this.processorNode.getProperties();
    }
}

