/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.concurrent;

import java.util.Date;
import java.util.Objects;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.web.api.concurrent.AsynchronousWebRequest;

public class StandardAsynchronousWebRequest<T>
implements AsynchronousWebRequest<T> {
    private final String id;
    private final String processGroupId;
    private final NiFiUser user;
    private volatile boolean complete = false;
    private volatile Date lastUpdated = new Date();
    private volatile String state;
    private volatile int percentComplete;
    private volatile String failureReason;
    private volatile boolean cancelled;
    private volatile T results;
    private volatile Runnable cancelCallback;

    public StandardAsynchronousWebRequest(String requestId, String processGroupId, NiFiUser user, String state) {
        this.id = requestId;
        this.processGroupId = processGroupId;
        this.user = user;
        this.state = state;
    }

    public String getRequestId() {
        return this.id;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public String getProcessGroupId() {
        return this.processGroupId;
    }

    public void setCancelCallback(Runnable runnable) {
        this.cancelCallback = runnable;
    }

    public void markComplete(T results) {
        this.complete = true;
        this.results = results;
        this.lastUpdated = new Date();
        this.percentComplete = 100;
        this.state = "Complete";
    }

    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    public String getState() {
        return this.state;
    }

    public int getPercentComplete() {
        return this.percentComplete;
    }

    public void update(Date date, String state, int percentComplete) {
        if (percentComplete < 0 || percentComplete > 100) {
            throw new IllegalArgumentException("Cannot set percent complete to a value of " + percentComplete + "; it must be between 0 and 100.");
        }
        if (this.isCancelled()) {
            throw new IllegalStateException("Cannot update state because request has already been cancelled by user");
        }
        if (this.isComplete()) {
            String failure = this.getFailureReason();
            String explanation = failure == null ? "successfully" : "with failure reason: " + failure;
            throw new IllegalStateException("Cannot update state to '" + state + "' because request is already completed " + explanation);
        }
        this.lastUpdated = date;
        this.state = state;
        this.percentComplete = percentComplete;
    }

    public NiFiUser getUser() {
        return this.user;
    }

    public void setFailureReason(String explanation) {
        this.failureReason = Objects.requireNonNull(explanation);
        this.complete = true;
        this.results = null;
        this.lastUpdated = new Date();
    }

    public String getFailureReason() {
        return this.failureReason;
    }

    public T getResults() {
        return (T)this.results;
    }

    public void cancel() {
        this.cancelled = true;
        this.percentComplete = 100;
        this.state = "Canceled by user";
        this.setFailureReason("Request cancelled by user");
        this.cancelCallback.run();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }
}

