/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.dao.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.exception.ValidationException;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.remote.RootGroupPort;
import org.apache.nifi.web.NiFiCoreException;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.api.dto.PortDTO;
import org.apache.nifi.web.dao.PortDAO;
import org.apache.nifi.web.dao.impl.ComponentDAO;
import org.apache.nifi.web.dao.impl.StandardInputPortDAO;

public class StandardInputPortDAO
extends ComponentDAO
implements PortDAO {
    private FlowController flowController;

    private Port locatePort(String portId) {
        ProcessGroup rootGroup = this.flowController.getGroup(this.flowController.getRootGroupId());
        Port port = rootGroup.findInputPort(portId);
        if (port == null) {
            port = rootGroup.findOutputPort(portId);
        }
        if (port == null) {
            throw new ResourceNotFoundException(String.format("Unable to find port with id '%s'.", portId));
        }
        return port;
    }

    public boolean hasPort(String portId) {
        ProcessGroup rootGroup = this.flowController.getGroup(this.flowController.getRootGroupId());
        return rootGroup.findInputPort(portId) != null || rootGroup.findOutputPort(portId) != null;
    }

    public Port createPort(String groupId, PortDTO portDTO) {
        if (this.isNotNull((Object)portDTO.getParentGroupId()) && !this.flowController.areGroupsSame(groupId, portDTO.getParentGroupId())) {
            throw new IllegalArgumentException("Cannot specify a different Parent Group ID than the Group to which the InputPort is being added.");
        }
        if (portDTO.getName() == null) {
            throw new IllegalArgumentException("Port name must be specified.");
        }
        ProcessGroup group = this.locateProcessGroup(this.flowController, groupId);
        Port port = group.getParent() == null ? this.flowController.createRemoteInputPort(portDTO.getId(), portDTO.getName()) : this.flowController.createLocalInputPort(portDTO.getId(), portDTO.getName());
        this.verifyUpdate(port, portDTO);
        if (portDTO.getPosition() != null) {
            port.setPosition(new Position(portDTO.getPosition().getX().doubleValue(), portDTO.getPosition().getY().doubleValue()));
        }
        port.setComments(portDTO.getComments());
        group.addInputPort(port);
        return port;
    }

    public Port getPort(String portId) {
        return this.locatePort(portId);
    }

    public Set<Port> getPorts(String groupId) {
        ProcessGroup group = this.locateProcessGroup(this.flowController, groupId);
        return group.getInputPorts();
    }

    public void verifyUpdate(PortDTO portDTO) {
        Port inputPort = this.locatePort(portDTO.getId());
        this.verifyUpdate(inputPort, portDTO);
    }

    private void verifyUpdate(Port inputPort, PortDTO portDTO) {
        ScheduledState purposedScheduledState;
        if (this.isNotNull((Object)portDTO.getState()) && !(purposedScheduledState = ScheduledState.valueOf((String)portDTO.getState())).equals((Object)inputPort.getScheduledState())) {
            switch (1.$SwitchMap$org$apache$nifi$controller$ScheduledState[purposedScheduledState.ordinal()]) {
                case 1: {
                    inputPort.verifyCanStart();
                    break;
                }
                case 3: {
                    switch (1.$SwitchMap$org$apache$nifi$controller$ScheduledState[inputPort.getScheduledState().ordinal()]) {
                        case 1: {
                            inputPort.verifyCanStop();
                            break;
                        }
                        case 2: {
                            inputPort.verifyCanEnable();
                        }
                    }
                    break;
                }
                case 2: {
                    inputPort.verifyCanDisable();
                }
            }
        }
        if (this.isAnyNotNull(new Object[]{portDTO.getUserAccessControl(), portDTO.getGroupAccessControl(), portDTO.getConcurrentlySchedulableTaskCount(), portDTO.getName(), portDTO.getComments()})) {
            List requestValidation = this.validateProposedConfiguration(portDTO);
            if (!requestValidation.isEmpty()) {
                throw new ValidationException(requestValidation);
            }
            inputPort.verifyCanUpdate();
        }
    }

    private List<String> validateProposedConfiguration(PortDTO portDTO) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (this.isNotNull((Object)portDTO.getName()) && portDTO.getName().trim().isEmpty()) {
            validationErrors.add("Port name cannot be blank.");
        }
        if (this.isNotNull((Object)portDTO.getConcurrentlySchedulableTaskCount()) && portDTO.getConcurrentlySchedulableTaskCount() <= 0) {
            validationErrors.add("Concurrent tasks must be a positive integer.");
        }
        return validationErrors;
    }

    public Port updatePort(PortDTO portDTO) {
        ScheduledState purposedScheduledState;
        Port inputPort = this.locatePort(portDTO.getId());
        this.verifyUpdate(inputPort, portDTO);
        if (this.isNotNull((Object)portDTO.getState()) && !(purposedScheduledState = ScheduledState.valueOf((String)portDTO.getState())).equals((Object)inputPort.getScheduledState())) {
            try {
                block1 : switch (1.$SwitchMap$org$apache$nifi$controller$ScheduledState[purposedScheduledState.ordinal()]) {
                    case 1: {
                        inputPort.getProcessGroup().startInputPort(inputPort);
                        break;
                    }
                    case 3: {
                        switch (1.$SwitchMap$org$apache$nifi$controller$ScheduledState[inputPort.getScheduledState().ordinal()]) {
                            case 1: {
                                inputPort.getProcessGroup().stopInputPort(inputPort);
                                break block1;
                            }
                            case 2: {
                                inputPort.getProcessGroup().enableInputPort(inputPort);
                            }
                        }
                        break;
                    }
                    case 2: {
                        inputPort.getProcessGroup().disableInputPort(inputPort);
                    }
                }
            }
            catch (IllegalStateException ise) {
                throw new NiFiCoreException(ise.getMessage(), (Throwable)ise);
            }
        }
        if (inputPort instanceof RootGroupPort) {
            RootGroupPort rootPort = (RootGroupPort)inputPort;
            if (this.isNotNull((Object)portDTO.getGroupAccessControl())) {
                rootPort.setGroupAccessControl(portDTO.getGroupAccessControl());
            }
            if (this.isNotNull((Object)portDTO.getUserAccessControl())) {
                rootPort.setUserAccessControl(portDTO.getUserAccessControl());
            }
        }
        String name = portDTO.getName();
        String comments = portDTO.getComments();
        Integer concurrentTasks = portDTO.getConcurrentlySchedulableTaskCount();
        if (this.isNotNull((Object)portDTO.getPosition())) {
            inputPort.setPosition(new Position(portDTO.getPosition().getX().doubleValue(), portDTO.getPosition().getY().doubleValue()));
        }
        if (this.isNotNull((Object)name)) {
            inputPort.setName(name);
        }
        if (this.isNotNull((Object)comments)) {
            inputPort.setComments(comments);
        }
        if (this.isNotNull((Object)concurrentTasks)) {
            inputPort.setMaxConcurrentTasks(concurrentTasks.intValue());
        }
        inputPort.getProcessGroup().onComponentModified();
        return inputPort;
    }

    public void verifyDelete(String portId) {
        Port inputPort = this.locatePort(portId);
        inputPort.verifyCanDelete();
    }

    public void deletePort(String portId) {
        Port inputPort = this.locatePort(portId);
        inputPort.getProcessGroup().removeInputPort(inputPort);
    }

    public void setFlowController(FlowController flowController) {
        this.flowController = flowController;
    }
}

