/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.nifi.authorization.AuthorizableLookup;
import org.apache.nifi.authorization.AuthorizeControllerServiceReference;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.ComponentAuthorizable;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.ui.extension.UiExtension;
import org.apache.nifi.ui.extension.UiExtensionMapping;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.UiExtensionType;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.apache.nifi.web.api.dto.ComponentStateDTO;
import org.apache.nifi.web.api.dto.PropertyDescriptorDTO;
import org.apache.nifi.web.api.dto.ReportingTaskDTO;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.api.entity.ComponentStateEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.PropertyDescriptorEntity;
import org.apache.nifi.web.api.entity.ReportingTaskEntity;
import org.apache.nifi.web.api.request.ClientIdParameter;
import org.apache.nifi.web.api.request.LongParameter;

@Path(value="/reporting-tasks")
@Api(value="/reporting-tasks", description="Endpoint for managing a Reporting Task.")
public class ReportingTaskResource
extends ApplicationResource {
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;
    @Context
    private ServletContext servletContext;

    public Set<ReportingTaskEntity> populateRemainingReportingTaskEntitiesContent(Set<ReportingTaskEntity> reportingTaskEntities) {
        for (ReportingTaskEntity reportingTaskEntity : reportingTaskEntities) {
            this.populateRemainingReportingTaskEntityContent(reportingTaskEntity);
        }
        return reportingTaskEntities;
    }

    public ReportingTaskEntity populateRemainingReportingTaskEntityContent(ReportingTaskEntity reportingTaskEntity) {
        reportingTaskEntity.setUri(this.generateResourceUri(new String[]{"reporting-tasks", reportingTaskEntity.getId()}));
        if (reportingTaskEntity.getComponent() != null) {
            this.populateRemainingReportingTaskContent(reportingTaskEntity.getComponent());
        }
        return reportingTaskEntity;
    }

    public ReportingTaskDTO populateRemainingReportingTaskContent(ReportingTaskDTO reportingTask) {
        BundleDTO bundle = reportingTask.getBundle();
        UiExtensionMapping uiExtensionMapping = (UiExtensionMapping)this.servletContext.getAttribute("nifi-ui-extensions");
        if (uiExtensionMapping.hasUiExtension(reportingTask.getType(), bundle.getGroup(), bundle.getArtifact(), bundle.getVersion())) {
            List uiExtensions = uiExtensionMapping.getUiExtension(reportingTask.getType(), bundle.getGroup(), bundle.getArtifact(), bundle.getVersion());
            for (UiExtension uiExtension : uiExtensions) {
                if (!UiExtensionType.ReportingTaskConfiguration.equals((Object)uiExtension.getExtensionType())) continue;
                reportingTask.setCustomUiUrl(uiExtension.getContextPath() + "/configure");
            }
        }
        return reportingTask;
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Gets a reporting task", response=ReportingTaskEntity.class, authorizations={@Authorization(value="Read - /reporting-tasks/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getReportingTask(@ApiParam(value="The reporting task id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable reportingTask = lookup.getReportingTask(id).getAuthorizable();
            reportingTask.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        ReportingTaskEntity reportingTask = this.serviceFacade.getReportingTask(id);
        this.populateRemainingReportingTaskEntityContent(reportingTask);
        return this.generateOkResponse((Object)reportingTask).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/descriptors")
    @ApiOperation(value="Gets a reporting task property descriptor", response=PropertyDescriptorEntity.class, authorizations={@Authorization(value="Read - /reporting-tasks/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getPropertyDescriptor(@ApiParam(value="The reporting task id.", required=true) @PathParam(value="id") String id, @ApiParam(value="The property name.", required=true) @QueryParam(value="propertyName") String propertyName) {
        if (propertyName == null) {
            throw new IllegalArgumentException("The property name must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable reportingTask = lookup.getReportingTask(id).getAuthorizable();
            reportingTask.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        PropertyDescriptorDTO descriptor = this.serviceFacade.getReportingTaskPropertyDescriptor(id, propertyName);
        PropertyDescriptorEntity entity = new PropertyDescriptorEntity();
        entity.setPropertyDescriptor(descriptor);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/state")
    @ApiOperation(value="Gets the state for a reporting task", response=ComponentStateEntity.class, authorizations={@Authorization(value="Write - /reporting-tasks/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getState(@ApiParam(value="The reporting task id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable reportingTask = lookup.getReportingTask(id).getAuthorizable();
            reportingTask.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        });
        ComponentStateDTO state = this.serviceFacade.getReportingTaskState(id);
        ComponentStateEntity entity = new ComponentStateEntity();
        entity.setComponentState(state);
        return this.generateOkResponse((Object)entity).build();
    }

    @POST
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/state/clear-requests")
    @ApiOperation(value="Clears the state for a reporting task", response=ComponentStateEntity.class, authorizations={@Authorization(value="Write - /reporting-tasks/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response clearState(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The reporting task id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("POST");
        }
        ReportingTaskEntity requestReportTaskEntity = new ReportingTaskEntity();
        requestReportTaskEntity.setId(id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestReportTaskEntity, lookup -> {
            Authorizable processor = lookup.getReportingTask(id).getAuthorizable();
            processor.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyCanClearReportingTaskState(id), reportingTaskEntity -> {
            this.serviceFacade.clearReportingTaskState(reportingTaskEntity.getId());
            ComponentStateEntity entity = new ComponentStateEntity();
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Updates a reporting task", response=ReportingTaskEntity.class, authorizations={@Authorization(value="Write - /reporting-tasks/{uuid}"), @Authorization(value="Read - any referenced Controller Services if this request changes the reference - /controller-services/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response updateReportingTask(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The reporting task id.", required=true) @PathParam(value="id") String id, @ApiParam(value="The reporting task configuration details.", required=true) ReportingTaskEntity requestReportingTaskEntity) {
        if (requestReportingTaskEntity == null || requestReportingTaskEntity.getComponent() == null) {
            throw new IllegalArgumentException("Reporting task details must be specified.");
        }
        if (requestReportingTaskEntity.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        ReportingTaskDTO requestReportingTaskDTO = requestReportingTaskEntity.getComponent();
        if (!id.equals(requestReportingTaskDTO.getId())) {
            throw new IllegalArgumentException(String.format("The reporting task id (%s) in the request body does not equal the reporting task id of the requested resource (%s).", requestReportingTaskDTO.getId(), id));
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestReportingTaskEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestReportingTaskEntity.isDisconnectedNodeAcknowledged());
        }
        Revision requestRevision = this.getRevision((ComponentEntity)requestReportingTaskEntity, id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestReportingTaskEntity, requestRevision, lookup -> {
            ComponentAuthorizable authorizable = lookup.getReportingTask(id);
            authorizable.getAuthorizable().authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            AuthorizeControllerServiceReference.authorizeControllerServiceReferences((Map)requestReportingTaskDTO.getProperties(), (ComponentAuthorizable)authorizable, (Authorizer)this.authorizer, (AuthorizableLookup)lookup);
        }, () -> this.serviceFacade.verifyUpdateReportingTask(requestReportingTaskDTO), (revision, reportingTaskEntity) -> {
            ReportingTaskDTO reportingTaskDTO = reportingTaskEntity.getComponent();
            ReportingTaskEntity entity = this.serviceFacade.updateReportingTask(revision, reportingTaskDTO);
            this.populateRemainingReportingTaskEntityContent(entity);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Deletes a reporting task", response=ReportingTaskEntity.class, authorizations={@Authorization(value="Write - /reporting-tasks/{uuid}"), @Authorization(value="Write - /controller"), @Authorization(value="Read - any referenced Controller Services - /controller-services/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response removeReportingTask(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The revision is used to verify the client is working with the latest version of the flow.", required=false) @QueryParam(value="version") LongParameter version, @ApiParam(value="If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.", required=false) @QueryParam(value="clientId") @DefaultValue(value="") ClientIdParameter clientId, @ApiParam(value="Acknowledges that this node is disconnected to allow for mutable requests to proceed.", required=false) @QueryParam(value="disconnectedNodeAcknowledged") @DefaultValue(value="false") Boolean disconnectedNodeAcknowledged, @ApiParam(value="The reporting task id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(disconnectedNodeAcknowledged);
        }
        ReportingTaskEntity requestReportingTaskEntity = new ReportingTaskEntity();
        requestReportingTaskEntity.setId(id);
        Revision requestRevision = new Revision(version == null ? null : version.getLong(), clientId.getClientId(), id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestReportingTaskEntity, requestRevision, lookup -> {
            ComponentAuthorizable reportingTask = lookup.getReportingTask(id);
            reportingTask.getAuthorizable().authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            reportingTask.getAuthorizable().getParentAuthorizable().authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            AuthorizeControllerServiceReference.authorizeControllerServiceReferences((ComponentAuthorizable)reportingTask, (Authorizer)this.authorizer, (AuthorizableLookup)lookup, (boolean)false);
        }, () -> this.serviceFacade.verifyDeleteReportingTask(id), (revision, reportingTaskEntity) -> {
            ReportingTaskEntity entity = this.serviceFacade.deleteReportingTask(revision, reportingTaskEntity.getId());
            return this.generateOkResponse((Object)entity).build();
        });
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }
}

