/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.AuthorizableLookup;
import org.apache.nifi.authorization.AuthorizeControllerServiceReference;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.ComponentAuthorizable;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.ui.extension.UiExtension;
import org.apache.nifi.ui.extension.UiExtensionMapping;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.UiExtensionType;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.apache.nifi.web.api.dto.ComponentStateDTO;
import org.apache.nifi.web.api.dto.PositionDTO;
import org.apache.nifi.web.api.dto.ProcessorConfigDTO;
import org.apache.nifi.web.api.dto.ProcessorDTO;
import org.apache.nifi.web.api.dto.PropertyDescriptorDTO;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.api.entity.ComponentStateEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.ProcessorDiagnosticsEntity;
import org.apache.nifi.web.api.entity.ProcessorEntity;
import org.apache.nifi.web.api.entity.PropertyDescriptorEntity;
import org.apache.nifi.web.api.request.ClientIdParameter;
import org.apache.nifi.web.api.request.LongParameter;

@Path(value="/processors")
@Api(value="/processors", description="Endpoint for managing a Processor.")
public class ProcessorResource
extends ApplicationResource {
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;
    @Context
    private ServletContext servletContext;

    public Set<ProcessorEntity> populateRemainingProcessorEntitiesContent(Set<ProcessorEntity> processorEntities) {
        for (ProcessorEntity processorEntity : processorEntities) {
            this.populateRemainingProcessorEntityContent(processorEntity);
        }
        return processorEntities;
    }

    public ProcessorEntity populateRemainingProcessorEntityContent(ProcessorEntity processorEntity) {
        processorEntity.setUri(this.generateResourceUri(new String[]{"processors", processorEntity.getId()}));
        if (processorEntity.getComponent() != null) {
            this.populateRemainingProcessorContent(processorEntity.getComponent());
        }
        return processorEntity;
    }

    public ProcessorDiagnosticsEntity populateRemainingProcessorDiagnosticsEntityContent(ProcessorDiagnosticsEntity processorDiagnosticsEntity) {
        processorDiagnosticsEntity.setUri(this.generateResourceUri(new String[]{"processors", processorDiagnosticsEntity.getId(), "diagnostics"}));
        if (processorDiagnosticsEntity.getComponent() != null && processorDiagnosticsEntity.getComponent().getProcessor() != null) {
            this.populateRemainingProcessorContent(processorDiagnosticsEntity.getComponent().getProcessor());
        }
        return processorDiagnosticsEntity;
    }

    public ProcessorDTO populateRemainingProcessorContent(ProcessorDTO processor) {
        ProcessorConfigDTO config = processor.getConfig();
        if (config != null) {
            String customUiUrl = this.servletContext.getInitParameter(processor.getType());
            if (StringUtils.isNotBlank((CharSequence)customUiUrl)) {
                config.setCustomUiUrl(customUiUrl);
            } else {
                BundleDTO bundle = processor.getBundle();
                UiExtensionMapping uiExtensionMapping = (UiExtensionMapping)this.servletContext.getAttribute("nifi-ui-extensions");
                if (uiExtensionMapping.hasUiExtension(processor.getType(), bundle.getGroup(), bundle.getArtifact(), bundle.getVersion())) {
                    List uiExtensions = uiExtensionMapping.getUiExtension(processor.getType(), bundle.getGroup(), bundle.getArtifact(), bundle.getVersion());
                    for (UiExtension uiExtension : uiExtensions) {
                        if (!UiExtensionType.ProcessorConfiguration.equals((Object)uiExtension.getExtensionType())) continue;
                        config.setCustomUiUrl(uiExtension.getContextPath() + "/configure");
                    }
                }
            }
        }
        return processor;
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    @ApiOperation(value="Gets a processor", response=ProcessorEntity.class, authorizations={@Authorization(value="Read - /processors/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getProcessor(@ApiParam(value="The processor id.", required=true) @PathParam(value="id") String id) throws InterruptedException {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable processor = lookup.getProcessor(id).getAuthorizable();
            processor.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        ProcessorEntity entity = this.serviceFacade.getProcessor(id);
        this.populateRemainingProcessorEntityContent(entity);
        return this.generateOkResponse((Object)entity).build();
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="/{id}/threads")
    @ApiOperation(value="Terminates a processor, essentially \"deleting\" its threads and any active tasks", response=ProcessorEntity.class, authorizations={@Authorization(value="Write - /processors/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response terminateProcessor(@ApiParam(value="The processor id.", required=true) @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        ProcessorEntity requestProcessorEntity = new ProcessorEntity();
        requestProcessorEntity.setId(id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestProcessorEntity, lookup -> {
            Authorizable authorizable = lookup.getProcessor(id).getAuthorizable();
            authorizable.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyTerminateProcessor(id), processorEntity -> {
            ProcessorEntity entity = this.serviceFacade.terminateProcessor(processorEntity.getId());
            this.populateRemainingProcessorEntityContent(entity);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="/{id}/diagnostics")
    @ApiOperation(value="Gets diagnostics information about a processor", response=ProcessorEntity.class, notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", authorizations={@Authorization(value="Read - /processors/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getProcessorDiagnostics(@ApiParam(value="The processor id.", required=true) @PathParam(value="id") String id) throws InterruptedException {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable processor = lookup.getProcessor(id).getAuthorizable();
            processor.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        ProcessorDiagnosticsEntity entity = this.serviceFacade.getProcessorDiagnostics(id);
        this.populateRemainingProcessorDiagnosticsEntityContent(entity);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="/{id}/descriptors")
    @ApiOperation(value="Gets the descriptor for a processor property", response=PropertyDescriptorEntity.class, authorizations={@Authorization(value="Read - /processors/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getPropertyDescriptor(@ApiParam(value="If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.", required=false) @QueryParam(value="clientId") @DefaultValue(value="") ClientIdParameter clientId, @ApiParam(value="The processor id.", required=true) @PathParam(value="id") String id, @ApiParam(value="The property name.", required=true) @QueryParam(value="propertyName") String propertyName) throws InterruptedException {
        if (propertyName == null) {
            throw new IllegalArgumentException("The property name must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable processor = lookup.getProcessor(id).getAuthorizable();
            processor.authorize(this.authorizer, RequestAction.READ, NiFiUserUtils.getNiFiUser());
        });
        PropertyDescriptorDTO descriptor = this.serviceFacade.getProcessorPropertyDescriptor(id, propertyName);
        PropertyDescriptorEntity entity = new PropertyDescriptorEntity();
        entity.setPropertyDescriptor(descriptor);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="/{id}/state")
    @ApiOperation(value="Gets the state for a processor", response=ComponentStateEntity.class, authorizations={@Authorization(value="Write - /processors/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getState(@ApiParam(value="The processor id.", required=true) @PathParam(value="id") String id) throws InterruptedException {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable processor = lookup.getProcessor(id).getAuthorizable();
            processor.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        });
        ComponentStateDTO state = this.serviceFacade.getProcessorState(id);
        ComponentStateEntity entity = new ComponentStateEntity();
        entity.setComponentState(state);
        return this.generateOkResponse((Object)entity).build();
    }

    @POST
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}/state/clear-requests")
    @ApiOperation(value="Clears the state for a processor", response=ComponentStateEntity.class, authorizations={@Authorization(value="Write - /processors/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response clearState(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The processor id.", required=true) @PathParam(value="id") String id) throws InterruptedException {
        if (this.isReplicateRequest()) {
            return this.replicate("POST");
        }
        ProcessorEntity requestProcessorEntity = new ProcessorEntity();
        requestProcessorEntity.setId(id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestProcessorEntity, lookup -> {
            Authorizable processor = lookup.getProcessor(id).getAuthorizable();
            processor.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
        }, () -> this.serviceFacade.verifyCanClearProcessorState(id), processorEntity -> {
            this.serviceFacade.clearProcessorState(processorEntity.getId());
            ComponentStateEntity entity = new ComponentStateEntity();
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    @ApiOperation(value="Updates a processor", response=ProcessorEntity.class, authorizations={@Authorization(value="Write - /processors/{uuid}"), @Authorization(value="Read - any referenced Controller Services if this request changes the reference - /controller-services/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response updateProcessor(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The processor id.", required=true) @PathParam(value="id") String id, @ApiParam(value="The processor configuration details.", required=true) ProcessorEntity requestProcessorEntity) throws InterruptedException {
        if (requestProcessorEntity == null || requestProcessorEntity.getComponent() == null) {
            throw new IllegalArgumentException("Processor details must be specified.");
        }
        if (requestProcessorEntity.getRevision() == null) {
            throw new IllegalArgumentException("Revision must be specified.");
        }
        ProcessorDTO requestProcessorDTO = requestProcessorEntity.getComponent();
        if (!id.equals(requestProcessorDTO.getId())) {
            throw new IllegalArgumentException(String.format("The processor id (%s) in the request body does not equal the processor id of the requested resource (%s).", requestProcessorDTO.getId(), id));
        }
        PositionDTO proposedPosition = requestProcessorDTO.getPosition();
        if (proposedPosition != null && (proposedPosition.getX() == null || proposedPosition.getY() == null)) {
            throw new IllegalArgumentException("The x and y coordinate of the proposed position must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestProcessorEntity);
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(requestProcessorEntity.isDisconnectedNodeAcknowledged());
        }
        Revision requestRevision = this.getRevision((ComponentEntity)requestProcessorEntity, id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestProcessorEntity, requestRevision, lookup -> {
            NiFiUser user = NiFiUserUtils.getNiFiUser();
            ComponentAuthorizable authorizable = lookup.getProcessor(id);
            authorizable.getAuthorizable().authorize(this.authorizer, RequestAction.WRITE, user);
            ProcessorConfigDTO config = requestProcessorDTO.getConfig();
            if (config != null) {
                AuthorizeControllerServiceReference.authorizeControllerServiceReferences((Map)config.getProperties(), (ComponentAuthorizable)authorizable, (Authorizer)this.authorizer, (AuthorizableLookup)lookup);
            }
        }, () -> this.serviceFacade.verifyUpdateProcessor(requestProcessorDTO), (revision, processorEntity) -> {
            ProcessorDTO processorDTO = processorEntity.getComponent();
            ProcessorEntity entity = this.serviceFacade.updateProcessor(revision, processorDTO);
            this.populateRemainingProcessorEntityContent(entity);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    @DELETE
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="/{id}")
    @ApiOperation(value="Deletes a processor", response=ProcessorEntity.class, authorizations={@Authorization(value="Write - /processors/{uuid}"), @Authorization(value="Write - Parent Process Group - /process-groups/{uuid}"), @Authorization(value="Read - any referenced Controller Services - /controller-services/{uuid}")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response deleteProcessor(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The revision is used to verify the client is working with the latest version of the flow.", required=false) @QueryParam(value="version") LongParameter version, @ApiParam(value="If the client id is not specified, new one will be generated. This value (whether specified or generated) is included in the response.", required=false) @QueryParam(value="clientId") @DefaultValue(value="") ClientIdParameter clientId, @ApiParam(value="Acknowledges that this node is disconnected to allow for mutable requests to proceed.", required=false) @QueryParam(value="disconnectedNodeAcknowledged") @DefaultValue(value="false") Boolean disconnectedNodeAcknowledged, @ApiParam(value="The processor id.", required=true) @PathParam(value="id") String id) throws InterruptedException {
        if (this.isReplicateRequest()) {
            return this.replicate("DELETE");
        }
        if (this.isDisconnectedFromCluster()) {
            this.verifyDisconnectedNodeModification(disconnectedNodeAcknowledged);
        }
        ProcessorEntity requestProcessorEntity = new ProcessorEntity();
        requestProcessorEntity.setId(id);
        Revision requestRevision = new Revision(version == null ? null : version.getLong(), clientId.getClientId(), id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestProcessorEntity, requestRevision, lookup -> {
            ComponentAuthorizable processor = lookup.getProcessor(id);
            processor.getAuthorizable().authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            processor.getAuthorizable().getParentAuthorizable().authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            AuthorizeControllerServiceReference.authorizeControllerServiceReferences((ComponentAuthorizable)processor, (Authorizer)this.authorizer, (AuthorizableLookup)lookup, (boolean)false);
        }, () -> this.serviceFacade.verifyDeleteProcessor(id), (revision, processorEntity) -> {
            ProcessorEntity entity = this.serviceFacade.deleteProcessor(revision, processorEntity.getId());
            return this.generateOkResponse((Object)entity).build();
        });
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }
}

