/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.request;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class BulletinBoardPatternParameter {
    private static final String INVALID_PATTERN_MESSAGE = "Unable to parse pattern '%s'";
    private Pattern patternValue;

    public BulletinBoardPatternParameter(String rawPatternValue) {
        try {
            this.patternValue = Pattern.compile(String.format(".*%s.*", rawPatternValue));
        }
        catch (PatternSyntaxException pse) {
            throw new IllegalArgumentException(String.format(INVALID_PATTERN_MESSAGE, rawPatternValue));
        }
    }

    public Pattern getPattern() {
        return this.patternValue;
    }

    public String getRawPattern() {
        return this.patternValue.pattern();
    }
}

