/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.config;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.apache.nifi.cluster.manager.exception.DisconnectedNodeMutableRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class DisconnectedNodeMutableRequestExceptionMapper
implements ExceptionMapper<DisconnectedNodeMutableRequestException> {
    private static final Logger logger = LoggerFactory.getLogger(DisconnectedNodeMutableRequestExceptionMapper.class);

    public Response toResponse(DisconnectedNodeMutableRequestException ex) {
        logger.info(String.format("Unable to service mutable request because a node is disconnected from the cluster: %s. Returning %s response.", ex, Response.Status.CONFLICT));
        if (logger.isDebugEnabled()) {
            logger.debug("", (Throwable)ex);
        }
        return Response.status((Response.Status)Response.Status.CONFLICT).entity((Object)"Unable to service request because at least one node is disconnected from the cluster.  The flow may be changed when all are connected.").type("text/plain").build();
    }
}

