/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import com.sun.jersey.api.core.ResourceContext;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import com.wordnik.swagger.annotations.Authorization;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.cluster.manager.exception.UnknownNodeException;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.dto.CounterDTO;
import org.apache.nifi.web.api.dto.CountersDTO;
import org.apache.nifi.web.api.entity.ComponentEntity;
import org.apache.nifi.web.api.entity.CounterEntity;
import org.apache.nifi.web.api.entity.CountersEntity;
import org.apache.nifi.web.api.entity.Entity;

@Path(value="/counters")
@Api(value="/counters", description="Endpoint for managing counters.")
public class CountersResource
extends ApplicationResource {
    @Context
    private ResourceContext resourceContext;
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;

    private void authorizeCounters(RequestAction action) {
        this.serviceFacade.authorizeAccess(lookup -> {
            Authorizable counters = lookup.getCounters();
            counters.authorize(this.authorizer, action, NiFiUserUtils.getNiFiUser());
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="")
    @ApiOperation(value="Gets the current counters for this NiFi", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=CountersEntity.class, authorizations={@Authorization(value="Read - /counters", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getCounters(@ApiParam(value="Whether or not to include the breakdown per node. Optional, defaults to false", required=false) @QueryParam(value="nodewise") @DefaultValue(value="false") Boolean nodewise, @ApiParam(value="The id of the node where to get the status.", required=false) @QueryParam(value="clusterNodeId") String clusterNodeId) throws InterruptedException {
        this.authorizeCounters(RequestAction.READ);
        if (Boolean.TRUE.equals(nodewise) && clusterNodeId != null) {
            throw new IllegalArgumentException("Nodewise requests cannot be directed at a specific node.");
        }
        if (this.isReplicateRequest()) {
            if (clusterNodeId == null) {
                NodeResponse nodeResponse = this.getReplicationTarget() == ApplicationResource.ReplicationTarget.CLUSTER_NODES ? this.getRequestReplicator().replicate("GET", this.getAbsolutePath(), (Object)this.getRequestParameters(), this.getHeaders()).awaitMergedResponse() : this.getRequestReplicator().forwardToCoordinator(this.getClusterCoordinatorNode(), "GET", this.getAbsolutePath(), (Object)this.getRequestParameters(), this.getHeaders()).awaitMergedResponse();
                CountersEntity entity = (CountersEntity)nodeResponse.getUpdatedEntity();
                if (entity != null && !nodewise.booleanValue()) {
                    entity.getCounters().setNodeSnapshots(null);
                }
                return nodeResponse.getResponse();
            }
            NodeIdentifier targetNode = this.getClusterCoordinator().getNodeIdentifier(clusterNodeId);
            if (targetNode == null) {
                throw new UnknownNodeException("The specified cluster node does not exist.");
            }
            return this.replicate("GET", targetNode);
        }
        CountersDTO countersReport = this.serviceFacade.getCounters();
        CountersEntity entity = new CountersEntity();
        entity.setCounters(countersReport);
        return this.generateOkResponse((Object)entity).build();
    }

    @PUT
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="{id}")
    @ApiOperation(value="Updates the specified counter. This will reset the counter value to 0", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=CounterEntity.class, authorizations={@Authorization(value="Write - /counters", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response updateCounter(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The id of the counter.") @PathParam(value="id") String id) {
        if (this.isReplicateRequest()) {
            return this.replicate("PUT");
        }
        ComponentEntity requestComponentEntity = new ComponentEntity();
        requestComponentEntity.setId(id);
        return this.withWriteLock(this.serviceFacade, (Entity)requestComponentEntity, lookup -> this.authorizeCounters(RequestAction.WRITE), null, componentEntity -> {
            CounterDTO counter = this.serviceFacade.updateCounter(componentEntity.getId());
            CounterEntity entity = new CounterEntity();
            entity.setCounter(counter);
            return this.generateOkResponse((Object)entity).build();
        });
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }
}

