/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.dao.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.connectable.Position;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.exception.ValidationException;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.remote.RootGroupPort;
import org.apache.nifi.web.NiFiCoreException;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.api.dto.PortDTO;
import org.apache.nifi.web.dao.PortDAO;
import org.apache.nifi.web.dao.impl.ComponentDAO;
import org.apache.nifi.web.dao.impl.StandardOutputPortDAO;

public class StandardOutputPortDAO
extends ComponentDAO
implements PortDAO {
    private FlowController flowController;

    private Port locatePort(String portId) {
        ProcessGroup rootGroup = this.flowController.getGroup(this.flowController.getRootGroupId());
        Port port = rootGroup.findOutputPort(portId);
        if (port == null) {
            throw new ResourceNotFoundException(String.format("Unable to find port with id '%s'.", portId));
        }
        return port;
    }

    public boolean hasPort(String portId) {
        ProcessGroup rootGroup = this.flowController.getGroup(this.flowController.getRootGroupId());
        return rootGroup.findOutputPort(portId) != null;
    }

    public Port createPort(String groupId, PortDTO portDTO) {
        if (this.isNotNull((Object)portDTO.getParentGroupId()) && !this.flowController.areGroupsSame(groupId, portDTO.getParentGroupId())) {
            throw new IllegalArgumentException("Cannot specify a different Parent Group ID than the Group to which the OutputPort is being added.");
        }
        if (portDTO.getName() == null) {
            throw new IllegalArgumentException("Port name must be specified.");
        }
        ProcessGroup group = this.locateProcessGroup(this.flowController, groupId);
        Port port = group.getParent() == null ? this.flowController.createRemoteOutputPort(portDTO.getId(), portDTO.getName()) : this.flowController.createLocalOutputPort(portDTO.getId(), portDTO.getName());
        this.verifyUpdate(port, portDTO);
        if (portDTO.getPosition() != null) {
            port.setPosition(new Position(portDTO.getPosition().getX().doubleValue(), portDTO.getPosition().getY().doubleValue()));
        }
        port.setComments(portDTO.getComments());
        group.addOutputPort(port);
        return port;
    }

    public Port getPort(String portId) {
        return this.locatePort(portId);
    }

    public Set<Port> getPorts(String groupId) {
        ProcessGroup group = this.locateProcessGroup(this.flowController, groupId);
        return group.getOutputPorts();
    }

    public void verifyUpdate(PortDTO portDTO) {
        Port outputPort = this.locatePort(portDTO.getId());
        this.verifyUpdate(outputPort, portDTO);
    }

    private void verifyUpdate(Port outputPort, PortDTO portDTO) {
        ScheduledState purposedScheduledState;
        if (this.isNotNull((Object)portDTO.getState()) && !(purposedScheduledState = ScheduledState.valueOf((String)portDTO.getState())).equals((Object)outputPort.getScheduledState())) {
            switch (1.$SwitchMap$org$apache$nifi$controller$ScheduledState[purposedScheduledState.ordinal()]) {
                case 1: {
                    outputPort.verifyCanStart();
                    break;
                }
                case 3: {
                    switch (1.$SwitchMap$org$apache$nifi$controller$ScheduledState[outputPort.getScheduledState().ordinal()]) {
                        case 1: {
                            outputPort.verifyCanStop();
                            break;
                        }
                        case 2: {
                            outputPort.verifyCanEnable();
                        }
                    }
                    break;
                }
                case 2: {
                    outputPort.verifyCanDisable();
                }
            }
        }
        if (this.isAnyNotNull(new Object[]{portDTO.getUserAccessControl(), portDTO.getGroupAccessControl(), portDTO.getConcurrentlySchedulableTaskCount(), portDTO.getName(), portDTO.getComments()})) {
            List requestValidation = this.validateProposedConfiguration(portDTO);
            if (!requestValidation.isEmpty()) {
                throw new ValidationException(requestValidation);
            }
            outputPort.verifyCanUpdate();
        }
    }

    private List<String> validateProposedConfiguration(PortDTO portDTO) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        if (this.isNotNull((Object)portDTO.getName()) && portDTO.getName().trim().isEmpty()) {
            validationErrors.add("Port name cannot be blank.");
        }
        if (this.isNotNull((Object)portDTO.getConcurrentlySchedulableTaskCount()) && portDTO.getConcurrentlySchedulableTaskCount() <= 0) {
            validationErrors.add("Concurrent tasks must be a positive integer.");
        }
        return validationErrors;
    }

    public Port updatePort(PortDTO portDTO) {
        ScheduledState purposedScheduledState;
        Port outputPort = this.locatePort(portDTO.getId());
        this.verifyUpdate(outputPort, portDTO);
        if (portDTO.getState() != null && !(purposedScheduledState = ScheduledState.valueOf((String)portDTO.getState())).equals((Object)outputPort.getScheduledState())) {
            try {
                block1 : switch (1.$SwitchMap$org$apache$nifi$controller$ScheduledState[purposedScheduledState.ordinal()]) {
                    case 1: {
                        outputPort.getProcessGroup().startOutputPort(outputPort);
                        break;
                    }
                    case 3: {
                        switch (1.$SwitchMap$org$apache$nifi$controller$ScheduledState[outputPort.getScheduledState().ordinal()]) {
                            case 1: {
                                outputPort.getProcessGroup().stopOutputPort(outputPort);
                                break block1;
                            }
                            case 2: {
                                outputPort.getProcessGroup().enableOutputPort(outputPort);
                            }
                        }
                        break;
                    }
                    case 2: {
                        outputPort.getProcessGroup().disableOutputPort(outputPort);
                    }
                }
            }
            catch (IllegalStateException ise) {
                throw new NiFiCoreException(ise.getMessage(), (Throwable)ise);
            }
        }
        if (outputPort instanceof RootGroupPort) {
            RootGroupPort rootPort = (RootGroupPort)outputPort;
            if (this.isNotNull((Object)portDTO.getGroupAccessControl())) {
                rootPort.setGroupAccessControl(portDTO.getGroupAccessControl());
            }
            if (this.isNotNull((Object)portDTO.getUserAccessControl())) {
                rootPort.setUserAccessControl(portDTO.getUserAccessControl());
            }
        }
        String name = portDTO.getName();
        String comments = portDTO.getComments();
        Integer concurrentTasks = portDTO.getConcurrentlySchedulableTaskCount();
        if (this.isNotNull((Object)portDTO.getPosition())) {
            outputPort.setPosition(new Position(portDTO.getPosition().getX().doubleValue(), portDTO.getPosition().getY().doubleValue()));
        }
        if (this.isNotNull((Object)name)) {
            outputPort.setName(name);
        }
        if (this.isNotNull((Object)comments)) {
            outputPort.setComments(comments);
        }
        if (this.isNotNull((Object)concurrentTasks)) {
            outputPort.setMaxConcurrentTasks(concurrentTasks.intValue());
        }
        return outputPort;
    }

    public void verifyDelete(String portId) {
        Port outputPort = this.locatePort(portId);
        outputPort.verifyCanDelete();
    }

    public void deletePort(String portId) {
        Port outputPort = this.locatePort(portId);
        outputPort.getProcessGroup().removeOutputPort(outputPort);
    }

    public void setFlowController(FlowController flowController) {
        this.flowController = flowController;
    }
}

