/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.dao.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.controller.ConfiguredComponent;
import org.apache.nifi.controller.FlowController;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.exception.ControllerServiceInstantiationException;
import org.apache.nifi.controller.exception.ValidationException;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.util.BundleUtils;
import org.apache.nifi.web.NiFiCoreException;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.api.dto.BundleDTO;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.dao.ComponentStateDAO;
import org.apache.nifi.web.dao.ControllerServiceDAO;
import org.apache.nifi.web.dao.impl.ComponentDAO;

public class StandardControllerServiceDAO
extends ComponentDAO
implements ControllerServiceDAO {
    private ControllerServiceProvider serviceProvider;
    private ComponentStateDAO componentStateDAO;
    private FlowController flowController;

    private ControllerServiceNode locateControllerService(String controllerServiceId) {
        ControllerServiceNode controllerService = this.serviceProvider.getControllerServiceNode(controllerServiceId);
        if (controllerService == null) {
            throw new ResourceNotFoundException(String.format("Unable to locate controller service with id '%s'.", controllerServiceId));
        }
        return controllerService;
    }

    public void verifyCreate(ControllerServiceDTO controllerServiceDTO) {
        this.verifyCreate(controllerServiceDTO.getType(), controllerServiceDTO.getBundle());
    }

    public ControllerServiceNode createControllerService(ControllerServiceDTO controllerServiceDTO) {
        if (controllerServiceDTO.getType() == null) {
            throw new IllegalArgumentException("The controller service type must be specified.");
        }
        try {
            ControllerServiceNode controllerService = this.serviceProvider.createControllerService(controllerServiceDTO.getType(), controllerServiceDTO.getId(), BundleUtils.getBundle((String)controllerServiceDTO.getType(), (BundleDTO)controllerServiceDTO.getBundle()), Collections.emptySet(), true);
            this.verifyUpdate(controllerService, controllerServiceDTO);
            this.configureControllerService(controllerService, controllerServiceDTO);
            String groupId = controllerServiceDTO.getParentGroupId();
            if (groupId == null) {
                this.flowController.addRootControllerService(controllerService);
            } else {
                ProcessGroup group = groupId.equals("root") ? this.flowController.getGroup(this.flowController.getRootGroupId()) : this.flowController.getGroup(this.flowController.getRootGroupId()).findProcessGroup(groupId);
                if (group == null) {
                    throw new ResourceNotFoundException(String.format("Unable to locate group with id '%s'.", groupId));
                }
                group.addControllerService(controllerService);
            }
            return controllerService;
        }
        catch (ControllerServiceInstantiationException csie) {
            throw new NiFiCoreException(csie.getMessage(), (Throwable)csie);
        }
    }

    public ControllerServiceNode getControllerService(String controllerServiceId) {
        return this.locateControllerService(controllerServiceId);
    }

    public boolean hasControllerService(String controllerServiceId) {
        return this.serviceProvider.getControllerServiceNode(controllerServiceId) != null;
    }

    public Set<ControllerServiceNode> getControllerServices(String groupId) {
        if (groupId == null) {
            return this.flowController.getRootControllerServices();
        }
        String searchId = groupId.equals("root") ? this.flowController.getRootGroupId() : groupId;
        ProcessGroup procGroup = this.flowController.getGroup(this.flowController.getRootGroupId()).findProcessGroup(searchId);
        if (procGroup == null) {
            throw new ResourceNotFoundException("Could not find Process Group with ID " + groupId);
        }
        return procGroup.getControllerServices(true);
    }

    public ControllerServiceNode updateControllerService(ControllerServiceDTO controllerServiceDTO) {
        ControllerServiceState purposedControllerServiceState;
        ControllerServiceNode controllerService = this.locateControllerService(controllerServiceDTO.getId());
        this.verifyUpdate(controllerService, controllerServiceDTO);
        this.configureControllerService(controllerService, controllerServiceDTO);
        this.updateBundle(controllerService, controllerServiceDTO);
        if (this.isNotNull((Object)controllerServiceDTO.getState()) && !(purposedControllerServiceState = ControllerServiceState.valueOf((String)controllerServiceDTO.getState())).equals((Object)controllerService.getState())) {
            if (ControllerServiceState.ENABLED.equals((Object)purposedControllerServiceState)) {
                this.serviceProvider.enableControllerService(controllerService);
            } else if (ControllerServiceState.DISABLED.equals((Object)purposedControllerServiceState)) {
                this.serviceProvider.disableControllerService(controllerService);
            }
        }
        return controllerService;
    }

    private void updateBundle(ControllerServiceNode controllerService, ControllerServiceDTO controllerServiceDTO) {
        BundleDTO bundleDTO = controllerServiceDTO.getBundle();
        if (bundleDTO != null) {
            BundleCoordinate incomingCoordinate = BundleUtils.getBundle((String)controllerService.getCanonicalClassName(), (BundleDTO)bundleDTO);
            BundleCoordinate existingCoordinate = controllerService.getBundleCoordinate();
            if (!existingCoordinate.getCoordinate().equals(incomingCoordinate.getCoordinate())) {
                try {
                    ConfigurableComponent tempComponent = ExtensionManager.getTempComponent((String)controllerService.getCanonicalClassName(), (BundleCoordinate)incomingCoordinate);
                    Set additionalUrls = controllerService.getAdditionalClasspathResources(tempComponent.getPropertyDescriptors());
                    this.flowController.reload(controllerService, controllerService.getCanonicalClassName(), incomingCoordinate, additionalUrls);
                }
                catch (ControllerServiceInstantiationException e) {
                    throw new NiFiCoreException(String.format("Unable to update controller service %s from %s to %s due to: %s", controllerServiceDTO.getId(), controllerService.getBundleCoordinate().getCoordinate(), incomingCoordinate.getCoordinate(), e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    public Set<ConfiguredComponent> updateControllerServiceReferencingComponents(String controllerServiceId, ScheduledState scheduledState, ControllerServiceState controllerServiceState) {
        ControllerServiceNode controllerService = this.locateControllerService(controllerServiceId);
        if (controllerServiceState != null) {
            if (ControllerServiceState.ENABLED.equals((Object)controllerServiceState)) {
                return this.serviceProvider.enableReferencingServices(controllerService);
            }
            return this.serviceProvider.disableReferencingServices(controllerService);
        }
        if (scheduledState != null) {
            if (ScheduledState.RUNNING.equals((Object)scheduledState)) {
                return this.serviceProvider.scheduleReferencingComponents(controllerService);
            }
            return this.serviceProvider.unscheduleReferencingComponents(controllerService);
        }
        return Collections.emptySet();
    }

    private List<String> validateProposedConfiguration(ControllerServiceNode controllerService, ControllerServiceDTO controllerServiceDTO) {
        ArrayList<String> validationErrors = new ArrayList<String>();
        return validationErrors;
    }

    public void verifyDelete(String controllerServiceId) {
        ControllerServiceNode controllerService = this.locateControllerService(controllerServiceId);
        controllerService.verifyCanDelete();
    }

    public void verifyUpdate(ControllerServiceDTO controllerServiceDTO) {
        ControllerServiceNode controllerService = this.locateControllerService(controllerServiceDTO.getId());
        this.verifyUpdate(controllerService, controllerServiceDTO);
    }

    public void verifyUpdateReferencingComponents(String controllerServiceId, ScheduledState scheduledState, ControllerServiceState controllerServiceState) {
        ControllerServiceNode controllerService = this.locateControllerService(controllerServiceId);
        if (controllerServiceState != null) {
            if (ControllerServiceState.ENABLED.equals((Object)controllerServiceState)) {
                this.serviceProvider.verifyCanEnableReferencingServices(controllerService);
            } else {
                this.serviceProvider.verifyCanDisableReferencingServices(controllerService);
            }
        } else if (scheduledState != null) {
            if (ScheduledState.RUNNING.equals((Object)scheduledState)) {
                this.serviceProvider.verifyCanScheduleReferencingComponents(controllerService);
            } else {
                this.serviceProvider.verifyCanStopReferencingComponents(controllerService);
            }
        }
    }

    private void verifyUpdate(ControllerServiceNode controllerService, ControllerServiceDTO controllerServiceDTO) {
        BundleDTO bundleDTO;
        if (this.isNotNull((Object)controllerServiceDTO.getState())) {
            try {
                ControllerServiceState purposedControllerServiceState = ControllerServiceState.valueOf((String)controllerServiceDTO.getState());
                if (ControllerServiceState.ENABLING.equals((Object)purposedControllerServiceState) || ControllerServiceState.DISABLING.equals((Object)purposedControllerServiceState)) {
                    throw new IllegalArgumentException();
                }
                if (!purposedControllerServiceState.equals((Object)controllerService.getState())) {
                    if (ControllerServiceState.ENABLED.equals((Object)purposedControllerServiceState)) {
                        controllerService.verifyCanEnable();
                    } else if (ControllerServiceState.DISABLED.equals((Object)purposedControllerServiceState)) {
                        controllerService.verifyCanDisable();
                    }
                }
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("Controller Service state: Value must be one of [ENABLED, DISABLED]");
            }
        }
        boolean modificationRequest = false;
        if (this.isAnyNotNull(new Object[]{controllerServiceDTO.getName(), controllerServiceDTO.getAnnotationData(), controllerServiceDTO.getComments(), controllerServiceDTO.getProperties(), controllerServiceDTO.getBundle()})) {
            modificationRequest = true;
            List requestValidation = this.validateProposedConfiguration(controllerService, controllerServiceDTO);
            if (!requestValidation.isEmpty()) {
                throw new ValidationException(requestValidation);
            }
        }
        if ((bundleDTO = controllerServiceDTO.getBundle()) != null) {
            BundleCoordinate bundleCoordinate = BundleUtils.getBundle((String)controllerService.getCanonicalClassName(), (BundleDTO)bundleDTO);
            controllerService.verifyCanUpdateBundle(bundleCoordinate);
        }
        if (modificationRequest) {
            controllerService.verifyCanUpdate();
        }
    }

    private void configureControllerService(ControllerServiceNode controllerService, ControllerServiceDTO controllerServiceDTO) {
        String name = controllerServiceDTO.getName();
        String annotationData = controllerServiceDTO.getAnnotationData();
        String comments = controllerServiceDTO.getComments();
        Map properties = controllerServiceDTO.getProperties();
        if (this.isNotNull((Object)name)) {
            controllerService.setName(name);
        }
        if (this.isNotNull((Object)annotationData)) {
            controllerService.setAnnotationData(annotationData);
        }
        if (this.isNotNull((Object)comments)) {
            controllerService.setComments(comments);
        }
        if (this.isNotNull((Object)properties)) {
            controllerService.setProperties(properties);
        }
    }

    public void deleteControllerService(String controllerServiceId) {
        ControllerServiceNode controllerService = this.locateControllerService(controllerServiceId);
        this.serviceProvider.removeControllerService(controllerService);
    }

    public StateMap getState(String controllerServiceId, Scope scope) {
        ControllerServiceNode controllerService = this.locateControllerService(controllerServiceId);
        return this.componentStateDAO.getState(controllerService, scope);
    }

    public void verifyClearState(String controllerServiceId) {
        ControllerServiceNode controllerService = this.locateControllerService(controllerServiceId);
        controllerService.verifyCanClearState();
    }

    public void clearState(String controllerServiceId) {
        ControllerServiceNode controllerService = this.locateControllerService(controllerServiceId);
        this.componentStateDAO.clearState(controllerService);
    }

    public void setServiceProvider(ControllerServiceProvider serviceProvider) {
        this.serviceProvider = serviceProvider;
    }

    public void setComponentStateDAO(ComponentStateDAO componentStateDAO) {
        this.componentStateDAO = componentStateDAO;
    }

    public void setFlowController(FlowController flowController) {
        this.flowController = flowController;
    }
}

