/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api;

import com.sun.jersey.api.core.ResourceContext;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import com.wordnik.swagger.annotations.Authorization;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.AccessDeniedException;
import org.apache.nifi.authorization.AuthorizationRequest;
import org.apache.nifi.authorization.AuthorizationResult;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.UserContextKeys;
import org.apache.nifi.authorization.resource.Authorizable;
import org.apache.nifi.authorization.resource.ResourceFactory;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.bundle.Bundle;
import org.apache.nifi.bundle.BundleDetails;
import org.apache.nifi.cluster.coordination.ClusterCoordinator;
import org.apache.nifi.cluster.coordination.node.NodeConnectionState;
import org.apache.nifi.cluster.manager.NodeResponse;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.nar.NarClassLoaders;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.web.IllegalClusterResourceRequestException;
import org.apache.nifi.web.NiFiServiceFacade;
import org.apache.nifi.web.ResourceNotFoundException;
import org.apache.nifi.web.Revision;
import org.apache.nifi.web.api.ApplicationResource;
import org.apache.nifi.web.api.ConnectionResource;
import org.apache.nifi.web.api.ControllerServiceResource;
import org.apache.nifi.web.api.FunnelResource;
import org.apache.nifi.web.api.InputPortResource;
import org.apache.nifi.web.api.LabelResource;
import org.apache.nifi.web.api.OutputPortResource;
import org.apache.nifi.web.api.ProcessGroupResource;
import org.apache.nifi.web.api.ProcessorResource;
import org.apache.nifi.web.api.RemoteProcessGroupResource;
import org.apache.nifi.web.api.ReportingTaskResource;
import org.apache.nifi.web.api.TemplateResource;
import org.apache.nifi.web.api.dto.AboutDTO;
import org.apache.nifi.web.api.dto.BannerDTO;
import org.apache.nifi.web.api.dto.BulletinBoardDTO;
import org.apache.nifi.web.api.dto.BulletinQueryDTO;
import org.apache.nifi.web.api.dto.ClusterDTO;
import org.apache.nifi.web.api.dto.ClusterSummaryDTO;
import org.apache.nifi.web.api.dto.NodeDTO;
import org.apache.nifi.web.api.dto.ProcessGroupDTO;
import org.apache.nifi.web.api.dto.RevisionDTO;
import org.apache.nifi.web.api.dto.action.HistoryDTO;
import org.apache.nifi.web.api.dto.action.HistoryQueryDTO;
import org.apache.nifi.web.api.dto.flow.FlowDTO;
import org.apache.nifi.web.api.dto.flow.ProcessGroupFlowDTO;
import org.apache.nifi.web.api.dto.search.NodeSearchResultDTO;
import org.apache.nifi.web.api.dto.search.SearchResultsDTO;
import org.apache.nifi.web.api.dto.status.ControllerStatusDTO;
import org.apache.nifi.web.api.entity.AboutEntity;
import org.apache.nifi.web.api.entity.ActionEntity;
import org.apache.nifi.web.api.entity.BannerEntity;
import org.apache.nifi.web.api.entity.BulletinBoardEntity;
import org.apache.nifi.web.api.entity.ClusteSummaryEntity;
import org.apache.nifi.web.api.entity.ClusterSearchResultsEntity;
import org.apache.nifi.web.api.entity.ComponentHistoryEntity;
import org.apache.nifi.web.api.entity.ConnectionStatusEntity;
import org.apache.nifi.web.api.entity.ControllerBulletinsEntity;
import org.apache.nifi.web.api.entity.ControllerServiceTypesEntity;
import org.apache.nifi.web.api.entity.ControllerServicesEntity;
import org.apache.nifi.web.api.entity.ControllerStatusEntity;
import org.apache.nifi.web.api.entity.CurrentUserEntity;
import org.apache.nifi.web.api.entity.Entity;
import org.apache.nifi.web.api.entity.FlowConfigurationEntity;
import org.apache.nifi.web.api.entity.HistoryEntity;
import org.apache.nifi.web.api.entity.PortStatusEntity;
import org.apache.nifi.web.api.entity.PrioritizerTypesEntity;
import org.apache.nifi.web.api.entity.ProcessGroupEntity;
import org.apache.nifi.web.api.entity.ProcessGroupFlowEntity;
import org.apache.nifi.web.api.entity.ProcessGroupStatusEntity;
import org.apache.nifi.web.api.entity.ProcessorStatusEntity;
import org.apache.nifi.web.api.entity.ProcessorTypesEntity;
import org.apache.nifi.web.api.entity.RemoteProcessGroupStatusEntity;
import org.apache.nifi.web.api.entity.ReportingTaskTypesEntity;
import org.apache.nifi.web.api.entity.ReportingTasksEntity;
import org.apache.nifi.web.api.entity.ScheduleComponentsEntity;
import org.apache.nifi.web.api.entity.SearchResultsEntity;
import org.apache.nifi.web.api.entity.StatusHistoryEntity;
import org.apache.nifi.web.api.entity.TemplatesEntity;
import org.apache.nifi.web.api.request.BulletinBoardPatternParameter;
import org.apache.nifi.web.api.request.DateTimeParameter;
import org.apache.nifi.web.api.request.IntegerParameter;
import org.apache.nifi.web.api.request.LongParameter;

@Path(value="/flow")
@Api(value="/flow", description="Endpoint for accessing the flow structure and component status.")
public class FlowResource
extends ApplicationResource {
    private static final String RECURSIVE = "false";
    private NiFiServiceFacade serviceFacade;
    private Authorizer authorizer;
    @Context
    private ResourceContext resourceContext;
    private ProcessorResource processorResource;
    private InputPortResource inputPortResource;
    private OutputPortResource outputPortResource;
    private FunnelResource funnelResource;
    private LabelResource labelResource;
    private RemoteProcessGroupResource remoteProcessGroupResource;
    private ConnectionResource connectionResource;
    private TemplateResource templateResource;
    private ProcessGroupResource processGroupResource;
    private ControllerServiceResource controllerServiceResource;
    private ReportingTaskResource reportingTaskResource;

    private ProcessGroupFlowDTO populateRemainingFlowContent(ProcessGroupFlowDTO flow) {
        FlowDTO flowStructure = flow.getFlow();
        if (flowStructure != null) {
            this.populateRemainingFlowStructure(flowStructure);
        }
        flow.setUri(this.generateResourceUri(new String[]{"flow", "process-groups", flow.getId()}));
        return flow;
    }

    private FlowDTO populateRemainingFlowStructure(FlowDTO flowStructure) {
        this.processorResource.populateRemainingProcessorEntitiesContent(flowStructure.getProcessors());
        this.connectionResource.populateRemainingConnectionEntitiesContent(flowStructure.getConnections());
        this.inputPortResource.populateRemainingInputPortEntitiesContent(flowStructure.getInputPorts());
        this.outputPortResource.populateRemainingOutputPortEntitiesContent(flowStructure.getOutputPorts());
        this.remoteProcessGroupResource.populateRemainingRemoteProcessGroupEntitiesContent(flowStructure.getRemoteProcessGroups());
        this.funnelResource.populateRemainingFunnelEntitiesContent(flowStructure.getFunnels());
        this.labelResource.populateRemainingLabelEntitiesContent(flowStructure.getLabels());
        this.processGroupResource.populateRemainingProcessGroupEntitiesContent(flowStructure.getProcessGroups());
        for (ProcessGroupEntity processGroupEntity : flowStructure.getProcessGroups()) {
            ProcessGroupDTO processGroup = processGroupEntity.getComponent();
            if (processGroup == null) continue;
            processGroup.setContents(null);
        }
        return flowStructure;
    }

    private void authorizeFlow() {
        HashMap<String, String> userContext;
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (!StringUtils.isBlank((CharSequence)user.getClientAddress())) {
            userContext = new HashMap<String, String>();
            userContext.put(UserContextKeys.CLIENT_ADDRESS.name(), user.getClientAddress());
        } else {
            userContext = null;
        }
        AuthorizationRequest request = new AuthorizationRequest.Builder().resource(ResourceFactory.getFlowResource()).identity(user.getIdentity()).anonymous(Boolean.valueOf(user.isAnonymous())).accessAttempt(Boolean.valueOf(true)).action(RequestAction.READ).userContext(userContext).explanationSupplier(() -> "Unable to view the user interface.").build();
        AuthorizationResult result = this.authorizer.authorize(request);
        if (!AuthorizationResult.Result.Approved.equals((Object)result.getResult())) {
            throw new AccessDeniedException(result.getExplanation());
        }
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"text/plain"})
    @Path(value="client-id")
    @ApiOperation(value="Generates a client id.", response=String.class, authorizations={@Authorization(value="Read - /flow", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response generateClientId() {
        this.authorizeFlow();
        return this.clusterContext(this.generateOkResponse((Object)this.generateUuid())).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="config")
    @ApiOperation(value="Retrieves the configuration for this NiFi flow", response=FlowConfigurationEntity.class, authorizations={@Authorization(value="Read - /flow", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getFlowConfig() {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        FlowConfigurationEntity entity = this.serviceFacade.getFlowConfiguration();
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="current-user")
    @ApiOperation(value="Retrieves the user identity of the user making the request", response=CurrentUserEntity.class, authorizations={@Authorization(value="Read - /flow", type="")})
    public Response getCurrentUser() {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user == null) {
            throw new WebApplicationException(new Throwable("Unable to access details for current user."));
        }
        CurrentUserEntity entity = this.serviceFacade.getCurrentUser();
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="process-groups/{id}")
    @ApiOperation(value="Gets a process group", response=ProcessGroupFlowEntity.class, authorizations={@Authorization(value="Read - /flow", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getFlow(@ApiParam(value="The process group id.", required=false) @PathParam(value="id") String groupId) throws InterruptedException {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        ProcessGroupFlowEntity entity = this.serviceFacade.getProcessGroupFlow(groupId);
        this.populateRemainingFlowContent(entity.getProcessGroupFlow());
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="controller/controller-services")
    @ApiOperation(value="Gets all controller services", response=ControllerServicesEntity.class, authorizations={@Authorization(value="Read - /flow", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getControllerServicesFromController() {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        Set controllerServices = this.serviceFacade.getControllerServices(null);
        this.controllerServiceResource.populateRemainingControllerServiceEntitiesContent(controllerServices);
        ControllerServicesEntity entity = new ControllerServicesEntity();
        entity.setCurrentTime(new Date());
        entity.setControllerServices(controllerServices);
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="process-groups/{id}/controller-services")
    @ApiOperation(value="Gets all controller services", response=ControllerServicesEntity.class, authorizations={@Authorization(value="Read - /flow", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getControllerServicesFromGroup(@ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId) throws InterruptedException {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        Set controllerServices = this.serviceFacade.getControllerServices(groupId);
        this.controllerServiceResource.populateRemainingControllerServiceEntitiesContent(controllerServices);
        ControllerServicesEntity entity = new ControllerServicesEntity();
        entity.setCurrentTime(new Date());
        entity.setControllerServices(controllerServices);
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="reporting-tasks")
    @ApiOperation(value="Gets all reporting tasks", response=ReportingTasksEntity.class, authorizations={@Authorization(value="Read - /flow", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getReportingTasks() {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        Set reportingTasks = this.serviceFacade.getReportingTasks();
        this.reportingTaskResource.populateRemainingReportingTaskEntitiesContent(reportingTasks);
        ReportingTasksEntity entity = new ReportingTasksEntity();
        entity.setReportingTasks(reportingTasks);
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Path(value="process-groups/{id}")
    @ApiOperation(value="Schedule or unschedule comopnents in the specified Process Group.", notes="", response=ScheduleComponentsEntity.class, authorizations={@Authorization(value="Read - /flow", type=""), @Authorization(value="Write - /{component-type}/{uuid} - For every component being scheduled/unscheduled", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response scheduleComponents(@Context HttpServletRequest httpServletRequest, @ApiParam(value="The process group id.", required=true) @PathParam(value="id") String id, @ApiParam(value="The request to schedule or unschedule. If the comopnents in the request are not specified, all authorized components will be considered.", required=true) ScheduleComponentsEntity requestScheduleComponentsEntity) {
        ScheduledState state;
        if (!id.equals(requestScheduleComponentsEntity.getId())) {
            throw new IllegalArgumentException(String.format("The process group id (%s) in the request body does not equal the process group id of the requested resource (%s).", requestScheduleComponentsEntity.getId(), id));
        }
        if (requestScheduleComponentsEntity.getState() == null) {
            throw new IllegalArgumentException("The scheduled state must be specified.");
        }
        try {
            state = ScheduledState.valueOf((String)requestScheduleComponentsEntity.getState());
        }
        catch (IllegalArgumentException iae) {
            throw new IllegalArgumentException(String.format("The scheduled must be one of [%s].", StringUtils.join(EnumSet.of(ScheduledState.RUNNING, ScheduledState.STOPPED), (String)", ")));
        }
        if (ScheduledState.DISABLED.equals((Object)state) || ScheduledState.STARTING.equals((Object)state) || ScheduledState.STOPPING.equals((Object)state)) {
            throw new IllegalArgumentException(String.format("The scheduled must be one of [%s].", StringUtils.join(EnumSet.of(ScheduledState.RUNNING, ScheduledState.STOPPED), (String)", ")));
        }
        if (requestScheduleComponentsEntity.getComponents() == null) {
            Set revisions2 = this.serviceFacade.getRevisionsFromGroup(id, group -> {
                HashSet componentIds = new HashSet();
                group.findAllProcessors().stream().filter(ScheduledState.RUNNING.equals((Object)state) ? ProcessGroup.SCHEDULABLE_PROCESSORS : ProcessGroup.UNSCHEDULABLE_PROCESSORS).filter(processor -> processor.isAuthorized(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser())).forEach(processor -> componentIds.add(processor.getIdentifier()));
                group.findAllInputPorts().stream().filter(ScheduledState.RUNNING.equals((Object)state) ? ProcessGroup.SCHEDULABLE_PORTS : ProcessGroup.UNSCHEDULABLE_PORTS).filter(inputPort -> inputPort.isAuthorized(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser())).forEach(inputPort -> componentIds.add(inputPort.getIdentifier()));
                group.findAllOutputPorts().stream().filter(ScheduledState.RUNNING.equals((Object)state) ? ProcessGroup.SCHEDULABLE_PORTS : ProcessGroup.UNSCHEDULABLE_PORTS).filter(outputPort -> outputPort.isAuthorized(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser())).forEach(outputPort -> componentIds.add(outputPort.getIdentifier()));
                return componentIds;
            });
            HashMap componentsToSchedule = new HashMap();
            revisions2.forEach(revision -> {
                RevisionDTO dto = new RevisionDTO();
                dto.setClientId(revision.getClientId());
                dto.setVersion(revision.getVersion());
                componentsToSchedule.put(revision.getComponentId(), dto);
            });
            requestScheduleComponentsEntity.setComponents(componentsToSchedule);
        }
        if (this.isReplicateRequest()) {
            return this.replicate("PUT", (Object)requestScheduleComponentsEntity);
        }
        Map requestComponentsToSchedule = requestScheduleComponentsEntity.getComponents();
        Map<String, Revision> requestComponentRevisions = requestComponentsToSchedule.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.getRevision((RevisionDTO)e.getValue(), (String)e.getKey())));
        HashSet<Revision> requestRevisions = new HashSet<Revision>(requestComponentRevisions.values());
        return this.withWriteLock(this.serviceFacade, (Entity)requestScheduleComponentsEntity, requestRevisions, lookup -> {
            this.authorizeFlow();
            requestComponentsToSchedule.keySet().forEach(componentId -> {
                Authorizable connectable = lookup.getLocalConnectable(componentId);
                connectable.authorize(this.authorizer, RequestAction.WRITE, NiFiUserUtils.getNiFiUser());
            });
        }, () -> this.serviceFacade.verifyScheduleComponents(id, state, requestComponentRevisions.keySet()), (revisions, scheduleComponentsEntity) -> {
            ScheduledState scheduledState = ScheduledState.valueOf((String)scheduleComponentsEntity.getState());
            Map componentsToSchedule = scheduleComponentsEntity.getComponents();
            Map<String, Revision> componentRevisions = componentsToSchedule.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.getRevision((RevisionDTO)e.getValue(), (String)e.getKey())));
            ScheduleComponentsEntity entity = this.serviceFacade.scheduleComponents(id, scheduledState, componentRevisions);
            return this.clusterContext(this.generateOkResponse((Object)entity)).build();
        });
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="search-results")
    @ApiOperation(value="Performs a search against this NiFi using the specified search term", notes="Only search results from authorized components will be returned.", response=SearchResultsEntity.class, authorizations={@Authorization(value="Read - /flow", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response searchFlow(@QueryParam(value="q") @DefaultValue(value="") String value) throws InterruptedException {
        this.authorizeFlow();
        SearchResultsDTO results = this.serviceFacade.searchController(value);
        SearchResultsEntity entity = new SearchResultsEntity();
        entity.setSearchResultsDTO(results);
        return this.clusterContext(this.noCache(Response.ok((Object)entity))).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="status")
    @ApiOperation(value="Gets the current status of this NiFi", response=ControllerStatusEntity.class, authorizations={@Authorization(value="Read - /flow", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getControllerStatus() throws InterruptedException {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        ControllerStatusDTO controllerStatus = this.serviceFacade.getControllerStatus();
        ControllerStatusEntity entity = new ControllerStatusEntity();
        entity.setControllerStatus(controllerStatus);
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="cluster/summary")
    @ApiOperation(value="The cluster summary for this NiFi", response=ClusteSummaryEntity.class, authorizations={@Authorization(value="Read - /flow", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getClusterSummary() throws InterruptedException {
        this.authorizeFlow();
        ClusterSummaryDTO clusterConfiguration = new ClusterSummaryDTO();
        ClusterCoordinator clusterCoordinator = this.getClusterCoordinator();
        if (clusterCoordinator != null && clusterCoordinator.isConnected()) {
            Map stateMap = clusterCoordinator.getConnectionStates();
            int totalNodeCount = 0;
            for (List nodeList : stateMap.values()) {
                totalNodeCount += nodeList.size();
            }
            List connectedNodeIds = (List)stateMap.get(NodeConnectionState.CONNECTED);
            int connectedNodeCount = connectedNodeIds == null ? 0 : connectedNodeIds.size();
            clusterConfiguration.setConnectedNodeCount(Integer.valueOf(connectedNodeCount));
            clusterConfiguration.setTotalNodeCount(Integer.valueOf(totalNodeCount));
            clusterConfiguration.setConnectedNodes(connectedNodeCount + " / " + totalNodeCount);
        }
        clusterConfiguration.setClustered(Boolean.valueOf(this.isClustered()));
        clusterConfiguration.setConnectedToCluster(Boolean.valueOf(this.isConnectedToCluster()));
        ClusteSummaryEntity entity = new ClusteSummaryEntity();
        entity.setClusterSummary(clusterConfiguration);
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="controller/bulletins")
    @ApiOperation(value="Retrieves Controller level bulletins", response=ControllerBulletinsEntity.class, authorizations={@Authorization(value="Read - /flow", type=""), @Authorization(value="Read - /controller - For controller bulletins", type=""), @Authorization(value="Read - /controller-services/{uuid} - For controller service bulletins", type=""), @Authorization(value="Read - /reporting-tasks/{uuid} - For reporting task bulletins", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getBulletins() {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        ControllerBulletinsEntity entity = this.serviceFacade.getControllerBulletins();
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="banners")
    @ApiOperation(value="Retrieves the banners for this NiFi", response=BannerEntity.class, authorizations={@Authorization(value="Read - /flow", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getBanners() {
        this.authorizeFlow();
        String bannerText = this.getProperties().getBannerText();
        BannerDTO bannerDTO = new BannerDTO();
        bannerDTO.setHeaderText(bannerText);
        bannerDTO.setFooterText(bannerText);
        BannerEntity entity = new BannerEntity();
        entity.setBanners(bannerDTO);
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="processor-types")
    @ApiOperation(value="Retrieves the types of processors that this NiFi supports", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=ProcessorTypesEntity.class, authorizations={@Authorization(value="Read - /flow", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getProcessorTypes(@ApiParam(value="If specified, will only return types that are a member of this bundle group.", required=false) @QueryParam(value="bundleGroupFilter") String bundleGroupFilter, @ApiParam(value="If specified, will only return types that are a member of this bundle artifact.", required=false) @QueryParam(value="bundleArtifactFilter") String bundleArtifactFilter, @ApiParam(value="If specified, will only return types whose fully qualified classname matches.", required=false) @QueryParam(value="type") String typeFilter) throws InterruptedException {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        ProcessorTypesEntity entity = new ProcessorTypesEntity();
        entity.setProcessorTypes(this.serviceFacade.getProcessorTypes(bundleGroupFilter, bundleArtifactFilter, typeFilter));
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="controller-service-types")
    @ApiOperation(value="Retrieves the types of controller services that this NiFi supports", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=ControllerServiceTypesEntity.class, authorizations={@Authorization(value="Read - /flow", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getControllerServiceTypes(@ApiParam(value="If specified, will only return controller services that are compatible with this type of service.", required=false) @QueryParam(value="serviceType") String serviceType, @ApiParam(value="If serviceType specified, is the bundle group of the serviceType.", required=false) @QueryParam(value="serviceBundleGroup") String serviceBundleGroup, @ApiParam(value="If serviceType specified, is the bundle artifact of the serviceType.", required=false) @QueryParam(value="serviceBundleArtifact") String serviceBundleArtifact, @ApiParam(value="If serviceType specified, is the bundle version of the serviceType.", required=false) @QueryParam(value="serviceBundleVersion") String serviceBundleVersion, @ApiParam(value="If specified, will only return types that are a member of this bundle group.", required=false) @QueryParam(value="bundleGroupFilter") String bundleGroupFilter, @ApiParam(value="If specified, will only return types that are a member of this bundle artifact.", required=false) @QueryParam(value="bundleArtifactFilter") String bundleArtifactFilter, @ApiParam(value="If specified, will only return types whose fully qualified classname matches.", required=false) @QueryParam(value="typeFilter") String typeFilter) throws InterruptedException {
        this.authorizeFlow();
        if (serviceType != null && (serviceBundleGroup == null || serviceBundleArtifact == null || serviceBundleVersion == null)) {
            throw new IllegalArgumentException("When specifying the serviceType the serviceBundleGroup, serviceBundleArtifact, and serviceBundleVersion must be specified.");
        }
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        ControllerServiceTypesEntity entity = new ControllerServiceTypesEntity();
        entity.setControllerServiceTypes(this.serviceFacade.getControllerServiceTypes(serviceType, serviceBundleGroup, serviceBundleArtifact, serviceBundleVersion, bundleGroupFilter, bundleArtifactFilter, typeFilter));
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="reporting-task-types")
    @ApiOperation(value="Retrieves the types of reporting tasks that this NiFi supports", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=ReportingTaskTypesEntity.class, authorizations={@Authorization(value="Read - /flow", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getReportingTaskTypes(@ApiParam(value="If specified, will only return types that are a member of this bundle group.", required=false) @QueryParam(value="bundleGroupFilter") String bundleGroupFilter, @ApiParam(value="If specified, will only return types that are a member of this bundle artifact.", required=false) @QueryParam(value="bundleArtifactFilter") String bundleArtifactFilter, @ApiParam(value="If specified, will only return types whose fully qualified classname matches.", required=false) @QueryParam(value="type") String typeFilter) throws InterruptedException {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        ReportingTaskTypesEntity entity = new ReportingTaskTypesEntity();
        entity.setReportingTaskTypes(this.serviceFacade.getReportingTaskTypes(bundleGroupFilter, bundleArtifactFilter, typeFilter));
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="prioritizers")
    @ApiOperation(value="Retrieves the types of prioritizers that this NiFi supports", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=PrioritizerTypesEntity.class, authorizations={@Authorization(value="Read - /flow", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getPrioritizers() throws InterruptedException {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        PrioritizerTypesEntity entity = new PrioritizerTypesEntity();
        entity.setPrioritizerTypes(this.serviceFacade.getWorkQueuePrioritizerTypes());
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="about")
    @ApiOperation(value="Retrieves details about this NiFi to put in the About dialog", response=AboutEntity.class, authorizations={@Authorization(value="Read - /flow", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getAboutInfo() {
        this.authorizeFlow();
        AboutDTO aboutDTO = new AboutDTO();
        aboutDTO.setTitle("NiFi");
        aboutDTO.setUri(this.generateResourceUri(new String[0]));
        aboutDTO.setTimezone(new Date());
        NiFiProperties properties = this.getProperties();
        aboutDTO.setContentViewerUrl(properties.getProperty("nifi.content.viewer.url"));
        Bundle frameworkBundle = NarClassLoaders.getInstance().getFrameworkBundle();
        if (frameworkBundle != null) {
            BundleDetails frameworkDetails = frameworkBundle.getBundleDetails();
            aboutDTO.setVersion(frameworkDetails.getCoordinate().getVersion());
            aboutDTO.setBuildTag(frameworkDetails.getBuildTag());
            aboutDTO.setBuildRevision(frameworkDetails.getBuildRevision());
            aboutDTO.setBuildBranch(frameworkDetails.getBuildBranch());
            aboutDTO.setBuildTimestamp(frameworkDetails.getBuildTimestampDate());
        }
        AboutEntity entity = new AboutEntity();
        entity.setAbout(aboutDTO);
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="bulletin-board")
    @ApiOperation(value="Gets current bulletins", response=BulletinBoardEntity.class, authorizations={@Authorization(value="Read - /flow", type=""), @Authorization(value="Read - /{component-type}/{uuid} - For component specific bulletins", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getBulletinBoard(@ApiParam(value="Includes bulletins with an id after this value.", required=false) @QueryParam(value="after") LongParameter after, @ApiParam(value="Includes bulletins originating from this sources whose name match this regular expression.", required=false) @QueryParam(value="sourceName") BulletinBoardPatternParameter sourceName, @ApiParam(value="Includes bulletins whose message that match this regular expression.", required=false) @QueryParam(value="message") BulletinBoardPatternParameter message, @ApiParam(value="Includes bulletins originating from this sources whose id match this regular expression.", required=false) @QueryParam(value="sourceId") BulletinBoardPatternParameter sourceId, @ApiParam(value="Includes bulletins originating from this sources whose group id match this regular expression.", required=false) @QueryParam(value="groupId") BulletinBoardPatternParameter groupId, @ApiParam(value="The number of bulletins to limit the response to.", required=false) @QueryParam(value="limit") IntegerParameter limit) throws InterruptedException {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        BulletinQueryDTO query = new BulletinQueryDTO();
        if (sourceId != null) {
            query.setSourceId(sourceId.getRawPattern());
        }
        if (groupId != null) {
            query.setGroupId(groupId.getRawPattern());
        }
        if (sourceName != null) {
            query.setName(sourceName.getRawPattern());
        }
        if (message != null) {
            query.setMessage(message.getRawPattern());
        }
        if (after != null) {
            query.setAfter(after.getLong());
        }
        if (limit != null) {
            query.setLimit(limit.getInteger());
        }
        BulletinBoardDTO bulletinBoard = this.serviceFacade.getBulletinBoard(query);
        BulletinBoardEntity entity = new BulletinBoardEntity();
        entity.setBulletinBoard(bulletinBoard);
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="processors/{id}/status")
    @ApiOperation(value="Gets status for a processor", response=ProcessorStatusEntity.class, authorizations={@Authorization(value="Read - /flow", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getProcessorStatus(@ApiParam(value="Whether or not to include the breakdown per node. Optional, defaults to false", required=false) @QueryParam(value="nodewise") @DefaultValue(value="false") Boolean nodewise, @ApiParam(value="The id of the node where to get the status.", required=false) @QueryParam(value="clusterNodeId") String clusterNodeId, @ApiParam(value="The processor id.", required=true) @PathParam(value="id") String id) throws InterruptedException {
        this.authorizeFlow();
        if (Boolean.TRUE.equals(nodewise) && clusterNodeId != null) {
            throw new IllegalArgumentException("Nodewise requests cannot be directed at a specific node.");
        }
        if (this.isReplicateRequest()) {
            if (clusterNodeId == null) {
                NodeResponse nodeResponse = this.replicateNodeResponse("GET");
                ProcessorStatusEntity entity = (ProcessorStatusEntity)nodeResponse.getUpdatedEntity();
                if (entity != null && !nodewise.booleanValue()) {
                    entity.getProcessorStatus().setNodeSnapshots(null);
                }
                return nodeResponse.getResponse();
            }
            return this.replicate("GET", clusterNodeId);
        }
        ProcessorStatusEntity entity = this.serviceFacade.getProcessorStatus(id);
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="input-ports/{id}/status")
    @ApiOperation(value="Gets status for an input port", response=PortStatusEntity.class, authorizations={@Authorization(value="Read - /flow", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getInputPortStatus(@ApiParam(value="Whether or not to include the breakdown per node. Optional, defaults to false", required=false) @QueryParam(value="nodewise") @DefaultValue(value="false") Boolean nodewise, @ApiParam(value="The id of the node where to get the status.", required=false) @QueryParam(value="clusterNodeId") String clusterNodeId, @ApiParam(value="The input port id.", required=true) @PathParam(value="id") String id) throws InterruptedException {
        this.authorizeFlow();
        if (Boolean.TRUE.equals(nodewise) && clusterNodeId != null) {
            throw new IllegalArgumentException("Nodewise requests cannot be directed at a specific node.");
        }
        if (this.isReplicateRequest()) {
            if (clusterNodeId == null) {
                NodeResponse nodeResponse = this.replicateNodeResponse("GET");
                PortStatusEntity entity = (PortStatusEntity)nodeResponse.getUpdatedEntity();
                if (entity != null && !nodewise.booleanValue()) {
                    entity.getPortStatus().setNodeSnapshots(null);
                }
                return nodeResponse.getResponse();
            }
            return this.replicate("GET", clusterNodeId);
        }
        PortStatusEntity entity = this.serviceFacade.getInputPortStatus(id);
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="output-ports/{id}/status")
    @ApiOperation(value="Gets status for an output port", response=PortStatusEntity.class, authorizations={@Authorization(value="Read - /flow", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getOutputPortStatus(@ApiParam(value="Whether or not to include the breakdown per node. Optional, defaults to false", required=false) @QueryParam(value="nodewise") @DefaultValue(value="false") Boolean nodewise, @ApiParam(value="The id of the node where to get the status.", required=false) @QueryParam(value="clusterNodeId") String clusterNodeId, @ApiParam(value="The output port id.", required=true) @PathParam(value="id") String id) throws InterruptedException {
        this.authorizeFlow();
        if (Boolean.TRUE.equals(nodewise) && clusterNodeId != null) {
            throw new IllegalArgumentException("Nodewise requests cannot be directed at a specific node.");
        }
        if (this.isReplicateRequest()) {
            if (clusterNodeId == null) {
                NodeResponse nodeResponse = this.replicateNodeResponse("GET");
                PortStatusEntity entity = (PortStatusEntity)nodeResponse.getUpdatedEntity();
                if (entity != null && !nodewise.booleanValue()) {
                    entity.getPortStatus().setNodeSnapshots(null);
                }
                return nodeResponse.getResponse();
            }
            return this.replicate("GET", clusterNodeId);
        }
        PortStatusEntity entity = this.serviceFacade.getOutputPortStatus(id);
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="remote-process-groups/{id}/status")
    @ApiOperation(value="Gets status for a remote process group", response=ProcessorStatusEntity.class, authorizations={@Authorization(value="Read - /flow", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getRemoteProcessGroupStatus(@ApiParam(value="Whether or not to include the breakdown per node. Optional, defaults to false", required=false) @QueryParam(value="nodewise") @DefaultValue(value="false") Boolean nodewise, @ApiParam(value="The id of the node where to get the status.", required=false) @QueryParam(value="clusterNodeId") String clusterNodeId, @ApiParam(value="The remote process group id.", required=true) @PathParam(value="id") String id) throws InterruptedException {
        this.authorizeFlow();
        if (Boolean.TRUE.equals(nodewise) && clusterNodeId != null) {
            throw new IllegalArgumentException("Nodewise requests cannot be directed at a specific node.");
        }
        if (this.isReplicateRequest()) {
            if (clusterNodeId == null) {
                NodeResponse nodeResponse = this.replicateNodeResponse("GET");
                RemoteProcessGroupStatusEntity entity = (RemoteProcessGroupStatusEntity)nodeResponse.getUpdatedEntity();
                if (entity != null && !nodewise.booleanValue()) {
                    entity.getRemoteProcessGroupStatus().setNodeSnapshots(null);
                }
                return nodeResponse.getResponse();
            }
            return this.replicate("GET", clusterNodeId);
        }
        RemoteProcessGroupStatusEntity entity = this.serviceFacade.getRemoteProcessGroupStatus(id);
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="process-groups/{id}/status")
    @ApiOperation(value="Gets the status for a process group", notes="The status for a process group includes status for all descendent components. When invoked on the root group with recursive set to true, it will return the current status of every component in the flow.", response=ProcessGroupStatusEntity.class, authorizations={@Authorization(value="Read - /flow", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getProcessGroupStatus(@ApiParam(value="Whether all descendant groups and the status of their content will be included. Optional, defaults to false", required=false) @QueryParam(value="recursive") @DefaultValue(value="false") Boolean recursive, @ApiParam(value="Whether or not to include the breakdown per node. Optional, defaults to false", required=false) @QueryParam(value="nodewise") @DefaultValue(value="false") Boolean nodewise, @ApiParam(value="The id of the node where to get the status.", required=false) @QueryParam(value="clusterNodeId") String clusterNodeId, @ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId) throws InterruptedException {
        this.authorizeFlow();
        if (Boolean.TRUE.equals(nodewise) && clusterNodeId != null) {
            throw new IllegalArgumentException("Nodewise requests cannot be directed at a specific node.");
        }
        if (this.isReplicateRequest()) {
            if (clusterNodeId == null) {
                NodeResponse nodeResponse = this.replicateNodeResponse("GET");
                ProcessGroupStatusEntity entity = (ProcessGroupStatusEntity)nodeResponse.getUpdatedEntity();
                if (entity != null && !nodewise.booleanValue()) {
                    entity.getProcessGroupStatus().setNodeSnapshots(null);
                }
                return nodeResponse.getResponse();
            }
            return this.replicate("GET", clusterNodeId);
        }
        ProcessGroupStatusEntity entity = this.serviceFacade.getProcessGroupStatus(groupId, recursive.booleanValue());
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="connections/{id}/status")
    @ApiOperation(value="Gets status for a connection", response=ConnectionStatusEntity.class, authorizations={@Authorization(value="Read - /flow", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getConnectionStatus(@ApiParam(value="Whether or not to include the breakdown per node. Optional, defaults to false", required=false) @QueryParam(value="nodewise") @DefaultValue(value="false") Boolean nodewise, @ApiParam(value="The id of the node where to get the status.", required=false) @QueryParam(value="clusterNodeId") String clusterNodeId, @ApiParam(value="The connection id.", required=true) @PathParam(value="id") String id) throws InterruptedException {
        this.authorizeFlow();
        if (Boolean.TRUE.equals(nodewise) && clusterNodeId != null) {
            throw new IllegalArgumentException("Nodewise requests cannot be directed at a specific node.");
        }
        if (this.isReplicateRequest()) {
            if (clusterNodeId == null) {
                NodeResponse nodeResponse = this.replicateNodeResponse("GET");
                ConnectionStatusEntity entity = (ConnectionStatusEntity)nodeResponse.getUpdatedEntity();
                if (entity != null && !nodewise.booleanValue()) {
                    entity.getConnectionStatus().setNodeSnapshots(null);
                }
                return nodeResponse.getResponse();
            }
            return this.replicate("GET", clusterNodeId);
        }
        ConnectionStatusEntity entity = this.serviceFacade.getConnectionStatus(id);
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="processors/{id}/status/history")
    @ApiOperation(value="Gets status history for a processor", response=StatusHistoryEntity.class, authorizations={@Authorization(value="Read - /flow", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getProcessorStatusHistory(@ApiParam(value="The processor id.", required=true) @PathParam(value="id") String id) throws InterruptedException {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        StatusHistoryEntity entity = this.serviceFacade.getProcessorStatusHistory(id);
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="process-groups/{id}/status/history")
    @ApiOperation(value="Gets status history for a remote process group", response=StatusHistoryEntity.class, authorizations={@Authorization(value="Read - /flow", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getProcessGroupStatusHistory(@ApiParam(value="The process group id.", required=true) @PathParam(value="id") String groupId) throws InterruptedException {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        StatusHistoryEntity entity = this.serviceFacade.getProcessGroupStatusHistory(groupId);
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="remote-process-groups/{id}/status/history")
    @ApiOperation(value="Gets the status history", response=StatusHistoryEntity.class, authorizations={@Authorization(value="Read - /flow", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getRemoteProcessGroupStatusHistory(@ApiParam(value="The remote process group id.", required=true) @PathParam(value="id") String id) throws InterruptedException {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        StatusHistoryEntity entity = this.serviceFacade.getRemoteProcessGroupStatusHistory(id);
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="connections/{id}/status/history")
    @ApiOperation(value="Gets the status history for a connection", response=StatusHistoryEntity.class, authorizations={@Authorization(value="Read - /flow", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getConnectionStatusHistory(@ApiParam(value="The connection id.", required=true) @PathParam(value="id") String id) throws InterruptedException {
        this.authorizeFlow();
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        StatusHistoryEntity entity = this.serviceFacade.getConnectionStatusHistory(id);
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="history")
    @ApiOperation(value="Gets configuration history", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=HistoryEntity.class, authorizations={@Authorization(value="Read - /flow", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response queryHistory(@ApiParam(value="The offset into the result set.", required=true) @QueryParam(value="offset") IntegerParameter offset, @ApiParam(value="The number of actions to return.", required=true) @QueryParam(value="count") IntegerParameter count, @ApiParam(value="The field to sort on.", required=false) @QueryParam(value="sortColumn") String sortColumn, @ApiParam(value="The direction to sort.", required=false) @QueryParam(value="sortOrder") String sortOrder, @ApiParam(value="Include actions after this date.", required=false) @QueryParam(value="startDate") DateTimeParameter startDate, @ApiParam(value="Include actions before this date.", required=false) @QueryParam(value="endDate") DateTimeParameter endDate, @ApiParam(value="Include actions performed by this user.", required=false) @QueryParam(value="userIdentity") String userIdentity, @ApiParam(value="Include actions on this component.", required=false) @QueryParam(value="sourceId") String sourceId) {
        this.authorizeFlow();
        if (offset == null) {
            throw new IllegalArgumentException("The desired offset must be specified.");
        }
        if (offset.getInteger() < 0) {
            throw new IllegalArgumentException("The desired offset must be an integer value greater than or equal to 0.");
        }
        if (count == null) {
            throw new IllegalArgumentException("The desired row count must be specified.");
        }
        if (count.getInteger() < 1) {
            throw new IllegalArgumentException("The desired row count must be an integer value greater than 0.");
        }
        if (sortOrder != null && !sortOrder.equalsIgnoreCase("asc") && !sortOrder.equalsIgnoreCase("desc")) {
            throw new IllegalArgumentException("The sort order must be 'asc' or 'desc'.");
        }
        if (endDate != null && startDate != null && endDate.getDateTime().before(startDate.getDateTime())) {
            throw new IllegalArgumentException("The start date/time must come before the end date/time.");
        }
        HistoryQueryDTO query = new HistoryQueryDTO();
        query.setSortColumn(sortColumn);
        query.setSortOrder(sortOrder);
        query.setOffset(offset.getInteger());
        query.setCount(count.getInteger());
        if (startDate != null) {
            query.setStartDate(startDate.getDateTime());
        }
        if (endDate != null) {
            query.setEndDate(endDate.getDateTime());
        }
        if (userIdentity != null) {
            query.setUserIdentity(userIdentity);
        }
        if (sourceId != null) {
            query.setSourceId(sourceId);
        }
        HistoryDTO history = this.serviceFacade.getActions(query);
        HistoryEntity entity = new HistoryEntity();
        entity.setHistory(history);
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="history/{id}")
    @ApiOperation(value="Gets an action", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=ActionEntity.class, authorizations={@Authorization(value="Read - /flow", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getAction(@ApiParam(value="The action id.", required=true) @PathParam(value="id") IntegerParameter id) {
        this.authorizeFlow();
        if (id == null) {
            throw new IllegalArgumentException("The action id must be specified.");
        }
        ActionEntity entity = this.serviceFacade.getAction(id.getInteger());
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="history/components/{componentId}")
    @ApiOperation(value="Gets configuration history for a component", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=ComponentHistoryEntity.class, authorizations={@Authorization(value="Read - /flow", type=""), @Authorization(value="Read underlying component - /{component-type}/{uuid}", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getComponentHistory(@ApiParam(value="The component id.", required=true) @PathParam(value="componentId") String componentId) {
        this.serviceFacade.authorizeAccess(lookup -> {
            NiFiUser user = NiFiUserUtils.getNiFiUser();
            this.authorizeFlow();
            try {
                Authorizable authorizable = lookup.getProcessor(componentId).getAuthorizable();
                authorizable.authorize(this.authorizer, RequestAction.READ, user);
                return;
            }
            catch (ResourceNotFoundException authorizable) {
                try {
                    Authorizable authorizable2 = lookup.getControllerService(componentId).getAuthorizable();
                    authorizable2.authorize(this.authorizer, RequestAction.READ, user);
                    return;
                }
                catch (ResourceNotFoundException authorizable2) {
                    try {
                        Authorizable authorizable3 = lookup.getReportingTask(componentId).getAuthorizable();
                        authorizable3.authorize(this.authorizer, RequestAction.READ, user);
                        return;
                    }
                    catch (ResourceNotFoundException authorizable3) {
                        HashMap<String, String> userContext;
                        if (!StringUtils.isBlank((CharSequence)user.getClientAddress())) {
                            userContext = new HashMap<String, String>();
                            userContext.put(UserContextKeys.CLIENT_ADDRESS.name(), user.getClientAddress());
                        } else {
                            userContext = null;
                        }
                        AuthorizationRequest request = new AuthorizationRequest.Builder().resource(ResourceFactory.getControllerResource()).identity(user.getIdentity()).anonymous(Boolean.valueOf(user.isAnonymous())).accessAttempt(Boolean.valueOf(true)).action(RequestAction.READ).userContext(userContext).explanationSupplier(() -> String.format("Unable to find component with id '%s' and unable to view the controller.", componentId)).build();
                        AuthorizationResult result = this.authorizer.authorize(request);
                        if (!AuthorizationResult.Result.Approved.equals((Object)result.getResult())) {
                            throw new AccessDeniedException(result.getExplanation());
                        }
                        return;
                    }
                }
            }
        });
        ComponentHistoryEntity entity = new ComponentHistoryEntity();
        entity.setComponentHistory(this.serviceFacade.getComponentHistory(componentId));
        return this.generateOkResponse((Object)entity).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="templates")
    @ApiOperation(value="Gets all templates", response=TemplatesEntity.class, authorizations={@Authorization(value="Read - /flow", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response getTemplates() {
        if (this.isReplicateRequest()) {
            return this.replicate("GET");
        }
        this.authorizeFlow();
        Set templates = this.serviceFacade.getTemplates();
        this.templateResource.populateRemainingTemplateEntitiesContent(templates);
        TemplatesEntity entity = new TemplatesEntity();
        entity.setTemplates(templates);
        entity.setGenerated(new Date());
        return this.clusterContext(this.generateOkResponse((Object)entity)).build();
    }

    @GET
    @Consumes(value={"*/*"})
    @Produces(value={"application/json"})
    @Path(value="cluster/search-results")
    @ApiOperation(value="Searches the cluster for a node with the specified address", notes="Note: This endpoint is subject to change as NiFi and it's REST API evolve.", response=ClusterSearchResultsEntity.class, authorizations={@Authorization(value="Read - /flow", type="")})
    @ApiResponses(value={@ApiResponse(code=400, message="NiFi was unable to complete the request because it was invalid. The request should not be retried without modification."), @ApiResponse(code=401, message="Client could not be authenticated."), @ApiResponse(code=403, message="Client is not authorized to make this request."), @ApiResponse(code=404, message="The specified resource could not be found."), @ApiResponse(code=409, message="The request was valid but NiFi was not in the appropriate state to process it. Retrying the same request later may be successful.")})
    public Response searchCluster(@ApiParam(value="Node address to search for.", required=true) @QueryParam(value="q") @DefaultValue(value="") String value) {
        this.authorizeFlow();
        if (!this.isConnectedToCluster()) {
            throw new IllegalClusterResourceRequestException("Only a node connected to a cluster can process the request.");
        }
        ArrayList<NodeSearchResultDTO> nodeMatches = new ArrayList<NodeSearchResultDTO>();
        ClusterDTO cluster = this.serviceFacade.getCluster();
        for (NodeDTO node : cluster.getNodes()) {
            if (!NodeConnectionState.CONNECTED.name().equals(node.getStatus())) continue;
            String address = node.getAddress() + ":" + node.getApiPort();
            if (!StringUtils.isBlank((CharSequence)value) && !StringUtils.containsIgnoreCase((CharSequence)address, (CharSequence)value)) continue;
            NodeSearchResultDTO nodeMatch = new NodeSearchResultDTO();
            nodeMatch.setId(node.getNodeId());
            nodeMatch.setAddress(address);
            nodeMatches.add(nodeMatch);
        }
        ClusterSearchResultsEntity results = new ClusterSearchResultsEntity();
        results.setNodeResults(nodeMatches);
        return this.noCache(Response.ok((Object)results)).build();
    }

    public void setServiceFacade(NiFiServiceFacade serviceFacade) {
        this.serviceFacade = serviceFacade;
    }

    public void setProcessorResource(ProcessorResource processorResource) {
        this.processorResource = processorResource;
    }

    public void setInputPortResource(InputPortResource inputPortResource) {
        this.inputPortResource = inputPortResource;
    }

    public void setOutputPortResource(OutputPortResource outputPortResource) {
        this.outputPortResource = outputPortResource;
    }

    public void setFunnelResource(FunnelResource funnelResource) {
        this.funnelResource = funnelResource;
    }

    public void setLabelResource(LabelResource labelResource) {
        this.labelResource = labelResource;
    }

    public void setRemoteProcessGroupResource(RemoteProcessGroupResource remoteProcessGroupResource) {
        this.remoteProcessGroupResource = remoteProcessGroupResource;
    }

    public void setConnectionResource(ConnectionResource connectionResource) {
        this.connectionResource = connectionResource;
    }

    public void setTemplateResource(TemplateResource templateResource) {
        this.templateResource = templateResource;
    }

    public void setProcessGroupResource(ProcessGroupResource processGroupResource) {
        this.processGroupResource = processGroupResource;
    }

    public void setControllerServiceResource(ControllerServiceResource controllerServiceResource) {
        this.controllerServiceResource = controllerServiceResource;
    }

    public void setReportingTaskResource(ReportingTaskResource reportingTaskResource) {
        this.reportingTaskResource = reportingTaskResource;
    }

    public void setAuthorizer(Authorizer authorizer) {
        this.authorizer = authorizer;
    }
}

