/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.audit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.action.Action;
import org.apache.nifi.action.Component;
import org.apache.nifi.action.FlowChangeAction;
import org.apache.nifi.action.Operation;
import org.apache.nifi.action.component.details.ComponentDetails;
import org.apache.nifi.action.component.details.FlowChangeExtensionDetails;
import org.apache.nifi.action.details.ActionDetails;
import org.apache.nifi.action.details.FlowChangeConfigureDetails;
import org.apache.nifi.audit.NiFiAuditor;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.authorization.user.NiFiUserUtils;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ConfiguredComponent;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.ScheduledState;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceReference;
import org.apache.nifi.controller.service.ControllerServiceState;
import org.apache.nifi.reporting.ReportingTask;
import org.apache.nifi.web.api.dto.ControllerServiceDTO;
import org.apache.nifi.web.dao.ControllerServiceDAO;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Aspect
public class ControllerServiceAuditor
extends NiFiAuditor {
    private static final Logger logger = LoggerFactory.getLogger(ControllerServiceAuditor.class);
    private static final String COMMENTS = "Comments";
    private static final String NAME = "Name";
    private static final String ANNOTATION_DATA = "Annotation Data";
    private static final String EXTENSION_VERSION = "Extension Version";

    @Around(value="within(org.apache.nifi.web.dao.ControllerServiceDAO+) && execution(org.apache.nifi.controller.service.ControllerServiceNode createControllerService(org.apache.nifi.web.api.dto.ControllerServiceDTO))")
    public ControllerServiceNode createControllerServiceAdvice(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        ControllerServiceNode controllerService = (ControllerServiceNode)proceedingJoinPoint.proceed();
        Action action = this.generateAuditRecord(controllerService, Operation.Add);
        if (action != null) {
            this.saveAction(action, logger);
        }
        return controllerService;
    }

    @Around(value="within(org.apache.nifi.web.dao.ControllerServiceDAO+) && execution(org.apache.nifi.controller.service.ControllerServiceNode updateControllerService(org.apache.nifi.web.api.dto.ControllerServiceDTO)) && args(controllerServiceDTO) && target(controllerServiceDAO)")
    public Object updateControllerServiceAdvice(ProceedingJoinPoint proceedingJoinPoint, ControllerServiceDTO controllerServiceDTO, ControllerServiceDAO controllerServiceDAO) throws Throwable {
        ControllerServiceNode controllerService = controllerServiceDAO.getControllerService(controllerServiceDTO.getId());
        Map values = this.extractConfiguredPropertyValues(controllerService, controllerServiceDTO);
        boolean isDisabled = this.isDisabled(controllerService);
        ControllerServiceNode updatedControllerService = (ControllerServiceNode)proceedingJoinPoint.proceed();
        controllerService = controllerServiceDAO.getControllerService(updatedControllerService.getIdentifier());
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user != null) {
            Map updatedValues = this.extractConfiguredPropertyValues(controllerService, controllerServiceDTO);
            FlowChangeExtensionDetails serviceDetails = new FlowChangeExtensionDetails();
            serviceDetails.setType(controllerService.getComponentType());
            Date actionTimestamp = new Date();
            ArrayList<FlowChangeAction> actions = new ArrayList<FlowChangeAction>();
            for (String property : updatedValues.keySet()) {
                String newValue = (String)updatedValues.get(property);
                String oldValue = (String)values.get(property);
                Operation operation = null;
                if (oldValue == null || newValue == null || !newValue.equals(oldValue)) {
                    operation = Operation.Configure;
                }
                if (operation == null) continue;
                PropertyDescriptor propertyDescriptor = controllerService.getControllerServiceImplementation().getPropertyDescriptor(property);
                if (propertyDescriptor != null && propertyDescriptor.isSensitive()) {
                    if (newValue != null) {
                        newValue = "********";
                    }
                    if (oldValue != null) {
                        oldValue = "********";
                    }
                } else if (ANNOTATION_DATA.equals(property)) {
                    if (newValue != null) {
                        newValue = "<annotation data not shown>";
                    }
                    if (oldValue != null) {
                        oldValue = "<annotation data not shown>";
                    }
                }
                FlowChangeConfigureDetails actionDetails = new FlowChangeConfigureDetails();
                actionDetails.setName(property);
                actionDetails.setValue(newValue);
                actionDetails.setPreviousValue(oldValue);
                FlowChangeAction configurationAction = new FlowChangeAction();
                configurationAction.setUserIdentity(user.getIdentity());
                configurationAction.setOperation(operation);
                configurationAction.setTimestamp(actionTimestamp);
                configurationAction.setSourceId(controllerService.getIdentifier());
                configurationAction.setSourceName(controllerService.getName());
                configurationAction.setSourceType(Component.ControllerService);
                configurationAction.setComponentDetails((ComponentDetails)serviceDetails);
                configurationAction.setActionDetails((ActionDetails)actionDetails);
                actions.add(configurationAction);
            }
            boolean updateIsDisabled = this.isDisabled(updatedControllerService);
            if (isDisabled != updateIsDisabled) {
                FlowChangeAction serviceAction = new FlowChangeAction();
                serviceAction.setUserIdentity(user.getIdentity());
                serviceAction.setTimestamp(new Date());
                serviceAction.setSourceId(controllerService.getIdentifier());
                serviceAction.setSourceName(controllerService.getName());
                serviceAction.setSourceType(Component.ControllerService);
                serviceAction.setComponentDetails((ComponentDetails)serviceDetails);
                if (updateIsDisabled) {
                    serviceAction.setOperation(Operation.Disable);
                } else {
                    serviceAction.setOperation(Operation.Enable);
                }
                actions.add(serviceAction);
            }
            if (!actions.isEmpty()) {
                this.saveActions(actions, logger);
            }
        }
        return updatedControllerService;
    }

    @Around(value="within(org.apache.nifi.web.dao.ControllerServiceDAO+) && execution(org.apache.nifi.controller.service.ControllerServiceReference updateControllerServiceReferencingComponents(java.lang.String, org.apache.nifi.controller.ScheduledState, org.apache.nifi.controller.service.ControllerServiceState))")
    public Object updateControllerServiceReferenceAdvice(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        ControllerServiceReference controllerServiceReference = (ControllerServiceReference)proceedingJoinPoint.proceed();
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user != null) {
            ArrayList actions = new ArrayList();
            ArrayList<String> visitedServices = new ArrayList<String>();
            visitedServices.add(controllerServiceReference.getReferencedComponent().getIdentifier());
            this.getUpdateActionsForReferencingComponents(user, actions, visitedServices, controllerServiceReference.getReferencingComponents());
            if (!actions.isEmpty()) {
                this.saveActions(actions, logger);
            }
        }
        return controllerServiceReference;
    }

    private void getUpdateActionsForReferencingComponents(NiFiUser user, Collection<Action> actions, Collection<String> visitedServices, Set<ConfiguredComponent> referencingComponents) {
        for (ConfiguredComponent component : referencingComponents) {
            if (component instanceof ProcessorNode) {
                ProcessorNode processor = (ProcessorNode)component;
                FlowChangeExtensionDetails processorDetails = new FlowChangeExtensionDetails();
                processorDetails.setType(processor.getComponentType());
                FlowChangeAction processorAction = new FlowChangeAction();
                processorAction.setUserIdentity(user.getIdentity());
                processorAction.setTimestamp(new Date());
                processorAction.setSourceId(processor.getIdentifier());
                processorAction.setSourceName(processor.getName());
                processorAction.setSourceType(Component.Processor);
                processorAction.setComponentDetails((ComponentDetails)processorDetails);
                processorAction.setOperation(ScheduledState.RUNNING.equals((Object)processor.getScheduledState()) ? Operation.Start : Operation.Stop);
                actions.add((Action)processorAction);
                continue;
            }
            if (component instanceof ReportingTask) {
                ReportingTaskNode reportingTask = (ReportingTaskNode)component;
                FlowChangeExtensionDetails taskDetails = new FlowChangeExtensionDetails();
                taskDetails.setType(reportingTask.getComponentType());
                FlowChangeAction reportingTaskAction = new FlowChangeAction();
                reportingTaskAction.setUserIdentity(user.getIdentity());
                reportingTaskAction.setTimestamp(new Date());
                reportingTaskAction.setSourceId(reportingTask.getIdentifier());
                reportingTaskAction.setSourceName(reportingTask.getName());
                reportingTaskAction.setSourceType(Component.ReportingTask);
                reportingTaskAction.setComponentDetails((ComponentDetails)taskDetails);
                reportingTaskAction.setOperation(ScheduledState.RUNNING.equals((Object)reportingTask.getScheduledState()) ? Operation.Start : Operation.Stop);
                actions.add((Action)reportingTaskAction);
                continue;
            }
            if (!(component instanceof ControllerServiceNode)) continue;
            ControllerServiceNode controllerService = (ControllerServiceNode)component;
            FlowChangeExtensionDetails serviceDetails = new FlowChangeExtensionDetails();
            serviceDetails.setType(controllerService.getComponentType());
            FlowChangeAction serviceAction = new FlowChangeAction();
            serviceAction.setUserIdentity(user.getIdentity());
            serviceAction.setTimestamp(new Date());
            serviceAction.setSourceId(controllerService.getIdentifier());
            serviceAction.setSourceName(controllerService.getName());
            serviceAction.setSourceType(Component.ControllerService);
            serviceAction.setComponentDetails((ComponentDetails)serviceDetails);
            serviceAction.setOperation(this.isDisabled(controllerService) ? Operation.Disable : Operation.Enable);
            actions.add((Action)serviceAction);
            if (visitedServices.contains(controllerService.getIdentifier())) continue;
            this.getUpdateActionsForReferencingComponents(user, actions, visitedServices, controllerService.getReferences().getReferencingComponents());
        }
    }

    @Around(value="within(org.apache.nifi.web.dao.ControllerServiceDAO+) && execution(void deleteControllerService(java.lang.String)) && args(controllerServiceId) && target(controllerServiceDAO)")
    public void removeControllerServiceAdvice(ProceedingJoinPoint proceedingJoinPoint, String controllerServiceId, ControllerServiceDAO controllerServiceDAO) throws Throwable {
        ControllerServiceNode controllerService = controllerServiceDAO.getControllerService(controllerServiceId);
        proceedingJoinPoint.proceed();
        Action action = this.generateAuditRecord(controllerService, Operation.Remove);
        if (action != null) {
            this.saveAction(action, logger);
        }
    }

    private Action generateAuditRecord(ControllerServiceNode controllerService, Operation operation) {
        return this.generateAuditRecord(controllerService, operation, null);
    }

    private Action generateAuditRecord(ControllerServiceNode controllerService, Operation operation, ActionDetails actionDetails) {
        FlowChangeAction action = null;
        NiFiUser user = NiFiUserUtils.getNiFiUser();
        if (user != null) {
            FlowChangeExtensionDetails serviceDetails = new FlowChangeExtensionDetails();
            serviceDetails.setType(controllerService.getComponentType());
            action = new FlowChangeAction();
            action.setUserIdentity(user.getIdentity());
            action.setOperation(operation);
            action.setTimestamp(new Date());
            action.setSourceId(controllerService.getIdentifier());
            action.setSourceName(controllerService.getName());
            action.setSourceType(Component.ControllerService);
            action.setComponentDetails((ComponentDetails)serviceDetails);
            if (actionDetails != null) {
                action.setActionDetails(actionDetails);
            }
        }
        return action;
    }

    private Map<String, String> extractConfiguredPropertyValues(ControllerServiceNode controllerService, ControllerServiceDTO controllerServiceDTO) {
        HashMap<String, String> values = new HashMap<String, String>();
        if (controllerServiceDTO.getName() != null) {
            values.put(NAME, controllerService.getName());
        }
        if (controllerServiceDTO.getAnnotationData() != null) {
            values.put(ANNOTATION_DATA, controllerService.getAnnotationData());
        }
        if (controllerServiceDTO.getBundle() != null) {
            BundleCoordinate bundle = controllerService.getBundleCoordinate();
            values.put(EXTENSION_VERSION, this.formatExtensionVersion(controllerService.getComponentType(), bundle));
        }
        if (controllerServiceDTO.getProperties() != null) {
            Map properties = controllerServiceDTO.getProperties();
            Map configuredProperties = controllerService.getProperties();
            for (String propertyName : properties.keySet()) {
                PropertyDescriptor propertyDescriptor = new PropertyDescriptor.Builder().name(propertyName).build();
                String configuredPropertyValue = (String)configuredProperties.get(propertyDescriptor);
                if (configuredPropertyValue == null) {
                    propertyDescriptor = this.locatePropertyDescriptor(configuredProperties.keySet(), propertyDescriptor);
                    configuredPropertyValue = propertyDescriptor.getDefaultValue();
                }
                values.put(propertyName, configuredPropertyValue);
            }
        }
        if (controllerServiceDTO.getComments() != null) {
            values.put(COMMENTS, controllerService.getComments());
        }
        return values;
    }

    private PropertyDescriptor locatePropertyDescriptor(Set<PropertyDescriptor> propertyDescriptors, PropertyDescriptor specDescriptor) {
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (!propertyDescriptor.equals((Object)specDescriptor)) continue;
            return propertyDescriptor;
        }
        return specDescriptor;
    }

    private boolean isDisabled(ControllerServiceNode controllerService) {
        return ControllerServiceState.DISABLED.equals((Object)controllerService.getState()) || ControllerServiceState.DISABLING.equals((Object)controllerService.getState());
    }
}

