/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.search.attributematchers;

import java.util.List;
import org.apache.nifi.groups.ProcessGroup;
import org.apache.nifi.web.search.attributematchers.AttributeMatcher;
import org.apache.nifi.web.search.query.SearchQuery;

public class ProcessGroupMatcher
implements AttributeMatcher<ProcessGroup> {
    private static final String LABEL_ID = "Id";
    private static final String LABEL_VERSION_CONTROL_ID = "Version Control ID";
    private static final String LABEL_NAME = "Name";
    private static final String LABEL_COMMENTS = "Comments";

    public void match(ProcessGroup component, SearchQuery query, List<String> matches) {
        String searchTerm = query.getTerm();
        AttributeMatcher.addIfMatching((String)searchTerm, (String)component.getIdentifier(), (String)LABEL_ID, matches);
        AttributeMatcher.addIfMatching((String)searchTerm, (String)component.getVersionedComponentId().orElse(null), (String)LABEL_VERSION_CONTROL_ID, matches);
        AttributeMatcher.addIfMatching((String)searchTerm, (String)component.getName(), (String)LABEL_NAME, matches);
        AttributeMatcher.addIfMatching((String)searchTerm, (String)component.getComments(), (String)LABEL_COMMENTS, matches);
    }
}

