/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.web.api.metrics;

import io.prometheus.client.Collector;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FilteringMetricFamilySamplesEnumeration
implements Enumeration<Collector.MetricFamilySamples> {
    private final Enumeration<Collector.MetricFamilySamples> metricFamilySamples;
    private final Pattern sampleNamePattern;
    private final Pattern sampleLabelValuePattern;
    private Collector.MetricFamilySamples nextElement;

    public FilteringMetricFamilySamplesEnumeration(Enumeration<Collector.MetricFamilySamples> metricFamilySamples, Pattern sampleNamePattern, Pattern sampleLabelValuePattern) {
        this.metricFamilySamples = Objects.requireNonNull(metricFamilySamples);
        this.sampleNamePattern = sampleNamePattern;
        this.sampleLabelValuePattern = sampleLabelValuePattern;
        this.setNextElement();
    }

    @Override
    public boolean hasMoreElements() {
        return this.nextElement != null;
    }

    @Override
    public Collector.MetricFamilySamples nextElement() {
        if (this.nextElement == null) {
            throw new NoSuchElementException();
        }
        Collector.MetricFamilySamples currentElement = this.nextElement;
        this.setNextElement();
        return currentElement;
    }

    private void setNextElement() {
        this.nextElement = null;
        while (this.metricFamilySamples.hasMoreElements()) {
            Collector.MetricFamilySamples possibleNextElement = (Collector.MetricFamilySamples)this.metricFamilySamples.nextElement();
            possibleNextElement.samples.removeIf(arg_0 -> this.isSampleNotMatched(arg_0));
            if (possibleNextElement.samples.size() == 0) continue;
            this.nextElement = possibleNextElement;
            break;
        }
    }

    private boolean isSampleNotMatched(Collector.MetricFamilySamples.Sample sample) {
        boolean notMatched = false;
        if (this.sampleNamePattern == null) {
            notMatched = this.isSampleLabelValueNotMatched(sample);
        } else if (this.sampleLabelValuePattern == null) {
            notMatched = this.isSampleNameNotMatched(sample);
        } else if (this.isSampleNameNotMatched(sample) && this.isSampleLabelValueNotMatched(sample)) {
            notMatched = true;
        }
        return notMatched;
    }

    private boolean isSampleNameNotMatched(Collector.MetricFamilySamples.Sample sample) {
        Matcher sampleNameMatcher = this.sampleNamePattern.matcher(sample.name);
        return !sampleNameMatcher.matches();
    }

    private boolean isSampleLabelValueNotMatched(Collector.MetricFamilySamples.Sample sample) {
        boolean notMatched = true;
        for (String labelValue : sample.labelValues) {
            Matcher sampleLabelValueMatcher = this.sampleLabelValuePattern.matcher(labelValue);
            if (!sampleLabelValueMatcher.matches()) continue;
            notMatched = false;
            break;
        }
        return notMatched;
    }
}

