/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.aop;

import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodProfiler {
    private static final Logger logger = LoggerFactory.getLogger(MethodProfiler.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object profileMethod(ProceedingJoinPoint call) throws Throwable {
        long startTime = System.nanoTime();
        try {
            Object object = call.proceed();
            return object;
        }
        finally {
            if (logger.isDebugEnabled()) {
                long endTime = System.nanoTime();
                long durationMilliseconds = (endTime - startTime) / 1000000L;
                String methodCall = call.getSignature().toLongString();
                logger.debug("'" + methodCall + "' Time to complete call (ms): " + durationMilliseconds);
            }
        }
    }
}

